/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.dao;

import java.util.List;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Timestamped;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openscdp.pkidb.dto.TokenDTO;

@RegisterBeanMapper(value=TokenDTO.class)
public interface TokenDAO
extends SqlObject {
    @SqlUpdate(value="INSERT INTO Token (path, subjectId, lastSeenAt, serviceRequestId, type, managedByRoleId, hardware, certId) VALUES(:path, :subjectId, :lastSeenAt, :serviceRequestId, :type, :managedByRoleId, :hardware, :certId)")
    @GetGeneratedKeys(value={"id"})
    public Long insert(@BindBean TokenDTO var1);

    default public Long create(TokenDTO token) {
        Long id = this.insert(token);
        token.setId(id);
        return id;
    }

    @SqlQuery(value="SELECT * FROM Token WHERE id = ?")
    public TokenDTO getToken(Long var1);

    @SqlQuery(value="SELECT * FROM Token WHERE path = ?")
    public TokenDTO getToken(String var1);

    @SqlQuery(value="SELECT * FROM Token WHERE subjectId = ?")
    public List<TokenDTO> getTokenList(Long var1);

    @SqlUpdate(value="UPDATE Token SET path = :path, serviceRequestId = :serviceRequestId, type = :type WHERE id = :id")
    public void updateAfterUpdate(@BindBean TokenDTO var1);

    @SqlUpdate(value="UPDATE Token SET lastSeen = :now, lastSeenAt = :lastSeenAt, type = :type, certId = :certId WHERE path = :path")
    @Timestamped
    public void updateMetaData(@BindBean TokenDTO var1);

    @SqlUpdate(value="UPDATE Token SET lastSeen = :now, online = :online WHERE path = :path")
    @Timestamped
    public void updateOnlineStatus(@Bind(value="path") String var1, @Bind(value="online") int var2);
}

