/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.dao;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openscdp.pkidb.Filter;
import org.openscdp.pkidb.Order;
import org.openscdp.pkidb.dao.FilteredQuery;
import org.openscdp.pkidb.dao.FilteredQueryException;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.ServiceRequestStateDTO;

@RegisterBeanMapper(value=ServiceRequestDTO.class)
public interface ServiceRequestDAO
extends SqlObject,
FilteredQuery {
    @SqlUpdate(value="INSERT INTO ServiceRequest (parentServiceRequestId, process, title, details, state, originatorId, recipientId, messageId, assignedToRole, due, content) VALUES (:parentServiceRequestId, :process, :title, :details, :state, :originatorId, :recipientId, :messageId, :assignedToRole, :due, :content)")
    @GetGeneratedKeys(value={"id"})
    public Long insert(@BindBean ServiceRequestDTO var1);

    default public ServiceRequestDTO create(ServiceRequestDTO sr) {
        Long id = this.insert(sr);
        sr.setId(id);
        return sr;
    }

    @SqlUpdate(value="UPDATE ServiceRequest SET parentServiceRequestId = :parentServiceRequestId, process = :process, title = :title, details = :details, state = :state, lifecycle = :lifecycle, originatorId = :originatorId, recipientId = :recipientId, messageId = :messageId, assignedToRole = :assignedToRole, due = :due, content = :content WHERE id = :id")
    public void update(@BindBean ServiceRequestDTO var1);

    @SqlUpdate(value="UPDATE ServiceRequest SET messageId = ? WHERE id = ?")
    public void updateMessageId(String var1, Long var2);

    @SqlUpdate(value="UPDATE ServiceRequest SET details = ? WHERE id = ?")
    public void updateDetails(String var1, Long var2);

    @SqlQuery(value="SELECT * FROM ServiceRequest WHERE id = ?")
    public ServiceRequestDTO getServiceRequest(Long var1);

    @SqlQuery(value="SELECT * FROM ServiceRequest WHERE originatorId = ? and recipientId = ? and process = ?")
    public ServiceRequestDTO getServiceRequestLink(Long var1, Long var2, String var3);

    @SqlQuery(value="SELECT * FROM ServiceRequest WHERE messageId like ?")
    public ServiceRequestDTO getServiceRequestByMessageId(String var1);

    default public List<ServiceRequestDTO> getServiceRequests(List<Filter> filters, List<Order> order, Long limit, Long offset) throws FilteredQueryException {
        for (Filter f : filters) {
            if (f.validateKey(ServiceRequestDTO.class)) continue;
            throw new FilteredQueryException("Validation of filter " + String.valueOf(f) + " with " + ServiceRequestDTO.class.getName() + " failed");
        }
        for (Order o : order) {
            if (o.validateOrderBy(ServiceRequestDTO.class)) continue;
            throw new FilteredQueryException("Validation of Order " + String.valueOf(o) + " with " + ServiceRequestDTO.class.getName() + " failed");
        }
        Handle handle = this.getHandle();
        handle.begin();
        String sql = "SELECT * FROM ServiceRequest";
        Query query = this.getQuery(handle, sql, filters, order, limit, offset);
        List res = query.mapTo(ServiceRequestDTO.class).list();
        handle.commit();
        return res;
    }

    default public Long getServiceRequestCount(List<Filter> filters) throws FilteredQueryException {
        for (Filter f : filters) {
            if (f.validateKey(ServiceRequestDTO.class)) continue;
            throw new FilteredQueryException("Validation of filter " + String.valueOf(f) + " with " + ServiceRequestDTO.class.getName() + " failed");
        }
        Handle handle = this.getHandle();
        handle.begin();
        String sql = "SELECT COUNT(id) FROM ServiceRequest";
        Query query = this.getQuery(handle, sql, filters, null, null, null);
        Long count = (Long)query.mapTo(Long.class).one();
        handle.commit();
        return count;
    }

    default public List<ServiceRequestDTO> getInvolvedServiceRequests(Long subjectId, List<Filter> filters, List<Order> order, Long limit, Long offset) throws FilteredQueryException {
        Handle handle = this.getHandle();
        handle.begin();
        String select = "SELECT * FROM ServiceRequest";
        Query query = this.getInvolvedServiceRequests(handle, select, subjectId, filters, order, limit, offset);
        List res = query.mapTo(ServiceRequestDTO.class).list();
        handle.commit();
        return res;
    }

    default public Long getInvolvedServiceRequestCount(Long subjectId, List<Filter> filters) throws FilteredQueryException {
        Handle handle = this.getHandle();
        handle.begin();
        String select = "SELECT COUNT(id) FROM ServiceRequest";
        Query query = this.getInvolvedServiceRequests(handle, select, subjectId, filters, null, null, null);
        Long count = (Long)query.mapTo(Long.class).one();
        handle.commit();
        return count;
    }

    private Query getInvolvedServiceRequests(Handle handle, String select, Long subjectId, List<Filter> filters, List<Order> order, Long limit, Long offset) throws FilteredQueryException {
        Object where;
        if (filters != null) {
            for (Filter f : filters) {
                if (f.validateKey(ServiceRequestDTO.class)) continue;
                throw new FilteredQueryException("Validation of filter " + String.valueOf(f) + " with " + ServiceRequestDTO.class.getName() + " failed");
            }
        }
        if (order != null) {
            for (Order o : order) {
                if (o.validateOrderBy(ServiceRequestDTO.class)) continue;
                throw new FilteredQueryException("Validation of Order " + String.valueOf(o) + " with " + ServiceRequestDTO.class.getName() + " failed");
            }
        }
        where = ((String)(where = this.getWhereClauseFromFilter(filters))).length() == 0 ? " WHERE " : (String)where + " and";
        where = (String)where + " (originatorId = ?";
        where = (String)where + " or assignedToRole in (select roleId from AssignedRole where subjectId = ?) ";
        where = (String)where + " or id in (select distinct serviceRequestId from ServiceRequestState where caseHandlerId = ?";
        where = (String)where + " or caseHandlerRole in (select roleId from AssignedRole where subjectId = ?)))";
        Object sql = select;
        sql = (String)sql + (String)where;
        if (order != null) {
            sql = (String)sql + this.getOrderByClause(order);
        }
        if (limit != null) {
            sql = (String)sql + " LIMIT " + limit;
        }
        if (offset != null) {
            sql = (String)sql + " OFFSET " + offset;
        }
        Query query = handle.createQuery((String)sql);
        int i = 0;
        for (Filter f : filters) {
            query = (Query)query.bind(i++, f.getValue());
        }
        query = (Query)query.bind(i++, subjectId);
        query = (Query)query.bind(i++, subjectId);
        query = (Query)query.bind(i++, subjectId);
        query = (Query)query.bind(i++, subjectId);
        return query;
    }

    default public void addLifeCycleTransition(ServiceRequestDTO sr, Long caseHandlerSubjectId, String content) {
        Handle handle = this.getHandle();
        handle.begin();
        Long id = (Long)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO ServiceRequestState (serviceRequestId, lifecycle, state, caseHandlerId, caseHandlerRole, content) VALUES (?, ?, ?, ?, ?, ?)").bind(0, sr.getId())).bind(1, sr.getLifecycle())).bind(2, sr.getState())).bind(3, caseHandlerSubjectId)).bind(4, sr.getAssignedToRole())).bind(5, content)).executeAndReturnGeneratedKeys(new String[]{"id"}).mapTo(Long.class).one();
        ((Update)((Update)((Update)((Update)((Update)handle.createUpdate("UPDATE ServiceRequest SET state = ?, lifecycle = ?, assignedToRole = ?, content = ? WHERE id = ?").bind(0, sr.getState())).bind(1, sr.getLifecycle())).bind(2, sr.getAssignedToRole())).bind(3, sr.getContent())).bind(4, sr.getId())).execute();
        handle.commit();
    }

    @SqlQuery(value="SELECT * FROM ServiceRequestState WHERE serviceRequestId = ?")
    @RegisterBeanMapper(value=ServiceRequestStateDTO.class)
    public List<ServiceRequestStateDTO> listServiceRequestStates(long var1);
}

