/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.utils.crypto;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class OID {
    private static final Map<String, String> MAP = new HashMap<String, String>();

    public static String getDescription(String oid) {
        return MAP.get(oid);
    }

    public static String getDescription(ASN1ObjectIdentifier oid) {
        return OID.getDescription(oid.getId());
    }

    static {
        MAP.put("1.2.840.113549.1.1.1", "PKCS#1 (Public Key Cryptography Standards - 1)");
        MAP.put("1.2.840.113549.1.1.2", "MD2 with RSA Encryption");
        MAP.put("1.2.840.113549.1.1.3", "PKCS #1 md4withRSAEncryption");
        MAP.put("1.2.840.113549.1.1.4", "RSA (PKCS #1 v1.5) with MD5 signature");
        MAP.put("1.2.840.113549.1.1.5", "RSA (PKCS #1 v1.5) with SHA-1 signature");
        MAP.put("1.2.840.113549.1.1.6", "RSA Optimal Asymmetric Encryption Padding (OAEP) encryption set.");
        MAP.put("1.2.840.113549.1.1.7", "id-RSAES-OAEP");
        MAP.put("1.2.840.113549.1.1.8", "id-mgf1 ");
        MAP.put("1.2.840.113549.1.1.9", "id-pSpecified");
        MAP.put("1.2.840.113549.1.1.10", "RSA Signature Scheme with Appendix - Probabilistic Signature Scheme (RSASSA-PSS)");
        MAP.put("1.2.840.113549.1.1.11", "SHA256 with RSA Encryption");
        MAP.put("1.2.840.113549.1.1.12", "SHA384 with RSA Encryption");
        MAP.put("1.2.840.113549.1.1.13", "SHA512 with RSA Encryption");
        MAP.put("1.2.840.113549.1.1.14", "sha224WithRSAEncryption");
        MAP.put("2.5.4.45", "x500UniqueIdentifier");
    }
}

