/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.utils.crypto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x500.style.RFC4519Style;

public class DFNStyle
extends BCStyle {
    public static final DFNStyle INSTANCE = new DFNStyle();
    public static final ASN1ObjectIdentifier x500UniqueIdentifier = RFC4519Style.x500UniqueIdentifier;
    public static final ASN1ObjectIdentifier subjectAltName = new ASN1ObjectIdentifier("2.5.29.17");
    public static final ASN1ObjectIdentifier GN = GIVENNAME;
    public static final ASN1ObjectIdentifier SN = SURNAME;
    public static final ArrayList<ASN1ObjectIdentifier> identifierInOrder = new ArrayList();
    private static final Comparator<RDN> rdnComparator;
    private static final Hashtable<String, ASN1ObjectIdentifier> DefaultLookUp;

    public String oidToDisplayName(ASN1ObjectIdentifier oid) {
        if (oid.equals((ASN1Primitive)x500UniqueIdentifier)) {
            return "x500UniqueIdentifier";
        }
        if (oid.equals((ASN1Primitive)E)) {
            return "emailAddress";
        }
        if (oid.equals((ASN1Primitive)SERIALNUMBER)) {
            return "serialNumber";
        }
        if (oid.equals((ASN1Primitive)subjectAltName)) {
            return "subjectAltName";
        }
        if (oid.equals((ASN1Primitive)GN)) {
            return "GN";
        }
        if (oid.equals((ASN1Primitive)SN)) {
            return "SN";
        }
        if (oid.equals((ASN1Primitive)PSEUDONYM)) {
            return "pseudonym";
        }
        return super.oidToDisplayName(oid);
    }

    public String[] oidToAttrNames(ASN1ObjectIdentifier oid) {
        if (oid.equals((ASN1Primitive)x500UniqueIdentifier)) {
            return IETFUtils.findAttrNamesForOID((ASN1ObjectIdentifier)oid, DefaultLookUp);
        }
        if (oid.equals((ASN1Primitive)GN)) {
            return IETFUtils.findAttrNamesForOID((ASN1ObjectIdentifier)oid, DefaultLookUp);
        }
        if (oid.equals((ASN1Primitive)SN)) {
            return IETFUtils.findAttrNamesForOID((ASN1ObjectIdentifier)oid, DefaultLookUp);
        }
        return super.oidToAttrNames(oid);
    }

    public ASN1ObjectIdentifier attrNameToOID(String attrName) {
        if (attrName.equalsIgnoreCase("subjectAltName")) {
            return subjectAltName;
        }
        if (attrName.equalsIgnoreCase("x500UniqueIdentifier")) {
            return x500UniqueIdentifier;
        }
        if (attrName.equalsIgnoreCase("GN")) {
            return GN;
        }
        if (attrName.equalsIgnoreCase("SN")) {
            return SN;
        }
        return super.attrNameToOID(attrName);
    }

    public String toString(X500Name name) {
        return super.toString(name).replaceAll("UniqueIdentifier=", "x500UniqueIdentifier=").replaceAll("/E=", "/emailAddress=").replaceAll(",E=", ",emailAddress=").replaceAll("^E=", "emailAddress=").replaceAll("SERIALNUMBER=", "serialNumber=").replaceAll("GIVENNAME=", "GN=").replaceAll("SURNAME=", "SN=").replaceAll("Pseudonym=", "pseudonym=");
    }

    public String toString(RDN rdn) {
        AttributeTypeAndValue atav = rdn.getFirst();
        return this.oidToDisplayName(atav.getType()) + "=" + atav.getValue().toString();
    }

    public static ArrayList<ASN1ObjectIdentifier> getAllowedRDNTypes() {
        return identifierInOrder;
    }

    public static X500Name sorted(X500Name dn) {
        RDN[] rdns = dn.getRDNs();
        DFNStyle.sort(rdns);
        return new X500Name((X500NameStyle)INSTANCE, rdns);
    }

    public static void sort(RDN[] rdns) {
        Arrays.sort(rdns, rdnComparator);
    }

    public static HashMap<String, String> getOidMap() {
        HashMap<String, String> oidMap = new HashMap<String, String>();
        for (ASN1ObjectIdentifier oid : identifierInOrder) {
            oidMap.put(oid.getId(), INSTANCE.oidToDisplayName(oid));
        }
        return oidMap;
    }

    static {
        identifierInOrder.add(E);
        identifierInOrder.add(SERIALNUMBER);
        identifierInOrder.add(UID);
        identifierInOrder.add(CN);
        identifierInOrder.add(PSEUDONYM);
        identifierInOrder.add(GN);
        identifierInOrder.add(SN);
        identifierInOrder.add(OU);
        identifierInOrder.add(O);
        identifierInOrder.add(L);
        identifierInOrder.add(ST);
        identifierInOrder.add(C);
        identifierInOrder.add(DC);
        rdnComparator = new Comparator<RDN>(){

            @Override
            public int compare(RDN rdn1, RDN rdn2) {
                return identifierInOrder.indexOf(rdn1.getFirst().getType()) - identifierInOrder.indexOf(rdn2.getFirst().getType());
            }
        };
        DefaultLookUp = new Hashtable();
        DefaultLookUp.put("x500uniqueidentifier", x500UniqueIdentifier);
        DefaultLookUp.put("subjectAltName", subjectAltName);
        DefaultLookUp.put("gn", GN);
        DefaultLookUp.put("sn", SN);
    }
}

