/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.utils.crypto;

import de.dfncert.errors.ClientException;
import de.dfncert.errors.ConfigurationException;
import de.dfncert.errors.ProgrammingError;
import de.dfncert.utils.UtilsFormat;
import de.dfncert.utils.UtilsIO;
import de.dfncert.utils.crypto.DFNStyle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class CryptoUtils {
    public static String[] extractValuesFromDN(X500Name dn, ASN1ObjectIdentifier oid, boolean bTrim) {
        if (dn == null) {
            throw new IllegalArgumentException("DN darf nicht null sein.");
        }
        if (oid == null) {
            throw new IllegalArgumentException("OID darf nicht null sein.");
        }
        RDN[] rdns = dn.getRDNs(oid);
        if (rdns.length == 0) {
            return new String[0];
        }
        String[] strings = new String[rdns.length];
        for (int i = 0; i < rdns.length; ++i) {
            strings[i] = bTrim ? rdns[i].getFirst().getValue().toString().trim() : rdns[i].getFirst().getValue().toString();
        }
        return strings;
    }

    public static String[] extractValuesFromDN(X500Name dn, ASN1ObjectIdentifier oid) {
        return CryptoUtils.extractValuesFromDN(dn, oid, true);
    }

    public static List<String> extractValuesFromDN(ASN1ObjectIdentifier oid, String dn) {
        ArrayList<String> result = new ArrayList<String>();
        RDN[] rdns = new X500Name((X500NameStyle)DFNStyle.INSTANCE, dn).getRDNs(oid);
        if (rdns.length > 0) {
            for (RDN rdn : rdns) {
                result.add(IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()));
            }
        }
        return result;
    }

    public static String joinedValuesFromDN(String dn, String sOid) {
        if (dn == null || sOid == null) {
            return null;
        }
        return CryptoUtils.joinedValuesFromDN(new X500Name((X500NameStyle)DFNStyle.INSTANCE, dn), new ASN1ObjectIdentifier(sOid));
    }

    public static String joinedValuesFromDN(X500Name dn, ASN1ObjectIdentifier oid) {
        return UtilsFormat.join(CryptoUtils.extractValuesFromDN(dn, oid), ", ");
    }

    public static boolean isInDN(ASN1ObjectIdentifier oid, X500Name dn) {
        return dn.getRDNs(oid).length > 0;
    }

    public static X509Certificate parseCertificate(Reader toParse) throws CertificateException, IOException {
        return new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)new PEMParser(toParse).readObject());
    }

    public static X509Certificate parseCertificate(String toParse) throws CertificateException, IOException {
        return CryptoUtils.parseCertificate(new StringReader(toParse));
    }

    public static X509Certificate getCertificateFromPEM(String pem) throws CertificateException {
        if (pem == null || pem.isEmpty()) {
            return null;
        }
        int pos = pem.indexOf("-----BEGIN");
        if (pos > 0) {
            pem = pem.substring(pos);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes());
        return (X509Certificate)factory.generateCertificate(pemStream);
    }

    public static String getPEMFromCertificate(X509Certificate cert) throws Exception {
        StringWriter out = new StringWriter();
        JcaPEMWriter pemout = new JcaPEMWriter((Writer)out);
        pemout.writeObject((Object)cert);
        pemout.flush();
        String result = out.toString();
        pemout.close();
        return result;
    }

    public static KeyPair getPrivateKeyFromPEM(String pem) throws IOException {
        PEMParser parser = new PEMParser((Reader)new StringReader(pem));
        KeyPair pair = null;
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
        Object keyObject = parser.readObject();
        if (keyObject instanceof PEMKeyPair) {
            pair = keyConverter.getKeyPair((PEMKeyPair)keyObject);
        } else if (keyObject instanceof KeyPair) {
            pair = (KeyPair)keyObject;
        }
        parser.close();
        return pair;
    }

    public static KeyPair getPrivateKeyFromFile(File in) throws FileNotFoundException, IOException {
        KeyPair pair = null;
        PEMParser parser = new PEMParser((Reader)new InputStreamReader(new FileInputStream(in)));
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
        Object keyObject = parser.readObject();
        if (keyObject instanceof PEMKeyPair) {
            pair = keyConverter.getKeyPair((PEMKeyPair)keyObject);
        } else if (keyObject instanceof KeyPair) {
            pair = (KeyPair)keyObject;
        }
        parser.close();
        return pair;
    }

    public static PKIXCertPathBuilderResult buildPath(Collection<X509Certificate> rootCerts, X509CertSelector endConstraints, Store certs) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CertPathBuilderException, GeneralSecurityException {
        HashSet<TrustAnchor> rootSet = new HashSet<TrustAnchor>();
        for (X509Certificate rootCert : rootCerts) {
            rootSet.add(new TrustAnchor(rootCert, null));
        }
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "SUN");
        PKIXBuilderParameters buildParams = new PKIXBuilderParameters(rootSet, (CertSelector)endConstraints);
        JcaCertStoreBuilder certStoreBuilder = new JcaCertStoreBuilder();
        certStoreBuilder.setType("Collection");
        certStoreBuilder.setProvider("SUN");
        certStoreBuilder.addCertificates(certs);
        buildParams.addCertStore(certStoreBuilder.build());
        buildParams.setRevocationEnabled(false);
        return (PKIXCertPathBuilderResult)builder.build(buildParams);
    }

    public static X509CertSelector convertSID(SignerId signerid) {
        JcaX509CertSelectorConverter conv = new JcaX509CertSelectorConverter();
        X509CertificateHolderSelector sel = new X509CertificateHolderSelector(signerid.getIssuer(), signerid.getSerialNumber());
        return conv.getCertSelector(sel);
    }

    public static X509Certificate verifyDetachedSignature(byte[] content, String pkcs7, Collection<X509Certificate> trustedRoots) throws ClientException {
        try {
            if (content == null) {
                throw new ClientException("Leere Signatur");
            }
            ContentInfo ci = null;
            PEMParser reader = new PEMParser((Reader)new StringReader(pkcs7));
            try {
                ci = (ContentInfo)reader.readObject();
            }
            catch (Exception e) {
                throw new ClientException("Fehler beim Lesen der Signatur");
            }
            if (ci == null) {
                throw new ClientException("Fehler beim Lesen der Signatur");
            }
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(content), ci);
            Store certs = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            Iterator it = signers.getSigners().iterator();
            if (!it.hasNext()) {
                throw new ClientException("Keine SignerInfo in PKCS#7 enthalten");
            }
            SignerInformation signer = (SignerInformation)it.next();
            X509CertificateHolder cert = (X509CertificateHolder)certs.getMatches((Selector)signer.getSID()).iterator().next();
            X509CertSelector signerConstraints = CryptoUtils.convertSID(signer.getSID());
            boolean[] usage = new boolean[9];
            usage[0] = true;
            signerConstraints.setKeyUsage(usage);
            PKIXCertPathBuilderResult result = null;
            try {
                result = CryptoUtils.buildPath(trustedRoots, signerConstraints, certs);
            }
            catch (CertPathBuilderException cpbe) {
                throw new ClientException("Die \u00dcberpr\u00fcfung der Signatur ist fehlgeschlagen (BuildPath Fehler)", cpbe);
            }
            catch (GeneralSecurityException ex) {
                throw new ClientException("Die \u00dcberpr\u00fcfung der Signatur ist fehlgeschlagen (Lesen der Zertifikate in der Signatur).", ex);
            }
            SignerInformationVerifier sigInfoVerifier = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider()).build(cert);
            if (!signer.verify(sigInfoVerifier)) {
                throw new ClientException("Die \u00dcberpr\u00fcfung der Signatur ist fehlgeschlagen (Verify Fehler)");
            }
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert);
        }
        catch (CMSException ex) {
            throw new ProgrammingError("Verify fehlgeschlagen: " + ex.getMessage(), ex);
        }
        catch (OperatorCreationException ex) {
            throw new ProgrammingError("Verify fehlgeschlagen: " + ex.getMessage(), ex);
        }
        catch (CertificateException ex) {
            throw new ProgrammingError("Verify fehlegeschlagen: " + ex.getMessage(), ex);
        }
    }

    public static X509Certificate getSignerCertificate(String pkcs7) throws ClientException {
        if (pkcs7 == null) {
            return null;
        }
        PEMParser pem = new PEMParser((Reader)new StringReader(pkcs7));
        CMSSignedData data = null;
        try {
            data = new CMSSignedData((ContentInfo)pem.readObject());
        }
        catch (Exception ex) {
            throw new ClientException("Ein Problem mit dem Signaturzertifikat ist aufgetreten");
        }
        if (data == null) {
            throw new ClientException("Ein Problem mit dem Signaturzertifikat ist aufgetreten");
        }
        Store certs = data.getCertificates();
        SignerInformationStore signers = data.getSignerInfos();
        Iterator it = signers.getSigners().iterator();
        if (!it.hasNext()) {
            throw new ClientException("Keine SignerInfo in PKCS#7 enthalten");
        }
        SignerInformation signer = (SignerInformation)it.next();
        X509CertificateHolder cert = (X509CertificateHolder)certs.getMatches((Selector)signer.getSID()).iterator().next();
        try {
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(cert);
        }
        catch (CertificateException ex) {
            throw new ClientException("Ein Problem mit dem Signaturzertifikat ist aufgetreten.");
        }
    }

    public static X509Certificate getCertificateFromFile(File in) throws IOException, CertificateException {
        ByteArrayInputStream stream;
        FileInputStream instr = new FileInputStream(in);
        byte[] buf = UtilsIO.readbytes(instr);
        String pem = new String(buf);
        int pos = pem.indexOf("-----BEGIN");
        if (pos > 0) {
            pem = pem.substring(pos);
            stream = new ByteArrayInputStream(pem.getBytes());
        } else {
            stream = new ByteArrayInputStream(buf);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(stream);
    }

    public static ArrayList<X509Certificate> getCertificatesFromFile(File in) throws FileNotFoundException, CertificateException, IOException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        FileInputStream instr = new FileInputStream(in);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certificates = factory.generateCertificates(instr);
        instr.close();
        for (Certificate certificate : certificates) {
            certList.add((X509Certificate)certificate);
        }
        return certList;
    }

    public static List<String> getCDPsFromCert(X509Certificate cert) throws IOException {
        ArrayList<String> cdps = new ArrayList<String>();
        ASN1OctetString octs = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])cert.getExtensionValue("2.5.29.31")));
        ASN1Primitive asn1Object = ASN1Primitive.fromByteArray((byte[])octs.getOctets());
        ASN1Sequence seq = (ASN1Sequence)asn1Object;
        Enumeration points = seq.getObjects();
        while (points.hasMoreElements()) {
            DistributionPoint point = new DistributionPoint((ASN1Sequence)points.nextElement());
            GeneralNames name = (GeneralNames)point.getDistributionPoint().getName();
            GeneralName[] names = name.getNames();
            for (int i = 0; i < names.length; ++i) {
                ASN1String nameAsString = (ASN1String)names[i].getName();
                cdps.add(nameAsString.getString());
            }
        }
        return cdps;
    }

    public static String getCNFromCertificate(X509Certificate certificate) throws CertificateEncodingException {
        if (certificate != null) {
            X500Name dn = new JcaX509CertificateHolder(certificate).getSubject();
            return CryptoUtils.joinedValuesFromDN(dn, DFNStyle.CN);
        }
        return null;
    }

    public static String getSubjectPublicKeyHash(X509Certificate certificate) throws CertificateEncodingException, IOException {
        return UtilsFormat.sha256(new JcaX509CertificateHolder(certificate).getSubjectPublicKeyInfo().getEncoded());
    }

    public static boolean isWeakDebianKey(RSAPublicKey key) throws IOException, ConfigurationException {
        String str = CryptoUtils.getOpenSSLVulnkeyKeyhash(key);
        File file = new File("/services/inst/openssl-blacklist/blacklist.RSA-" + key.getModulus().bitLength());
        try {
            UtilsIO.checkExistsAndReadable(file);
        }
        catch (ConfigurationException ex) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            int cmp = line.compareTo(str);
            if (cmp == 0) {
                reader.close();
                return true;
            }
            if (cmp > 0) break;
            line = reader.readLine();
        }
        reader.close();
        return false;
    }

    public static String getOpenSSLVulnkeyKeyhash(RSAKey key) {
        String str = key.getModulus().toString(16);
        str = str.toUpperCase();
        str = "Modulus=" + str + "\n";
        str = UtilsFormat.sha1(str.getBytes());
        str = str.substring(20);
        return str;
    }

    public static String getOpenSSLVulnkeyKeyhash(String key) {
        int pos2;
        int pos1 = key.indexOf("bit):");
        String str = key.substring(pos1 + 5, pos2 = key.indexOf("Exponent")).trim();
        if (str.startsWith("00")) {
            str = str.substring(2);
        }
        str = str.replaceAll("[\\n\\t\\r: ]", "");
        str = str.toUpperCase();
        str = "Modulus=" + str + "\n";
        str = UtilsFormat.sha1(str.getBytes());
        str = str.substring(20);
        return str;
    }

    public static String convertBase64ToPem(String base64) {
        String pemString = new String();
        String pemStart = "-----BEGIN PKCS7-----";
        String pemEnd = "-----END PKCS7-----";
        String base64Signature = base64.substring(base64.indexOf(pemStart) + pemStart.length(), base64.indexOf(pemEnd));
        base64Signature = base64Signature.replaceAll("\n", "");
        base64Signature = base64Signature.replaceAll("\r", "");
        pemString = pemString + pemStart + "\r\n";
        for (int i = 0; i < base64Signature.length(); ++i) {
            pemString = pemString + base64Signature.toCharArray()[i];
            if ((i + 1) % 64 != 0 || base64Signature.length() <= i + 1) continue;
            pemString = pemString + "\r\n";
        }
        pemString = pemString + "\r\n";
        pemString = pemString + pemEnd;
        return pemString;
    }

    public static String normalizePKCS10Request(String input) {
        String pkcs10 = new String();
        String pemHeader = "-----BEGIN CERTIFICATE REQUEST-----";
        String pemFooter = "-----END CERTIFICATE REQUEST-----";
        String base64 = input.replaceAll("^--+BEGIN [a-zA-Z ]*--+", "");
        base64 = base64.replaceAll("--+END [a-zA-Z ]*--+", "");
        base64 = base64.replaceAll("\\s", "");
        pkcs10 = pemHeader + "\r\n";
        for (int i = 0; i < base64.length(); ++i) {
            pkcs10 = pkcs10 + base64.toCharArray()[i];
            if ((i + 1) % 64 != 0 || base64.length() <= i + 1) continue;
            pkcs10 = pkcs10 + "\r\n";
        }
        pkcs10 = pkcs10 + "\r\n";
        pkcs10 = pkcs10 + pemFooter;
        return pkcs10;
    }

    public static String correctSPKACDN(String sReqData, String sDN) {
        RDN[] rdns;
        String sHeader = "-----END HEADER-----";
        int beginIndex = sReqData.indexOf(sHeader);
        int endIndex = sReqData.indexOf("SPKAC", beginIndex);
        String sToBeReplaced = sReqData.substring(beginIndex + sHeader.length() + 1, endIndex);
        String sReplacement = new String();
        for (RDN rdn : rdns = new X500Name((X500NameStyle)DFNStyle.INSTANCE, sDN).getRDNs()) {
            String sType = rdn.getFirst().getType().getId();
            if (sType.equals("1.2.840.113549.1.9.1")) {
                sType = "emailAddress";
            } else if (sType.equals("2.5.4.3")) {
                sType = "CN";
            } else if (sType.equals("2.5.4.11")) {
                sType = "OU";
            } else if (sType.equals("2.5.4.10")) {
                sType = "O";
            } else if (sType.equals("2.5.4.6")) {
                sType = "C";
            } else if (sType.equals("2.5.4.8")) {
                sType = "ST";
            } else if (sType.equals("2.5.4.7")) {
                sType = "L";
            }
            sReplacement = sReplacement.isEmpty() ? sType + "=" + IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()) + "\r\n" : sReplacement + sType + "=" + IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()) + "\r\n";
        }
        return sReqData.replace(sToBeReplaced, sReplacement);
    }

    public static boolean isWeakRocaKey(RSAPublicKey key) {
        int[] prims = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167};
        BigInteger[] primes = new BigInteger[prims.length];
        for (int i = 0; i < prims.length; ++i) {
            primes[i] = BigInteger.valueOf(prims[i]);
        }
        BigInteger[] markers = new BigInteger[]{new BigInteger("6"), new BigInteger("30"), new BigInteger("126"), new BigInteger("1026"), new BigInteger("5658"), new BigInteger("107286"), new BigInteger("199410"), new BigInteger("8388606"), new BigInteger("536870910"), new BigInteger("2147483646"), new BigInteger("67109890"), new BigInteger("2199023255550"), new BigInteger("8796093022206"), new BigInteger("140737488355326"), new BigInteger("5310023542746834"), new BigInteger("576460752303423486"), new BigInteger("1455791217086302986"), new BigInteger("147573952589676412926"), new BigInteger("20052041432995567486"), new BigInteger("6041388139249378920330"), new BigInteger("207530445072488465666"), new BigInteger("9671406556917033397649406"), new BigInteger("618970019642690137449562110"), new BigInteger("79228162521181866724264247298"), new BigInteger("2535301200456458802993406410750"), new BigInteger("1760368345969468176824550810518"), new BigInteger("50079290986288516948354744811034"), new BigInteger("473022961816146413042658758988474"), new BigInteger("10384593717069655257060992658440190"), new BigInteger("144390480366845522447407333004847678774"), new BigInteger("2722258935367507707706996859454145691646"), new BigInteger("174224571863520493293247799005065324265470"), new BigInteger("696898287454081973172991196020261297061886"), new BigInteger("713623846352979940529142984724747568191373310"), new BigInteger("1800793591454480341970779146165214289059119882"), new BigInteger("126304807362733370595828809000324029340048915994"), new BigInteger("11692013098647223345629478661730264157247460343806"), new BigInteger("187072209578355573530071658587684226515959365500926")};
        BigInteger modulus = key.getModulus();
        for (int i = 0; i < primes.length; ++i) {
            if (!BigInteger.ONE.shiftLeft(modulus.remainder(primes[i]).intValue()).and(markers[i]).equals(BigInteger.ZERO)) continue;
            return false;
        }
        return true;
    }
}

