/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.subject;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthority;
import org.openscdp.dfn.connector.pkidm.subject.DFNPKIContent;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.subject.SubjectBase;

public class DFNPKI
extends SubjectBase {
    public static final String TYPE = "DFNPKI";
    private DFNPKIContent content;
    private RegistrationAuthority[] ra;

    public DFNPKI(SubjectDTO dto) {
        super(dto);
    }

    public DFNPKIContent getContent() {
        if (this.content == null) {
            this.content = (DFNPKIContent)this.parseContent(DFNPKIContent.class);
        }
        return this.content;
    }

    public RegistrationAuthority[] getRAs() {
        if (this.ra == null) {
            Jdbi jdbi = PKIDMContext.getJDBI();
            try (Handle handle = jdbi.open();){
                HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
                List holder = holderDAO.getHolderListBySubject(this.getId());
                SignerDAO signerDAO = (SignerDAO)handle.attach(SignerDAO.class);
                for (HolderDTO h : holder) {
                    List signer = signerDAO.getSignerByHolderId(h.getId());
                    this.ra = new RegistrationAuthority[signer.size()];
                    for (int i = 0; i < this.ra.length; ++i) {
                        this.ra[i] = new RegistrationAuthority((SignerDTO)signer.get(i));
                    }
                }
            }
        }
        return this.ra;
    }
}

