/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.action;

import de.dfncert.enums.RevocationReason;
import de.dfncert.tools.DFNPKIClient;
import java.math.BigInteger;
import org.openscdp.dfn.connector.pkidm.Utils;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequestBase;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthority;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthorityContent;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestSingleAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;

public class DFNRevocationRequestAction
extends ServiceRequestSingleAction {
    private DFNCertificateRequestBase sr;
    private JSONAction action;
    private DFNPKIClient client;

    public DFNRevocationRequestAction(DFNCertificateRequestBase serviceRequest, JSONAction action) {
        super((ServiceRequest)serviceRequest);
        this.sr = serviceRequest;
        this.action = action;
    }

    public void requestRevocationByHolder() throws Exception {
        RegistrationAuthority ra = this.sr.getRA();
        RegistrationAuthorityContent content = ra.getContent();
        int raID = content.raID;
        int reasonCode = DFNCertificateRequestBase.getRevocationReason(this.action);
        RevocationReason reason = RevocationReason.getByCode((int)reasonCode);
        BigInteger serial = this.sr.getCertificateSerialNumber();
        String pin = this.sr.getPIN();
        int revocationSerial = this.client.getPublic().newRevocationRequest(raID, serial, reason, pin);
        this.sr.setRevocationRequestSerialNumber(revocationSerial);
        this.sr.setRevocationReason(reasonCode);
        Utils.setCertificateRevocationStatus(this.sr.getId(), this.sr.getRevocationReason());
        this.sr.setStatusInfo("Certificate revoked by holder");
        this.sr.setLifeCycle(13);
        this.sr.commit(this.action.user, null);
    }

    protected void executeImpl() {
        String caName = this.sr.getRA().getCAName();
        try {
            this.client = new DFNPKIClient(caName);
            this.requestRevocationByHolder();
        }
        catch (Exception e) {
            throw new ServiceRequestActionException("DFNRevocationRequestAction failed (SR-ID: " + this.sr.getId() + ")", (Throwable)e);
        }
    }
}

