/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc.action;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestActionStates;
import org.openscdp.pkidm.cvc.CVCTools;
import org.openscdp.pkidm.holder.CVCertificateHolder;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateError;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CreateCVCSignerAction<T extends ServiceRequest>
implements ServiceRequestAction {
    private final Logger logger = LoggerFactory.getLogger(CreateCVCSignerAction.class);
    protected T serviceRequest;
    protected String tokenPath;
    protected String keyDomainUID;
    protected SmartCardHSMProvider provider;
    private KeyStore keyStore;
    private String chr;
    private String label;
    protected KeyHandling existingKey = KeyHandling.FAIL;
    protected Long issuerId;
    protected Long holderId;
    protected String holderName;
    protected CVCertificateHolder holder;
    private int signerNo;
    protected SignerDTO signerDTO;
    protected CardVerifiableCertificate atreq;

    public CreateCVCSignerAction(T serviceRequest) {
        this.serviceRequest = serviceRequest;
    }

    @Override
    public ServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean preFlightCheck() {
        return true;
    }

    public boolean isReady() {
        try {
            this.assertReady();
        }
        catch (Exception e) {
            this.serviceRequest.setActionInfo(e.getMessage());
            return false;
        }
        return true;
    }

    protected void assertReady() {
        if (!this.preFlightCheck()) {
            throw new ServiceRequestActionException("Precondition for service request not fulfilled");
        }
        HSMService hsmService = PKIDMContext.getHSMService();
        this.provider = hsmService.getProvider(this.tokenPath);
        if (this.provider == null) {
            throw new ServiceRequestActionException("Token " + this.tokenPath + " is not connected");
        }
        try {
            if (this.provider.getSmartCardHSMCardService().getPasswordStatus(null, 1) != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                throw new ServiceRequestActionException("Token " + this.tokenPath + " is not authenticated");
            }
        }
        catch (CardServiceException | CardTerminalException e) {
            this.logger.error("Device error", e);
            throw new ServiceRequestActionException("Error while processing token " + this.tokenPath, e);
        }
    }

    protected void amendNewHolder(HolderDTO dto) {
    }

    protected boolean amendExistingHolder(HolderDTO dto) {
        return false;
    }

    private HolderDTO createHolder() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            HolderDTO dto = new HolderDTO();
            dto.setParentId(this.issuerId);
            dto.setCertificateType(1);
            dto.setName(this.holderName);
            this.amendNewHolder(dto);
            HolderDTO holderDTO = dao.create(dto);
            return holderDTO;
        }
    }

    protected CVCertificateHolder getHolder() {
        HolderDAO dao;
        if (this.holder != null) {
            return this.holder;
        }
        HolderDTO dto = null;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            dao = (HolderDAO)handle.attach(HolderDAO.class);
            if (this.holderId == null || this.holderId <= 0L) {
                this.holderId = this.issuerId == null ? dao.getRootHolderId(1, this.holderName) : dao.getHolderId(1, this.issuerId, this.holderName);
            }
            if (this.holderId != null && this.holderId > 0L) {
                dto = dao.getHolder(this.holderId);
            }
        }
        if (dto == null) {
            dto = this.createHolder();
        } else if (this.amendExistingHolder(dto)) {
            handle = PKIDMContext.getJDBI().open();
            try {
                dao = (HolderDAO)handle.attach(HolderDAO.class);
                dao.updateSubjectId(dto.getSubjectId(), dto.getId());
                dao.updateContent(dto.getContent(), dto.getId());
                dao.updateType(dto.getType(), dto.getId());
            }
            finally {
                if (handle != null) {
                    handle.close();
                }
            }
        }
        this.holderId = dto.getId();
        this.holder = new CVCertificateHolder(dto);
        return this.holder;
    }

    protected String getCurve() {
        throw new RuntimeException("Base class can not provide domain parameter");
    }

    protected void amendKeySpecification(SmartCardHSMPrivateKeySpec spec) {
    }

    protected String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        String str = "" + this.getSignerNo();
        this.chr = this.holder.getName() + "00000".substring(str.length()) + str;
        this.label = this.chr;
        for (CVCertificateHolder parent = this.holder.getParent(); parent != null; parent = parent.getParent()) {
            this.label = parent.getName() + "/" + this.label;
        }
        return this.label;
    }

    protected SmartCardHSMParameterSpec getKeySpec() throws OpenCardException {
        CVCertificateHolder parent = this.holder.getParent();
        CardVerifiableCertificate issuerCert = null;
        if (parent != null) {
            LinkedList<CardVerifiableCertificate> caCerts = parent.getCertificateChain();
            try {
                CVCTools.validateChain(caCerts);
            }
            catch (GeneralSecurityException e) {
                throw new CardServiceException("Certificate chain did not validate.", (Throwable)e);
            }
            issuerCert = caCerts.getFirst();
        }
        SmartCardHSMECPrivateKeySpec spec = issuerCert != null ? new SmartCardHSMECPrivateKeySpec((AlgorithmParameterSpec)issuerCert.getECParameterSpec()) : new SmartCardHSMECPrivateKeySpec((AlgorithmParameterSpec)new ECGenParameterSpec(this.getCurve()));
        if (this.keyDomainUID != null) {
            SmartCardHSMCardService service = this.provider.getSmartCardHSMCardService();
            List keyDomains = service.getKeyDomains();
            for (KeyDomain kd : keyDomains) {
                String hex;
                if (!kd.isCreated() || !(hex = HexString.hexifyByteArray((byte[])kd.getKeyDomainUID())).equals(this.keyDomainUID)) continue;
                spec.setKeyDomain(kd);
                break;
            }
        }
        String label = this.getLabel();
        spec.setCHR(this.chr);
        if (issuerCert != null) {
            spec.setCAR(issuerCert.getCertificateHolderReference().toString());
        }
        this.amendKeySpecification((SmartCardHSMPrivateKeySpec)spec);
        SmartCardHSMParameterSpec hsmParam = new SmartCardHSMParameterSpec(label, (SmartCardHSMKeySpec)spec);
        return hsmParam;
    }

    private int getSignerNo() {
        if (this.signerNo == 0) {
            this.signerNo = this.holder.countSigner() + 1;
        }
        return this.signerNo;
    }

    protected void ammendNewSigner(SignerDTO dto) {
    }

    protected void generateSignerKeyPair() throws Exception {
        KeyDomain kd;
        this.getHolder();
        this.keyStore = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)this.provider);
        this.keyStore.load(null, null);
        SmartCardHSMPrivateKey prk = null;
        if (this.keyStore.containsAlias(this.getLabel())) {
            if (this.existingKey == KeyHandling.FAIL) {
                throw new CardServiceException("A key with label " + this.getLabel() + " does already exist");
            }
            if (this.existingKey == KeyHandling.DELETE) {
                this.keyStore.deleteEntry(this.getLabel());
                this.logger.info("Existing key " + this.getLabel() + " on hsm removed");
            } else {
                Key key = this.keyStore.getKey(this.getLabel(), null);
                if (!(key instanceof SmartCardHSMPrivateKey)) {
                    throw new CardServiceException("Existing key with label " + this.getLabel() + " is not a asymmetric key");
                }
                prk = (SmartCardHSMPrivateKey)key;
            }
        } else if (this.existingKey == KeyHandling.REUSE) {
            throw new CardServiceException("A key with label " + this.getLabel() + " does not exist");
        }
        if (prk == null) {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)this.provider);
            SmartCardHSMParameterSpec spec = this.getKeySpec();
            kpg.initialize((AlgorithmParameterSpec)spec, null);
            KeyPair kp = kpg.generateKeyPair();
            prk = (SmartCardHSMPrivateKey)kp.getPrivate();
        }
        byte[] keyDomain = (kd = prk.getKeyDomain()) == null ? this.provider.getSmartCardHSMCardService().getDefaultKeyDomainUID() : kd.getKeyDomainUID();
        byte[] keyId = prk.getKeyId();
        this.atreq = (CardVerifiableCertificate)this.keyStore.getCertificate(this.getLabel());
        if (this.atreq == null) {
            throw new CardServiceException("The key with label " + this.getLabel() + " does not have a public key");
        }
        if (!Arrays.equals(keyId, this.atreq.getSubjectPublicKeyIdentifier())) {
            this.logger.warn("Key identifier does not match subject public key identifier, changing key identifier.");
            keyId = this.atreq.getSubjectPublicKeyIdentifier();
        }
        try (Handle handle = PKIDMContext.getJDBI().open();){
            SignerDAO sdao = (SignerDAO)handle.attach(SignerDAO.class);
            this.signerDTO = new SignerDTO(Long.valueOf(0L), this.holder.getId(), this.chr, keyId, keyDomain, (byte[])null, null);
            this.ammendNewSigner(this.signerDTO);
            sdao.create(this.signerDTO);
            HolderDAO hdao = (HolderDAO)handle.attach(HolderDAO.class);
            hdao.updateSignerNo(Long.valueOf(this.getSignerNo()), this.holder.getId());
        }
        this.serviceRequest.updateDetails(this.getLabel());
    }

    protected void storeCertificate(CardVerifiableCertificate cert) throws KeyStoreException {
        this.keyStore.setCertificateEntry(this.getLabel(), (Certificate)cert);
    }

    protected ServiceRequestStateContent postProcess() throws Exception {
        return null;
    }

    @Override
    public JSONActionResult execute() {
        try {
            this.assertReady();
            this.generateSignerKeyPair();
            ServiceRequestStateContent content = this.postProcess();
            this.serviceRequest.commit(content);
        }
        catch (Exception e) {
            this.logger.error("Signer creation failed", (Throwable)e);
            this.serviceRequest.setStatusInfo("Creation failed");
            this.serviceRequest.commit(new ServiceRequestStateError(e.getMessage()));
            return new JSONActionResult(ServiceRequestActionStates.FAILED, e.getMessage());
        }
        return new JSONActionResult(ServiceRequestActionStates.COMPLETED, "Signer created");
    }

    protected static enum KeyHandling {
        FAIL,
        DELETE,
        USE,
        REUSE;

    }
}

