/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.service;

import at.co.svc.opencard.encoding.SVPGrunddaten;
import at.co.svc.opencard.service.CertificateChain;
import de.cardcontact.opencard.eac.cvc.ECSignature;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.isocard.IsoCardService;
import de.cardcontact.opencard.service.isocard.apdu.ManageSECommandAPDU;
import de.cardcontact.opencard.service.isocard.apdu.PerformSecurityOperation;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.security.GeneralSecurityException;
import java.util.Properties;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.service.CardServiceUnexpectedResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECardCardService
extends IsoCardService {
    private final Logger logger = LoggerFactory.getLogger(ECardCardService.class);
    private static final CardFilePath DF_SVP_AID = new CardFilePath("#D040000017010101");
    private static final CardFilePath DF_SVS_AID = new CardFilePath("#D040000017001001");
    private static final CardFilePath DF_SVP_FID = new CardFilePath(":3F01");
    private static final CardFilePath DF_SVS_FID = new CardFilePath(":3F02");

    protected void initialize(CardServiceScheduler scheduler, SmartCard card, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, card, blocking);
        int maxRAPDUSize = 258;
        Properties features = card.getCardID().getCardTerminal().features();
        if (features.containsKey("maxRAPDUSize")) {
            maxRAPDUSize = Integer.parseUnsignedInt(features.getProperty("maxRAPDUSize"));
            if (maxRAPDUSize > 2048) {
                maxRAPDUSize = 2048;
            } else if (maxRAPDUSize >= 261 && maxRAPDUSize <= 292) {
                maxRAPDUSize = 258;
            }
        }
        this.maxRDataSM = Math.floorDiv(maxRAPDUSize - 19 - 2, 16) * 16 - 2;
    }

    public SVPGrunddaten readSVPGrunddaten() throws OpenCardException {
        SVPGrunddaten gd;
        CardFilePath ef = new CardFilePath(DF_SVP_FID);
        ef.append(new CardFilePath(":01"));
        byte[] bin = this.read(ef, 0, -1);
        try {
            TLV tlv = TLV.factory((byte[])bin);
            gd = new SVPGrunddaten(tlv);
        }
        catch (TLVEncodingException e) {
            this.logger.error("Error decoding TLV in EF_Grunddaten", (Throwable)e);
            throw new CardServiceException("Error decoding TLV in EF_Grunddaten", (Throwable)e);
        }
        return gd;
    }

    public CertificateChain readSVSCertificateChain() throws OpenCardException, GeneralSecurityException {
        CardFilePath ef = new CardFilePath(DF_SVS_FID);
        ef.append(new CardFilePath(":01"));
        byte[] eECert = this.read(ef, 0, -1);
        ef = new CardFilePath(DF_SVS_FID);
        ef.append(new CardFilePath(":02"));
        byte[] cACert = this.read(ef, 0, -1);
        return new CertificateChain(eECert, cACert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] signHashWithSVSignature(byte[] hash) throws OpenCardException {
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(DF_SVS_FID, 0);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            Sequence tlv = new Sequence();
            tlv.add((TLV)new PrimitiveTLV(new Tag(4, -128, false), new byte[]{-126}));
            tlv.add((TLV)new PrimitiveTLV(new Tag(21, -128, false), new byte[]{64}));
            ManageSECommandAPDU cmd = new ManageSECommandAPDU(65, -74, (TLV)tlv);
            cmd.setQueueable(true);
            ResponseAPDU rsp = this.sendCommandAPDU(channel, secureChannelCredential, (CommandAPDU)cmd);
            if (rsp.sw() != 36864) {
                throw new CardServiceUnexpectedResponseException("MANAGE SE failed");
            }
            cmd = new PerformSecurityOperation(-98, -102, hash, 256);
            rsp = this.sendCommandAPDU(channel, secureChannelCredential, (CommandAPDU)cmd);
            if (rsp.sw() != 36864) {
                throw new CardServiceUnexpectedResponseException("PSO Compute Digital Signature failed");
            }
            byte[] byArray = ECSignature.wrapSignature((byte[])rsp.data());
            return byArray;
        }
        finally {
            this.releaseCardChannel();
        }
    }

    public void activateHCE() throws OpenCardException {
        CardFilePath df = new CardFilePath(DF_SVP_AID);
        this.getFileInfo(df);
        CardFilePath mf = new CardFilePath(":3F00");
        this.getFileInfo(mf);
    }
}

