/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.service;

import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class CertificateChain {
    byte[] eECertBin;
    byte[] cACertBin;
    CertPath chain;

    public CertificateChain(byte[] eECert, byte[] cACert) throws GeneralSecurityException {
        this.eECertBin = eECert;
        this.cACertBin = cACert;
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(2);
        list.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(eECert)));
        list.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cACert)));
        this.chain = cf.generateCertPath(list);
    }

    public byte[] getEECertificateBinary() {
        return this.eECertBin;
    }

    public byte[] getCACertificateBinary() {
        return this.cACertBin;
    }

    public CertPath getCertificateChain() {
        return this.chain;
    }
}

