/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.operations;

import at.co.svc.opencard.operations.PrivilegedCardOperation;
import at.co.svc.opencard.operations.RAMOverHTTPStatusCodes;
import at.co.svc.opencard.service.CertificateChain;
import at.co.svc.opencard.service.ECardCardService;
import de.cardcontact.opencard.eac.TerminalAuthenticationSigner;
import de.cardcontact.opencard.terminal.remoteterminal.RemoteTerminal;
import java.security.GeneralSecurityException;
import opencard.core.OpenCardException;
import opencard.core.service.SmartCard;

public class SVSignCardOperation
extends PrivilegedCardOperation {
    private TerminalAuthenticationSigner ta;
    private byte[] hashTBS = null;
    private CertificateChain chain = null;
    private byte[] signature = null;

    public SVSignCardOperation(TerminalAuthenticationSigner ta, byte[] hashTBS) {
        this.ta = ta;
        this.hashTBS = hashTBS;
    }

    @Override
    public void performOperation(SmartCard card) throws OpenCardException, GeneralSecurityException {
        ECardCardService tcs = this.authenticate(card, this.ta);
        RemoteTerminal rt = (RemoteTerminal)card.getCardID().getCardTerminal();
        rt.sendNotification(RAMOverHTTPStatusCodes.STATUS_UPDATE.getCode(), "Lese Zertifikate");
        this.chain = tcs.readSVSCertificateChain();
        rt.sendNotification(RAMOverHTTPStatusCodes.STATUS_UPDATE.getCode(), "Erstelle Signatur");
        this.signature = tcs.signHashWithSVSignature(this.hashTBS);
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            throw new IllegalStateException("Card operation was not successfully performed");
        }
        return this.signature;
    }

    public CertificateChain getCertificateChain() {
        if (this.chain == null) {
            throw new IllegalStateException("Card operation was not successfully performed");
        }
        return this.chain;
    }
}

