/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.operations;

import at.co.svc.opencard.encoding.SVPGrunddaten;
import at.co.svc.opencard.operations.PrivilegedCardOperation;
import at.co.svc.opencard.operations.RAMOverHTTPStatusCodes;
import at.co.svc.opencard.service.ECardCardService;
import de.cardcontact.opencard.eac.TerminalAuthenticationSigner;
import de.cardcontact.opencard.terminal.remoteterminal.RemoteTerminal;
import java.security.GeneralSecurityException;
import opencard.core.OpenCardException;
import opencard.core.service.SmartCard;

public class ReadSVPCardOperation
extends PrivilegedCardOperation {
    private TerminalAuthenticationSigner ta;
    private SVPGrunddaten gd = null;

    public ReadSVPCardOperation(TerminalAuthenticationSigner ta) {
        this.ta = ta;
    }

    @Override
    public void performOperation(SmartCard card) throws OpenCardException, GeneralSecurityException {
        ECardCardService tcs = this.authenticate(card, this.ta);
        RemoteTerminal rt = (RemoteTerminal)card.getCardID().getCardTerminal();
        rt.sendNotification(RAMOverHTTPStatusCodes.STATUS_UPDATE.getCode(), "Lese SVPGrunddaten");
        this.gd = tcs.readSVPGrunddaten();
    }

    public SVPGrunddaten getSVPGrunddaten() {
        if (this.gd == null) {
            throw new IllegalStateException("Card operation was not successfully performed");
        }
        return this.gd;
    }
}

