/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.operations;

import at.co.svc.opencard.operations.CardOperation;
import at.co.svc.opencard.operations.CardOperationCompletionListener;
import de.cardcontact.opencard.terminal.remoteterminal.RemoteTerminal;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.util.APDUTracer;
import opencard.core.util.SLF4JAPDUTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardOperationExecutor
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(CardOperationExecutor.class);
    private SLF4JAPDUTracer apduTracer = new SLF4JAPDUTracer();
    private RemoteTerminal rt;
    private CardOperation op;
    private CardOperationCompletionListener cl;

    public CardOperationExecutor(RemoteTerminal rt, CardOperation op, CardOperationCompletionListener cl) {
        this.rt = rt;
        this.op = op;
        this.cl = cl;
    }

    public CardOperation getCardOperation() {
        return this.op;
    }

    public RemoteTerminal getRemoteTerminal() {
        return this.rt;
    }

    @Override
    public void run() {
        this.logger.debug("Card operation started.");
        SmartCard card = null;
        try {
            CardTerminalEvent ctevent = new CardTerminalEvent((CardTerminal)this.rt, 1, 0);
            card = SmartCard.getSmartCard((CardTerminalEvent)ctevent, null, null);
            card.setAPDUTracer((APDUTracer)this.apduTracer);
            if (this.op != null) {
                this.op.performOperation(card);
            }
            this.cl.cardOperationCompleted(this);
        }
        catch (Exception e) {
            this.logger.error("Card operation failed", (Throwable)e);
            this.cl.cardOperationFailed(this, e);
        }
        finally {
            if (card != null) {
                try {
                    card.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

