/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.operations;

import at.co.svc.opencard.factory.ECardCardServiceFactory;
import at.co.svc.opencard.service.ECardCardService;
import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.ChipAuthentication;
import de.cardcontact.opencard.eac.EACCardService;
import de.cardcontact.opencard.eac.StandardizedDomainParameter;
import de.cardcontact.opencard.eac.TerminalAuthenticationSigner;
import de.cardcontact.opencard.eac.TrustStore;
import de.cardcontact.opencard.eac.cvc.PublicKeyReference;
import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.security.GeneralSecurityException;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInabilityException;
import opencard.core.service.SmartCard;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.CredentialStore;
import opencard.opt.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CardOperation {
    private final Logger logger = LoggerFactory.getLogger(CardOperation.class);
    private static final Tag TAG_GDO = new Tag(26, 64, false);
    private String cin = null;

    protected ECardCardService authenticate(SmartCard card, TerminalAuthenticationSigner ta) throws OpenCardException, GeneralSecurityException {
        EACCardService eac = null;
        ECardCardService ecs = null;
        try {
            eac = (EACCardService)card.getCardService(EACCardService.class, true);
            ecs = (ECardCardService)card.getCardService(ECardCardService.class, true);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("CardService class not found, probably because card is not supported", (Throwable)e);
            throw new CardServiceInabilityException("Card not supported");
        }
        if (ECardCardServiceFactory.isHCE(card.getCardID())) {
            ecs.activateHCE();
        }
        CardFilePath cfp = new CardFilePath(new byte[]{4});
        byte[] cvcbin = ecs.read(cfp, 0, -1);
        CardVerifiableCertificate prodCACert = new CardVerifiableCertificate(cvcbin);
        CardVerifiableCertificate rootCert = TrustStore.getInstance().getTrustedCertificate((PublicKeyReference)prodCACert.getCertificationAuthorityReference());
        if (rootCert == null) {
            this.logger.error("No trusted certificate for " + String.valueOf(prodCACert.getCertificationAuthorityReference()) + " found");
            throw new CardServiceException("No trusted certificate for  " + String.valueOf(prodCACert.getCertificationAuthorityReference()) + " found");
        }
        prodCACert.verify(rootCert);
        String holder = prodCACert.getCertificationAuthorityReference().getHolder();
        if (holder.equals("ATAutRCA1T") || holder.equals("ATeCardRCAT")) {
            eac.setRootCHR("ATBerRCA1T00001");
        } else {
            eac.setRootCHR("ATBerRCA100001");
        }
        eac.setChipAuthenticationParameter(ChipAuthentication.id_CA_ECDH_AES_CBC_CMAC_128, StandardizedDomainParameter.secp256r1);
        eac.performTerminalAuthentication(ta);
        cfp = new CardFilePath(new byte[]{3});
        cvcbin = ecs.read(cfp, 0, -1);
        CardVerifiableCertificate cardCert = new CardVerifiableCertificate(cvcbin);
        cardCert.verify(prodCACert);
        eac.setChipAuthenticationPublicKey(cardCert.getPublicKey());
        eac.performChipAuthentication();
        IsoCredentialStore store = new IsoCredentialStore();
        CardFilePath securityDomain = new CardFilePath(":3F00");
        store.setSecureChannelCredential((SecurityDomain)securityDomain, (SecureChannelCredential)eac.getSecureMessagingCredential());
        CredentialBag bag = new CredentialBag();
        bag.addCredentialStore((CredentialStore)store);
        ecs.provideCredentials((SecurityDomain)securityDomain, bag);
        cfp = new CardFilePath(new byte[]{2});
        byte[] cinbin = ecs.read(cfp, 0, -1);
        try {
            TLV tlv = TLV.factory((byte[])cinbin);
            if (!tlv.getTag().equals((Object)TAG_GDO)) {
                throw new CardServiceException("EF.GDO expected tag " + String.valueOf(TAG_GDO) + " but found " + String.valueOf(tlv.getTag()));
            }
            this.cin = HexString.hexifyByteArray((byte[])((PrimitiveTLV)tlv).getValue());
        }
        catch (TLVEncodingException e) {
            throw new CardServiceException("Failed parsing the EF.GDO", (Throwable)e);
        }
        return ecs;
    }

    public String getCIN() {
        if (this.cin == null) {
            throw new IllegalStateException("Card operation was not successfully performed");
        }
        return this.cin;
    }

    public abstract void performOperation(SmartCard var1) throws OpenCardException, GeneralSecurityException;
}

