/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.factory;

import at.co.svc.opencard.service.ECardCardService;
import de.cardcontact.opencard.eac.EACCardService;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;

public class ECardCardServiceFactory
extends CardServiceFactory {
    private static final byte[][] hceATRs = new byte[][]{{59, -128, -128, 1, 1}, {59, -120, -128, 1, 0, 0, 0, 0, -128, -127, 112, 0, 120}};
    private static final byte[][] historicalBytes = new byte[][]{{-128, 49, -80, 82, 0, 5, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 1, 5, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 2, 5, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 3, 5, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 4, 5, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 0, 6, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 1, 6, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 2, 6, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 3, 6, 100, 5, -95, 0, -84, 115, -42, 34, -64}, {-128, 49, -80, 82, 4, 6, 100, 5, -95, 0, -84, 115, -42, 34, -64}};
    private static Vector<Class> classes = new Vector();

    public static boolean isHCE(CardID cid) {
        return Arrays.compare(cid.getATR(), hceATRs[0]) == 0 || Arrays.compare(cid.getATR(), hceATRs[1]) == 0;
    }

    protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
        int i;
        if (ECardCardServiceFactory.isHCE(cid)) {
            return new CardType(1281);
        }
        byte[] hb = cid.getHistoricals();
        for (i = 0; i < historicalBytes.length && Arrays.compare(hb, historicalBytes[i]) != 0; ++i) {
        }
        if (i >= historicalBytes.length) {
            return CardType.UNSUPPORTED;
        }
        return new CardType(((hb[4] & 0xFF) << 8) + (hb[5] & 0xFF));
    }

    protected Enumeration getClasses(CardType type) {
        return classes.elements();
    }

    static {
        classes.addElement(EACCardService.class);
        classes.addElement(ECardCardService.class);
    }
}

