/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.encoding;

import at.co.svc.opencard.encoding.DirectoryAttribute;
import at.co.svc.opencard.encoding.ECardObjectIdentifier;
import de.cardcontact.opencard.service.KeyId;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.time.LocalDate;
import java.util.HashMap;

abstract class Grunddaten {
    HashMap<KeyId, DirectoryAttribute> map = new HashMap(10);

    Grunddaten(TLV tlv) throws TLVEncodingException {
        Sequence seq = new Sequence(tlv);
        for (int i = 0; i < seq.getElements(); ++i) {
            DirectoryAttribute da = new DirectoryAttribute(seq.get(i));
            this.map.put(new KeyId(da.getObjectIdentifier().getBytes()), da);
        }
    }

    public DirectoryAttribute getAttribute(ObjectIdentifier oid) {
        DirectoryAttribute da = this.map.get(new KeyId(oid.getBytes()));
        return da;
    }

    public int getCSN() {
        DirectoryAttribute da = this.getAttribute(ECardObjectIdentifier.E_CARD_CSN);
        if (da == null) {
            throw new RuntimeException("Mandatory attribute e-card-csn missing");
        }
        return da.getInteger();
    }

    public String getTitle() {
        DirectoryAttribute da = this.getAttribute(ECardObjectIdentifier.ID_AT_TITLE);
        if (da == null) {
            return null;
        }
        return da.getUTF8String();
    }

    public String getGivenName() {
        DirectoryAttribute da = this.getAttribute(ECardObjectIdentifier.ID_AT_GIVENNAME);
        if (da == null) {
            return null;
        }
        return da.getUTF8String();
    }

    public String getSurname() {
        DirectoryAttribute da = this.getAttribute(ECardObjectIdentifier.ID_AT_SURNAME);
        if (da == null) {
            return null;
        }
        return da.getUTF8String();
    }

    public String getGrade() {
        DirectoryAttribute da = this.getAttribute(ECardObjectIdentifier.E_CARD_GRADE);
        if (da == null) {
            return null;
        }
        return da.getUTF8String();
    }

    public String getGender() {
        DirectoryAttribute da = this.getAttribute(ECardObjectIdentifier.ID_PDA_GENDER);
        if (da == null) {
            return null;
        }
        return da.getPrintableString();
    }

    public LocalDate getDateOfBirth() {
        DirectoryAttribute da = this.getAttribute(ECardObjectIdentifier.ID_PDA_DATEOFBIRTH);
        if (da == null) {
            return null;
        }
        return da.getLocalDate();
    }
}

