/*
 * Decompiled with CFR 0.152.
 */
package at.co.svc.opencard.encoding;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.GeneralizedTime;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.PrintableString;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import de.cardcontact.tlv.UTF8String;
import java.time.LocalDate;

public class DirectoryAttribute
extends Sequence {
    public DirectoryAttribute(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName("DirectoryAttribute");
        if (this.childs.size() != 2) {
            throw new TLVEncodingException("DirectoryAttribute must contain two elements");
        }
        if (!(this.childs.get(0) instanceof ObjectIdentifier)) {
            throw new TLVEncodingException("DirectoryAttribute must contain ObjectIdentifier in first position");
        }
        if (!((TLV)this.childs.get(1)).getTag().equals((Object)Tag.TAG_SET)) {
            throw new TLVEncodingException("DirectoryAttribute must contain SET in second position");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        return (ObjectIdentifier)this.childs.get(0);
    }

    public String getUTF8String() {
        ConstructedTLV c = (ConstructedTLV)this.childs.get(1);
        for (int i = 0; i < c.getElements(); ++i) {
            TLV t = c.get(i);
            if (!(t instanceof UTF8String)) continue;
            return ((UTF8String)t).toString();
        }
        return null;
    }

    public String getPrintableString() {
        ConstructedTLV c = (ConstructedTLV)this.childs.get(1);
        for (int i = 0; i < c.getElements(); ++i) {
            TLV t = c.get(i);
            if (!(t instanceof PrintableString)) continue;
            return ((PrintableString)t).toString();
        }
        return null;
    }

    public String getNumericString() {
        ConstructedTLV c = (ConstructedTLV)this.childs.get(1);
        for (int i = 0; i < c.getElements(); ++i) {
            TLV t = c.get(i);
            if (!t.getTag().equals((Object)Tag.TAG_NumericString)) continue;
            return new String(((PrimitiveTLV)t).getValue());
        }
        return null;
    }

    public int getInteger() {
        ConstructedTLV c = (ConstructedTLV)this.childs.get(1);
        for (int i = 0; i < c.getElements(); ++i) {
            TLV t = c.get(i);
            if (!(t instanceof IntegerTLV)) continue;
            return (int)((IntegerTLV)t).getLong();
        }
        return -1;
    }

    public LocalDate getLocalDate() {
        ConstructedTLV c = (ConstructedTLV)this.childs.get(1);
        for (int i = 0; i < c.getElements(); ++i) {
            TLV t = c.get(i);
            if (!(t instanceof GeneralizedTime)) continue;
            return ((GeneralizedTime)t).getLocalDate();
        }
        return null;
    }
}

