/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.util;

import java.io.Serializable;

public final class PKCS11Id
implements Serializable {
    private static final long serialVersionUID = -8611698105484679940L;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private byte[] data;

    public PKCS11Id() {
        this.data = null;
    }

    public PKCS11Id(byte[] byArray) {
        this.data = byArray;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PKCS11Id)) {
            return false;
        }
        PKCS11Id pKCS11Id = (PKCS11Id)object;
        byte[] byArray = pKCS11Id.getData();
        if (byArray == null) {
            return this.data == null;
        }
        if (this.data == null) {
            return false;
        }
        if (this.data.length != byArray.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.data == null) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            int n2 = (this.data[i] & 0xFF) << i % 4 * 8;
            n ^= n2;
        }
        return n;
    }

    public String toString() {
        if (this.data == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.data.length; ++i) {
            byte by = this.data[i];
            char c = digits[by >> 4 & 0xF];
            stringBuffer.append(c);
            c = digits[by & 0xF];
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

