/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Object;
import org.opensc.pkcs11.wrap.PKCS11Session;
import org.opensc.util.PKCS11Id;

public class PKCS11Certificate
extends PKCS11Object {
    public static final int CKC_X_509 = 0;
    public static final int CKC_X_509_ATTR_CERT = 1;
    public static final int CKC_VENDOR_DEFINED = Integer.MIN_VALUE;
    private X500Principal subject;
    private X500Principal issuer;
    private BigInteger serial;

    protected PKCS11Certificate(PKCS11Session pKCS11Session, long l) throws PKCS11Exception {
        super(pKCS11Session, l);
        byte[] byArray = this.getRawAttribute(257);
        this.subject = new X500Principal(byArray);
        byte[] byArray2 = this.getRawAttribute(129);
        this.issuer = new X500Principal(byArray2);
        byte[] byArray3 = this.getRawAttribute(130);
        this.serial = new BigInteger(byArray3);
    }

    public static List<PKCS11Certificate> getCertificates(PKCS11Session pKCS11Session) throws PKCS11Exception {
        long[] lArray = PKCS11Certificate.enumRawObjects(pKCS11Session, 1);
        ArrayList<PKCS11Certificate> arrayList = new ArrayList<PKCS11Certificate>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            arrayList.add(new PKCS11Certificate(pKCS11Session, lArray[i]));
        }
        return arrayList;
    }

    public static PKCS11Certificate findCertificate(PKCS11Session pKCS11Session, PKCS11Id pKCS11Id) throws PKCS11Exception {
        long l = PKCS11Certificate.findRawObject(pKCS11Session, 1, pKCS11Id);
        return new PKCS11Certificate(pKCS11Session, l);
    }

    public static PKCS11Certificate storeCertificate(PKCS11Session pKCS11Session, Certificate certificate, String string, boolean bl) throws PKCS11Exception, CertificateEncodingException {
        if (!(certificate instanceof X509Certificate)) {
            throw new CertificateEncodingException("Only X.509 certificates are supported.");
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        try {
            int n = 7;
            if (string != null) {
                ++n;
            }
            PKCS11Attribute[] pKCS11AttributeArray = new PKCS11Attribute[n];
            pKCS11AttributeArray[0] = new PKCS11Attribute(0, 1);
            pKCS11AttributeArray[1] = new PKCS11Attribute(128, 0);
            pKCS11AttributeArray[2] = new PKCS11Attribute(257, x509Certificate.getSubjectX500Principal().getEncoded());
            pKCS11AttributeArray[3] = new PKCS11Attribute(129, x509Certificate.getIssuerX500Principal().getEncoded());
            pKCS11AttributeArray[4] = new PKCS11Attribute(130, x509Certificate.getSerialNumber().toByteArray());
            pKCS11AttributeArray[5] = new PKCS11Attribute(17, certificate.getEncoded());
            pKCS11AttributeArray[6] = new PKCS11Attribute(134, bl);
            if (string != null) {
                pKCS11AttributeArray[7] = new PKCS11Attribute(3, string.getBytes("UTF-8"));
            }
            return new PKCS11Certificate(pKCS11Session, PKCS11Object.createObject(pKCS11Session, pKCS11AttributeArray));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CertificateEncodingException("Unexpected error during utf-8 encoding", unsupportedEncodingException);
        }
    }

    public Certificate getCertificate() throws PKCS11Exception, CertificateException {
        byte[] byArray = this.getRawAttribute(17);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return certificateFactory.generateCertificate(byteArrayInputStream);
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerial() {
        return this.serial;
    }

    public X500Principal getSubject() {
        return this.subject;
    }
}

