/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11;

import javax.security.auth.callback.Callback;

public class PKCS11EventCallback
implements Callback {
    public static final int NO_EVENT = 0;
    public static final int INITIALIZATION_FAILED = 1;
    public static final int WAITING_FOR_CARD = 2;
    public static final int CARD_WAIT_FAILED = 3;
    public static final int WAITING_FOR_SW_PIN = 4;
    public static final int PIN_ENTRY_FAILED = 5;
    public static final int PIN_ENTRY_ABORTED = 6;
    public static final int HW_AUTHENTICATION_IN_PROGRESS = 7;
    public static final int PIN_AUTHENTICATION_IN_PROGRESS = 8;
    public static final int AUHENTICATION_FAILED = 9;
    public static final int AUHENTICATION_ABORTED = 10;
    public static final int AUHENTICATION_SUCEEDED = 11;
    public static final int WAITING_FOR_SW_SO_PIN = 12;
    public static final int SO_PIN_ENTRY_FAILED = 13;
    public static final int SO_PIN_ENTRY_ABORTED = 14;
    public static final int SO_PIN_AUTHENTICATION_IN_PROGRESS = 15;
    public static final int SO_HW_AUTHENTICATION_IN_PROGRESS = 16;
    public static final int SO_AUHENTICATION_FAILED = 17;
    public static final int SO_AUHENTICATION_ABORTED = 18;
    public static final int SO_AUHENTICATION_SUCEEDED = 19;
    private int event;

    public PKCS11EventCallback(int n) {
        this.event = n;
    }

    public int getEvent() {
        return this.event;
    }

    public void setEvent(int n) {
        this.event = n;
    }

    public String toString() {
        switch (this.event) {
            default: {
                return "NO_EVENT";
            }
            case 1: {
                return "INITIALIZATION_FAILED";
            }
            case 2: {
                return "WAITING_FOR_CARD";
            }
            case 3: {
                return "CARD_WAIT_FAILED";
            }
            case 4: {
                return "WAITING_FOR_SW_PIN";
            }
            case 6: {
                return "PIN_ENTRY_ABORTED";
            }
            case 5: {
                return "PIN_ENTRY_FAILED";
            }
            case 12: {
                return "WAITING_FOR_SW_SO_PIN";
            }
            case 14: {
                return "SO_PIN_ENTRY_ABORTED";
            }
            case 13: {
                return "SO_PIN_ENTRY_FAILED";
            }
            case 7: {
                return "HW_AUTHENTICATION_IN_PROGRESS";
            }
            case 8: {
                return "PIN_AUTHENTICATION_IN_PROGRESS";
            }
            case 9: {
                return "AUHENTICATION_FAILED";
            }
            case 10: {
                return "AUHENTICATION_ABORTED";
            }
            case 11: {
                return "AUHENTICATION_SUCEEDED";
            }
            case 16: {
                return "SO_HW_AUTHENTICATION_IN_PROGRESS";
            }
            case 15: {
                return "SO_PIN_AUTHENTICATION_IN_PROGRESS";
            }
            case 17: {
                return "SO_AUHENTICATION_FAILED";
            }
            case 18: {
                return "SO_AUHENTICATION_ABORTED";
            }
            case 19: 
        }
        return "SO_AUHENTICATION_SUCEEDED";
    }
}

