/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.tlv.HexString;
import java.io.PrintStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;

public class Shell
extends ImporterTopLevel {
    private PrintStream ostream = System.out;
    private static final long serialVersionUID = -366457048667206297L;
    static final String clazzName = "Shell";

    public String getClassName() {
        return clazzName;
    }

    public Shell() {
        String[] names = new String[]{"print", "launch"};
        this.defineFunctionProperties(names, Shell.class, 2);
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        Shell shell = new Shell();
        return shell;
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Shell sh = (Shell)Shell.getTopLevelScope((Scriptable)funObj);
        for (int i = 0; i < args.length; ++i) {
            String str;
            if (i > 0) {
                sh.ostream.print(" ");
            }
            if (args[i] instanceof ByteString) {
                ByteString bs = (ByteString)((Object)args[i]);
                str = HexString.dump((byte[])bs.getBytes());
            } else {
                str = Context.toString((Object)args[i]);
            }
            sh.ostream.print(str);
        }
        sh.ostream.println();
    }

    public static void launch(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Engine engine = Engine.getEngine(thisObj);
        Require require = new Require(cx, thisObj, (ModuleScriptProvider)engine, null, null, false);
        require.requireMain(cx, Context.toString((Object)args[0]));
    }

    public void setOutputStream(PrintStream os) {
        this.ostream = os;
    }

    public static PrintStream getOutputStreamForObject(ScriptableObject scope) {
        Scriptable s = ScriptableObject.getTopLevelScope((Scriptable)scope);
        if (s instanceof Shell) {
            return ((Shell)s).ostream;
        }
        return null;
    }
}

