/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.ExecuteRequest;
import de.cardcontact.scdp.engine.ScriptCompletionListener;
import de.cardcontact.scdp.js.JsWrapFactory;
import java.util.concurrent.LinkedBlockingQueue;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.WrapFactory;

public class ScriptExecutor
extends Thread {
    private LinkedBlockingQueue<ExecuteRequest> requestQueue = new LinkedBlockingQueue();
    private boolean scriptProcessing = false;
    private boolean running = true;

    public ScriptExecutor() {
        this.setName("ScriptExecutor");
    }

    public void addRequest(ExecuteRequest request) {
        this.requestQueue.add(request);
    }

    public boolean isScriptRunning() {
        return this.scriptProcessing;
    }

    public void shutdown() {
        try {
            this.running = false;
            this.requestQueue.clear();
            if (this.scriptProcessing) {
                this.interrupt();
                Thread.sleep(1000L);
            }
            this.interrupt();
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void abort() {
        if (this.scriptProcessing) {
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        ExecuteRequest request = null;
        ScriptCompletionListener scl = null;
        Object result = null;
        Context cx = Context.enter();
        JsWrapFactory wf = new JsWrapFactory();
        cx.setWrapFactory((WrapFactory)wf);
        while (this.running) {
            try {
                request = this.requestQueue.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            scl = request.getScriptCompletionListener();
            try {
                this.scriptProcessing = true;
                result = ContextFactory.getGlobal().call((ContextAction)request);
                if (scl == null) continue;
                scl.scriptCompleted(result);
            }
            catch (RhinoException e) {
                if (scl != null) {
                    scl.scriptCompleted((Object)e);
                    continue;
                }
                e.printStackTrace();
            }
            finally {
                this.scriptProcessing = false;
            }
        }
        Context.exit();
    }
}

