/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.scsh3.GUIShell;
import de.cardcontact.scdp.scsh3.OutlineNodeRenderer;
import de.cardcontact.scdp.scsh3.OutlineNodeRendererSupport;
import de.cardcontact.scdp.scsh3.OutlineTreeModel;
import de.cardcontact.scdp.scsh3.ScriptEventRunner;
import de.cardcontact.scdp.scsh3.TreePopupMenuListener;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.scdp.utils.MutableTreeNode;
import de.cardcontact.tlv.TreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class OutlineNode
extends ScriptableObject
implements MutableTreeNode,
OutlineNodeRendererSupport,
TreePopupMenuListener,
ActionListener,
TreeExpansionListener,
TreeSelectionListener {
    private static final String clazzName = "OutlineNode";
    OutlineNode parent = null;
    boolean expandable = false;
    String name = null;
    OutlineTreeModel treeModel = null;
    ArrayList childs = new ArrayList();

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"OutlineNode() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, (String)clazzName, (Object[])args, (int)1, (int)2);
        OutlineNode node = new OutlineNode();
        node.name = ArgChecker.getString((Scriptable)ctorObj, (String)clazzName, (Object[])args, (int)0, null);
        node.expandable = ArgChecker.getBoolean((Scriptable)ctorObj, (String)clazzName, (Object[])args, (int)1, (boolean)false);
        return node;
    }

    public Object jsGet_parent() {
        return this.parent;
    }

    public Object jsGet_childs() {
        return Context.getCurrentContext().newArray((Scriptable)this, this.childs.toArray());
    }

    public static void jsFunction_show(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)1);
        String title = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (String)"untitled");
        OutlineNode root = (OutlineNode)thisObj;
        root.setParent(null);
        root.expandable = true;
        root.treeModel = new OutlineTreeModel((TreeNode)root);
        JTree jtree = new JTree(root.treeModel);
        jtree.addTreeExpansionListener(root.treeModel);
        jtree.addTreeSelectionListener(root.treeModel);
        jtree.addMouseListener(root.treeModel);
        ToolTipManager.sharedInstance().registerComponent(jtree);
        jtree.setCellRenderer(new OutlineNodeRenderer());
        GUIShell.instance.setOutline(jtree, "Outline");
        root.expand();
    }

    public static void jsFunction_insert(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)2);
        final OutlineNode outline = (OutlineNode)thisObj;
        final int index = ArgChecker.getInt((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)outline.getChildCount());
        if (args[0] instanceof OutlineNode) {
            final OutlineNode child = (OutlineNode)args[0];
            final OutlineNode root = (OutlineNode)outline.getRoot();
            if (root.treeModel == null) {
                outline.insert(child, index);
                child.setParent(outline);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        root.treeModel.insertNodeInto(child, outline, index);
                    }
                });
            }
        } else if (args[0] instanceof TreeNode) {
            final TreeNode child = (TreeNode)args[0];
            final OutlineNode root = (OutlineNode)outline.getRoot();
            outline.insert(child, index);
            if (root.treeModel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        root.treeModel.nodeWasInserted(child, (TreeNode)outline, index);
                    }
                });
            }
        } else {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (int)16, (int)0, (String)"Argument must be of type OutlineNode");
        }
    }

    public static void jsFunction_remove(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        OutlineNode child;
        OutlineNode outline;
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)1);
        if (args.length == 0) {
            outline = ((OutlineNode)thisObj).parent;
            if (outline == null) {
                GPError.throwAsGPErrorEx((Scriptable)thisObj, (int)2, (int)0, (String)"Can't determine parent for node.");
            }
            child = (OutlineNode)thisObj;
        } else {
            if (!(args[0] instanceof TreeNode)) {
                GPError.throwAsGPErrorEx((Scriptable)thisObj, (int)16, (int)0, (String)"Argument must be of type OutlineNode");
            }
            child = (TreeNode)args[0];
            outline = (OutlineNode)thisObj;
        }
        final OutlineNode root = (OutlineNode)outline.getRoot();
        if (root.treeModel == null) {
            outline.remove((TreeNode)child);
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ TreeNode val$child;
                final /* synthetic */ OutlineNode val$outline;
                {
                    this.val$child = treeNode;
                    this.val$outline = outlineNode2;
                }

                @Override
                public void run() {
                    root.treeModel.removeNodeFrom(this.val$child, this.val$outline);
                }
            });
        }
    }

    public static void jsFunction_setContextMenu(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        OutlineNode outline = (OutlineNode)thisObj;
        if (args[0] instanceof NativeArray) {
            outline.defineProperty("contextMenu", args[0], 0);
        } else {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (int)16, (int)0, (String)"Argument must be of type string array");
        }
    }

    public static void jsFunction_setToolTip(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)1);
        OutlineNode outline = (OutlineNode)thisObj;
        String toolTipText = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        outline.defineProperty("tooltip", toolTipText, 0);
    }

    public static void jsFunction_setIcon(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)1);
        final OutlineNode outline = (OutlineNode)thisObj;
        String iconName = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        outline.defineProperty("icon", iconName, 0);
        final OutlineNode root = (OutlineNode)outline.getRoot();
        if (root.treeModel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    root.treeModel.nodeChanged((TreeNode)outline);
                }
            });
        }
    }

    public static void jsFunction_setLabel(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String label;
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        final OutlineNode outline = (OutlineNode)thisObj;
        outline.name = label = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        final OutlineNode root = (OutlineNode)outline.getRoot();
        if (root.treeModel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    root.treeModel.nodeChanged((TreeNode)outline);
                }
            });
        }
    }

    public static void jsFunction_setUserObject(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        OutlineNode outline = (OutlineNode)thisObj;
        if (!(args[0] instanceof Scriptable)) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (int)16, (int)0, (String)"Argument must be of type scriptable object");
        }
        outline.defineProperty("userObject", args[0], 0);
    }

    public static void jsFunction_expand(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        OutlineNode outline = (OutlineNode)thisObj;
        final JTree tree = (JTree)GUIShell.instance.getOutline("Outline");
        final TreePath path = new TreePath(outline.getPathToRoot());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tree.expandPath(path);
            }
        });
    }

    public static void jsFunction_collapse(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        OutlineNode outline = (OutlineNode)thisObj;
        final JTree tree = (JTree)GUIShell.instance.getOutline("Outline");
        final TreePath path = new TreePath(outline.getPathToRoot());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tree.collapsePath(path);
            }
        });
    }

    public OutlineNode[] getPathToRoot() {
        return this.getPathToRoot(0);
    }

    protected OutlineNode[] getPathToRoot(int depth) {
        OutlineNode[] list = this.parent == null ? new OutlineNode[depth] : this.parent.getPathToRoot(++depth);
        list[list.length - depth] = this;
        return list;
    }

    public void removeFromParent() {
    }

    public void remove(int index) {
        this.childs.remove(index);
    }

    public void setUserObject(Object userObject) {
    }

    public void remove(TreeNode child) {
        this.childs.remove(child);
    }

    public void setParent(MutableTreeNode parent) {
        this.parent = (OutlineNode)parent;
    }

    public void insert(MutableTreeNode node, int index) {
        this.childs.add(index, node);
    }

    public void insert(TreeNode node, int index) {
        this.childs.add(index, node);
    }

    public int getChildCount() {
        return this.childs.size();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.childs.size() == 0 && !this.expandable;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.childs.get(childIndex);
    }

    public int getIndex(TreeNode child) {
        return this.childs.indexOf(child);
    }

    public TreeNode getRoot() {
        OutlineNode root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public void expand() {
        ScriptEventRunner ser = new ScriptEventRunner(this, "expand", null);
        ser.call(Context.getCurrentContext());
    }

    public void sendEvent(String event, String param) {
        ScriptEventRunner ser = new ScriptEventRunner(this, event, param);
        ser.start();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent ev) {
        this.sendEvent("collapse", null);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent ev) {
        this.sendEvent("expand", null);
    }

    @Override
    public void valueChanged(TreeSelectionEvent ev) {
        this.sendEvent("selected", null);
    }

    @Override
    public void treePopup(MouseEvent e) {
        Object o = this.get("contextMenu", (Scriptable)this);
        if (o instanceof NativeArray) {
            NativeArray menuList = (NativeArray)o;
            if (menuList.getLength() == 0L) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            int i = 0;
            while ((long)i < menuList.getLength()) {
                String str;
                o = menuList.get(i, (Scriptable)menuList);
                if (!(o instanceof CharSequence)) {
                    GPError.throwAsGPErrorEx((Scriptable)this, (int)16, (int)i, (String)"Entry in context menu must be String");
                }
                if ((str = ((CharSequence)o).toString()).equals("---")) {
                    popup.addSeparator();
                } else {
                    JMenuItem mi = new JMenuItem(str);
                    mi.addActionListener(this);
                    popup.add(mi);
                }
                ++i;
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.sendEvent("action", e.getActionCommand());
    }

    @Override
    public String getIcon() {
        Object o = this.get("icon", (Scriptable)this);
        if (o instanceof CharSequence) {
            return ((CharSequence)o).toString();
        }
        return null;
    }

    @Override
    public String getToolTip() {
        Object o = this.get("tooltip", (Scriptable)this);
        if (o instanceof CharSequence) {
            return ((CharSequence)o).toString();
        }
        return null;
    }

    public String jsFunction_toString() {
        return "OutlineNode: " + this.name;
    }

    public String toString() {
        return this.name;
    }
}

