/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.CharBuffer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class OptionDialog
implements ActionListener {
    private CharSequence result = null;
    private String defaultValue;
    private FileFilter fileFilter;
    private JDialog dialog;
    private JButton ok;
    private JButton cancel;
    private JButton browse;
    private JTextField textField;
    private JComboBox comboBox;

    public OptionDialog(Frame frame, String text) {
        this(frame, text, null);
    }

    public OptionDialog(Frame frame, String text, String defaultValue) {
        this.defaultValue = defaultValue;
        this.dialog = new JDialog(frame, "Configuration Option", true);
        this.dialog.setLocation(frame.getLocation().x + 100, frame.getLocation().y + 100);
        this.dialog.setMinimumSize(new Dimension(300, 100));
        JPanel contentPane = new JPanel(new BorderLayout(10, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialog.setContentPane(contentPane);
        JLabel label = new JLabel(text);
        this.dialog.add((Component)label, "North");
        JPanel panel = new JPanel();
        this.ok = new JButton(defaultValue == null ? "Yes" : "OK");
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        panel.add(this.ok);
        this.dialog.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(defaultValue == null ? "No" : "Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        panel.add(this.cancel);
        this.dialog.add((Component)panel, "South");
    }

    public void setSelection(String[] selection) {
        this.comboBox = new JComboBox<String>(selection);
        this.comboBox.setEditable(true);
        if (this.defaultValue != "") {
            this.comboBox.setSelectedItem(this.defaultValue);
        }
        this.dialog.add((Component)this.comboBox, "Center");
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.browse = new JButton("Browse...");
        this.browse.setActionCommand("browse");
        this.browse.addActionListener(this);
        this.dialog.add((Component)this.browse, "East");
        this.dialog.setMinimumSize(new Dimension(500, 100));
    }

    public void show() {
        if (this.comboBox == null && this.defaultValue != null) {
            this.textField = this.defaultValue.startsWith("*") ? new JPasswordField() : new JTextField(this.defaultValue);
            this.dialog.add((Component)this.textField, "Center");
        }
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void selectFile() {
        File f = new File(this.defaultValue);
        File dir = null;
        dir = f.isDirectory() ? f : f.getParentFile();
        JFileChooser fc = null;
        fc = dir != null ? new JFileChooser(dir) : new JFileChooser();
        fc.setFileFilter(this.fileFilter);
        fc.setFileSelectionMode(2);
        int rc = fc.showDialog(this.dialog, "Select");
        if (rc == 0) {
            String selectedFile = fc.getSelectedFile().getAbsolutePath();
            if (this.textField != null) {
                this.textField.setText(selectedFile);
            } else {
                this.comboBox.setSelectedItem(selectedFile);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("browse".equals(e.getActionCommand())) {
            this.selectFile();
        } else if ("cancel".equals(e.getActionCommand())) {
            this.result = null;
            this.dialog.setVisible(false);
        } else if ("ok".equals(e.getActionCommand())) {
            this.result = this.comboBox == null && this.defaultValue == null ? "OK" : (this.textField != null ? (this.textField instanceof JPasswordField ? CharBuffer.wrap(((JPasswordField)this.textField).getPassword()) : this.textField.getText()) : this.comboBox.getSelectedItem().toString());
            this.dialog.setVisible(false);
        }
    }

    public CharSequence getResult() {
        return this.result;
    }
}

