/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.scsh3.FileNameRegexFilter;
import de.cardcontact.scdp.scsh3.GUIShell;
import de.cardcontact.scdp.scsh3.OptionDialog;
import de.cardcontact.scdp.utils.ArgChecker;
import java.nio.CharBuffer;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Dialog
extends ScriptableObject {
    private static final long serialVersionUID = 9125547158003273076L;
    public static final String clazzName = "Dialog";

    public String getClassName() {
        return clazzName;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"frame", (Object)GUIShell.instance, (int)0);
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        return null;
    }

    public static Object jsStaticFunction_prompt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)4);
        String text = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        String defaultValue = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, null);
        String[] selection = null;
        if (args.length > 2 && args[2] != null) {
            if (!(args[2] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)16, (int)2, (String)"Argument must be array");
            }
            NativeArray na = (NativeArray)args[2];
            selection = new String[(int)na.getLength()];
            for (int i = 0; i < (int)na.getLength(); ++i) {
                selection[i] = Context.toString((Object)na.get(i, (Scriptable)na));
            }
        }
        String fileFilter = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)3, null);
        OptionDialog dialog = new OptionDialog(GUIShell.instance, text, defaultValue);
        if (selection != null) {
            dialog.setSelection(selection);
        }
        if (fileFilter != null) {
            FileFilter ff;
            int l = fileFilter.length();
            if (l == 0) {
                Pattern pattern = Pattern.compile(".*");
                ff = new FileNameRegexFilter("*.*", pattern);
            } else if (l > 2 && fileFilter.charAt(0) == '/' && fileFilter.charAt(l - 1) == '/') {
                String regex = fileFilter.substring(1, l - 1);
                Pattern pattern = Pattern.compile(regex);
                ff = new FileNameRegexFilter("Preselected Files (" + fileFilter + ")", pattern);
            } else {
                String extension = fileFilter;
                int dotofs = fileFilter.lastIndexOf(46);
                if (dotofs >= 0) {
                    extension = fileFilter.substring(dotofs + 1);
                }
                ff = new FileNameExtensionFilter(fileFilter, extension);
            }
            dialog.setFileFilter(ff);
        }
        dialog.show();
        CharSequence cs = dialog.getResult();
        if (cs == null) {
            return null;
        }
        if (defaultValue != null && defaultValue.startsWith("**")) {
            CharBuffer cb = (CharBuffer)cs;
            byte[] rsp = new byte[cb.length()];
            for (int i = 0; i < cb.length(); ++i) {
                char c = cb.charAt(i);
                if (c < ' ' || c > '\u007f') {
                    GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)16, (int)2, (String)"Data entered in PIN dialog must contain ASCII characters only");
                }
                rsp[i] = (byte)c;
                cb.put(0, '\u0000');
            }
            return ByteString.newInstance((Scriptable)thisObj, (byte[])rsp);
        }
        return cs.toString();
    }
}

