/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFilePartialAppID;
import opencard.opt.iso.fs.CardFileShortFileID;
import opencard.opt.iso.fs.CardFileSymbolicName;
import opencard.opt.iso.fs.CardIOException;

public abstract class CardFilePathComponent {
    protected String comp = null;

    protected CardFilePathComponent() {
    }

    protected CardFilePathComponent(String comp) {
        this.comp = comp;
    }

    private static boolean hex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    protected static CardFilePathComponent createComponent(String comp, int pos, String path, int total) throws CardIOException {
        if (comp.startsWith("/")) {
            return new CardFileSymbolicName(comp);
        }
        if (comp.startsWith(":")) {
            for (int i = 1; i < comp.length(); ++i) {
                if (CardFilePathComponent.hex(comp.charAt(i))) continue;
                throw new CardIOException("file ID can only contain hexadecimal characters (" + comp + ")");
            }
            if (comp.length() == 1) {
                throw new CardIOException("illegal empty file ID ':' \"" + comp + "\"");
            }
            if (comp.length() > 3) {
                return new CardFileFileID(comp);
            }
            if (comp.length() == 3 && pos == total - 1) {
                return new CardFileShortFileID(comp);
            }
            if (comp.length() == 3 && pos != total - 1) {
                throw new CardIOException("short file ID \"" + comp + "\" of path " + path + " must be the last component");
            }
            throw new CardIOException("malformed file ID component " + comp);
        }
        if (comp.startsWith("#") && !comp.startsWith("##")) {
            for (int i = 1; i < comp.length(); ++i) {
                if (CardFilePathComponent.hex(comp.charAt(i))) continue;
                throw new CardIOException("file ID can only contain hexadecimal characters (" + comp + ")");
            }
            if (comp.endsWith("*") && !comp.endsWith("**")) {
                return new CardFilePartialAppID(comp);
            }
            return new CardFileAppID(comp);
        }
        if (comp.endsWith("*") && !comp.endsWith("**")) {
            return new CardFilePartialAppID(comp);
        }
        return new CardFileAppID(comp);
    }

    public boolean equals(Object comp) {
        if (!(comp instanceof CardFilePathComponent)) {
            return false;
        }
        return this.comp.equals(((CardFilePathComponent)comp).comp);
    }

    public String toString() {
        return this.comp;
    }
}

