/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class ObjectIdentifierRegistry {
    private static ObjectIdentifierRegistry instance = null;
    private HashMap<String, String> nameMap = new HashMap();
    private HashMap<ByteStringWrapper, String> oidMap = new HashMap();

    private ObjectIdentifierRegistry() {
    }

    public static ObjectIdentifierRegistry getInstance() {
        if (instance == null) {
            instance = new ObjectIdentifierRegistry();
        }
        return instance;
    }

    protected static byte[] encodeOID(List<Integer> oid) {
        int val;
        int i;
        if (oid.size() < 2 || oid.get(0) < 0 || oid.get(0) > 2 || oid.get(1) < 0 || oid.get(1) > 39) {
            throw new IllegalArgumentException("Object identifier out of range");
        }
        int size = 1;
        for (i = 2; i < oid.size(); ++i) {
            val = oid.get(i);
            if (val < 0) {
                throw new IllegalArgumentException("Object identifier out of range");
            }
            do {
                ++size;
            } while ((val >>= 7) > 0);
        }
        byte[] value = new byte[size];
        value[0] = (byte)(40 * oid.get(0) + oid.get(1));
        int j = 1;
        for (i = 2; i < oid.size(); ++i) {
            val = oid.get(i);
            size = -7;
            do {
                size += 7;
            } while ((val >>= 7) > 0);
            val = oid.get(i);
            while (size >= 0) {
                value[j++] = (byte)(val >> size & 0x7F | 0x80);
                size -= 7;
            }
            int n = j - 1;
            value[n] = (byte)(value[n] & 0x7F);
        }
        return value;
    }

    private static ArrayList<Integer> parseObjectIdentifierString(String oid, int recursioncount) {
        if (recursioncount < 0) {
            throw new IllegalArgumentException("Recursive definition of " + oid);
        }
        StringTokenizer sp = new StringTokenizer(oid, " .");
        ArrayList<Integer> elements = new ArrayList<Integer>(sp.countTokens());
        while (sp.hasMoreTokens()) {
            Integer i;
            String temp = sp.nextToken();
            try {
                i = new Integer(temp);
                elements.add(i);
            }
            catch (NumberFormatException nfe) {
                if (temp.matches("^[\\w-]+\\(\\d+\\)$")) {
                    String nstr = temp.substring(temp.indexOf(40) + 1, temp.indexOf(41));
                    i = new Integer(nstr);
                    elements.add(i);
                    continue;
                }
                String str = instance.getOIDFor(temp);
                if (str == null) {
                    throw new IllegalArgumentException("'" + temp + "' is an unknown identifier");
                }
                elements.addAll(ObjectIdentifierRegistry.parseObjectIdentifierString(str, recursioncount - 1));
            }
        }
        return elements;
    }

    public static byte[] parseObjectIdentifier(String oid) {
        ArrayList<Integer> elements = ObjectIdentifierRegistry.parseObjectIdentifierString(oid, 100);
        return ObjectIdentifierRegistry.encodeOID(elements);
    }

    public void addIdentifier(String name, String oid) {
        String c = this.nameMap.get(name);
        if (c != null && !c.equals(oid)) {
            throw new IllegalArgumentException("'" + name + "' already defined as " + c);
        }
        byte[] encoded = ObjectIdentifierRegistry.parseObjectIdentifier(oid);
        ByteStringWrapper bsw = new ByteStringWrapper(encoded);
        c = this.oidMap.get(bsw);
        if (c != null && !c.equals(name)) {
            throw new IllegalArgumentException("'" + name + "' already defined by " + c);
        }
        this.nameMap.put(name, oid);
        this.oidMap.put(new ByteStringWrapper(encoded), name);
    }

    public String getOIDFor(String name) {
        return this.nameMap.get(name);
    }

    public String getNameFor(byte[] oid) {
        return this.oidMap.get(new ByteStringWrapper(oid));
    }

    public void addPKIXObjectIdentifier() {
        this.addIdentifier("id-pkix", "iso(1) identified-organization(3) dod(6) internet(1) security(5) mechanisms(5) pkix(7)");
        this.addIdentifier("id-pe", "id-pkix 1");
        this.addIdentifier("id-qt", "id-pkix 2");
        this.addIdentifier("id-kp", "id-pkix 3");
        this.addIdentifier("id-pda", "id-pkix 9");
        this.addIdentifier("id-qcs", "id-pkix 11");
        this.addIdentifier("id-ad", "id-pkix 48");
        this.addIdentifier("id-pe-biometricInfo", "id-pe 2");
        this.addIdentifier("id-pe-qcStatements", "id-pe 3");
        this.addIdentifier("id-pda-dateOfBirth", "id-pda 1");
        this.addIdentifier("id-pda-placeOfBirth", "id-pda 2");
        this.addIdentifier("id-pda-gender", "id-pda 3");
        this.addIdentifier("id-pda-countryOfCitizenship", "id-pda 4");
        this.addIdentifier("id-pda-countryOfResidence", "id-pda 5");
        this.addIdentifier("id-qt-cps", "id-qt 1");
        this.addIdentifier("id-qt-unotice", "id-qt 2");
        this.addIdentifier("id-ad-ocsp", "id-ad 1");
        this.addIdentifier("id-ad-caIssuers", "id-ad 2");
        this.addIdentifier("id-ad-timeStamping", "id-ad 3");
        this.addIdentifier("id-ad-caRepository", "id-ad 5");
        this.addIdentifier("id-at", "joint-iso-ccitt(2) ds(5) 4");
        this.addIdentifier("id-at-name", "id-at 41");
        this.addIdentifier("id-at-surname", "id-at  4");
        this.addIdentifier("id-at-givenName", "id-at 42");
        this.addIdentifier("id-at-initials", "id-at 43");
        this.addIdentifier("id-at-generationQualifier", "id-at 44");
        this.addIdentifier("id-at-commonName", "id-at 3");
        this.addIdentifier("id-at-localityName", "id-at 7");
        this.addIdentifier("id-at-stateOrProvinceName", "id-at 8");
        this.addIdentifier("id-at-organizationName", "id-at 10");
        this.addIdentifier("id-at-organizationalUnitName", "id-at 11");
        this.addIdentifier("id-at-title", "id-at 12");
        this.addIdentifier("id-at-dnQualifier", "id-at 46");
        this.addIdentifier("id-at-countryName", "id-at 6");
        this.addIdentifier("id-at-serialNumber", "id-at 5");
        this.addIdentifier("id-at-postalAddress", "id-at 16");
        this.addIdentifier("id-at-pseudonym", "id-at 65");
        this.addIdentifier("id-domainComponent", "0 9 2342 19200300 100 1 25");
        this.addIdentifier("id-userId", "ccitt(0) data(9) pss(2342) ucl(19200300) pilot(100) pilotAttributeType(1) 1");
        this.addIdentifier("id-qcs-pkixQCSyntax-v1", "id-qcs 1");
        this.addIdentifier("id-etsi-qcs", "itu-t(0) identified-organization(4) etsi(0) id-qc-profile(1862) 1");
        this.addIdentifier("id-etsi-qcs-QcCompliance", "id-etsi-qcs 1");
        this.addIdentifier("id-etsi-qcs-QcLimitValue", "id-etsi-qcs 2");
        this.addIdentifier("id-etsi-qcs-QcRetentionPeriod", "id-etsi-qcs 3");
        this.addIdentifier("id-etsi-qcs-QcSSCD", "id-etsi-qcs 4");
        this.addIdentifier("pkcs-9", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) 9");
        this.addIdentifier("id-emailAddress", "pkcs-9 1");
        this.addIdentifier("id-ce", "joint-iso-ccitt(2) ds(5) 29");
        this.addIdentifier("id-ce-authorityKeyIdentifier", "id-ce 35");
        this.addIdentifier("id-ce-subjectKeyIdentifier", "id-ce 14");
        this.addIdentifier("id-ce-keyUsage", "id-ce 15");
        this.addIdentifier("id-ce-privateKeyUsagePeriod", "id-ce 16");
        this.addIdentifier("id-ce-certificatePolicies", "id-ce 32");
        this.addIdentifier("anyPolicy", "id-ce-certificatePolicies 0");
        this.addIdentifier("id-ce-policyMappings", "id-ce 33");
        this.addIdentifier("id-ce-subjectAltName", "id-ce 17");
        this.addIdentifier("id-ce-issuerAltName", "id-ce 18");
        this.addIdentifier("id-ce-subjectDirectoryAttributes", "id-ce 9");
        this.addIdentifier("id-ce-basicConstraints", "id-ce 19");
        this.addIdentifier("id-ce-nameConstraints", "id-ce 30");
        this.addIdentifier("id-ce-policyConstraints", "id-ce 36");
        this.addIdentifier("id-ce-cRLDistributionPoints", "id-ce 31");
        this.addIdentifier("id-ce-extKeyUsage", "id-ce 37");
        this.addIdentifier("anyExtendedKeyUsage", "id-ce-extKeyUsage 0");
        this.addIdentifier("id-kp-serverAuth", "id-kp 1");
        this.addIdentifier("id-kp-clientAuth", "id-kp 2");
        this.addIdentifier("id-kp-codeSigning", "id-kp 3");
        this.addIdentifier("id-kp-emailProtection", "id-kp 4");
        this.addIdentifier("id-kp-timeStamping", "id-kp 8");
        this.addIdentifier("id-kp-OCSPSigning", "id-kp 9");
        this.addIdentifier("microsoft", "1 3 6 1 4 1 311");
        this.addIdentifier("szOID_KP_SMARTCARD_LOGON", "microsoft 20 2 2");
        this.addIdentifier("szOID_NT_PRINCIPAL_NAME", "microsoft 20 2 3");
        this.addIdentifier("id-ce-inhibitAnyPolicy", "id-ce 54");
        this.addIdentifier("id-ce-freshestCRL", "id-ce 46");
        this.addIdentifier("id-pe-authorityInfoAccess", "id-pe 1");
        this.addIdentifier("id-pe-subjectInfoAccess", "id-pe 11");
        this.addIdentifier("id-ce-cRLNumber", "id-ce 20");
        this.addIdentifier("id-ce-issuingDistributionPoint", "id-ce 28");
        this.addIdentifier("id-ce-deltaCRLIndicator", "id-ce 27");
        this.addIdentifier("id-ce-cRLReasons", "id-ce 21");
        this.addIdentifier("id-ce-certificateIssuer", "id-ce 29");
        this.addIdentifier("id-ce-holdInstructionCode", "id-ce 23");
        this.addIdentifier("holdInstruction", "joint-iso-itu-t(2) member-body(2) us(840) x9cm(10040) 2");
        this.addIdentifier("id-holdinstruction-none", "holdInstruction 1");
        this.addIdentifier("id-holdinstruction-callissuer", "holdInstruction 2");
        this.addIdentifier("id-holdinstruction-reject", "holdInstruction 3");
        this.addIdentifier("id-ce-invalidityDate", "id-ce 24");
        this.addIdentifier("secp192r1", "iso(1) member-body(2) us(840) ansi-X9-62(10045) curves(3) prime(1) 1");
        this.addIdentifier("secp192k1", "iso(1) identified-organization(3) certicom(132) curve(0) 31");
        this.addIdentifier("sect163k1", "iso(1) identified-organization(3) certicom(132) curve(0) 1");
        this.addIdentifier("sect163r2", "iso(1) identified-organization(3) certicom(132) curve(0) 15");
        this.addIdentifier("secp224r1", "iso(1) identified-organization(3) certicom(132) curve(0) 33");
        this.addIdentifier("secp224k1", "iso(1) identified-organization(3) certicom(132) curve(0) 32");
        this.addIdentifier("sect233k1", "iso(1) identified-organization(3) certicom(132) curve(0) 26");
        this.addIdentifier("sect233r1", "iso(1) identified-organization(3) certicom(132) curve(0) 27");
        this.addIdentifier("secp256r1", "iso(1) member-body(2) us(840) ansi-X9-62(10045) curves(3) prime(1) 7");
        this.addIdentifier("secp256k1", "iso(1) identified-organization(3) certicom(132) curve(0) 10");
        this.addIdentifier("sect283k1", "iso(1) identified-organization(3) certicom(132) curve(0) 16");
        this.addIdentifier("sect283r1", "iso(1) identified-organization(3) certicom(132) curve(0) 17");
        this.addIdentifier("secp384r1", "iso(1) identified-organization(3) certicom(132) curve(0) 34");
        this.addIdentifier("sect409k1", "iso(1) identified-organization(3) certicom(132) curve(0) 36");
        this.addIdentifier("sect409r1", "iso(1) identified-organization(3) certicom(132) curve(0) 37");
        this.addIdentifier("secp521r1", "iso(1) identified-organization(3) certicom(132) curve(0) 35");
        this.addIdentifier("sect571k1", "iso(1) identified-organization(3) certicom(132) curve(0) 38");
        this.addIdentifier("sect571r1", "iso(1) identified-organization(3) certicom(132) curve(0) 39");
        this.addIdentifier("id-ecDH", "iso(1) identified-organization(3) certicom(132) schemes(1) ecdh(12)");
        this.addIdentifier("id-ecMQV", "iso(1) identified-organization(3) certicom(132) schemes(1) ecmqv(13)");
        this.addIdentifier("id-md2", "iso(1) member-body(2) us(840) rsadsi(113549) digestAlgorithm(2) 2");
        this.addIdentifier("id-md5 ", "iso(1) member-body(2) us(840) rsadsi(113549) digestAlgorithm(2) 5");
        this.addIdentifier("id-sha1", "iso(1) identified-organization(3) oiw(14) secsig(3) algorithm(2) 26");
        this.addIdentifier("id-sha224", "joint-iso-itu-t(2) country(16) us(840) organization(1) gov(101) csor(3) nistalgorithm(4) hashalgs(2) 4");
        this.addIdentifier("id-sha256", "joint-iso-itu-t(2) country(16) us(840) organization(1) gov(101) csor(3) nistalgorithm(4) hashalgs(2) 1");
        this.addIdentifier("id-sha384", "joint-iso-itu-t(2) country(16) us(840) organization(1) gov(101) csor(3) nistalgorithm(4) hashalgs(2) 2");
        this.addIdentifier("id-sha512", "joint-iso-itu-t(2) country(16) us(840) organization(1) gov(101) csor(3) nistalgorithm(4) hashalgs(2) 3");
        this.addIdentifier("dhpublicnumber", "iso(1) member-body(2) us(840) ansi-x942(10046) number-type(2) 1");
        this.addIdentifier("id-keyExchangeAlgorithm", "joint-iso-itu-t(2) country(16) us(840) organization(1) gov(101) dod(2) infosec(1) algorithms(1) 22");
        this.addIdentifier("pkcs-1", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-1(1)");
        this.addIdentifier("rsaEncryption", "pkcs-1 1");
        this.addIdentifier("md2WithRSAEncryption", "pkcs-1 2");
        this.addIdentifier("md5WithRSAEncryption", "pkcs-1 4");
        this.addIdentifier("sha1WithRSAEncryption", "pkcs-1 5");
        this.addIdentifier("id-RSAES-OAEP", "pkcs-1 7");
        this.addIdentifier("id-mgf1", "pkcs-1 8");
        this.addIdentifier("id-pSpecified", "pkcs-1 9");
        this.addIdentifier("id-RSASSA-PSS", "pkcs-1 10");
        this.addIdentifier("sha256WithRSAEncryption", "pkcs-1 11");
        this.addIdentifier("sha384WithRSAEncryption", "pkcs-1 12");
        this.addIdentifier("sha512WithRSAEncryption", "pkcs-1 13");
        this.addIdentifier("id-dsa-with-sha1", "iso(1) member-body(2) us(840) x9-57(10040) x9algorithm(4) 3");
        this.addIdentifier("id-dsa-with-sha224", "joint-iso-ccitt(2) country(16) us(840) organization(1) gov(101) csor(3) algorithms(4) id-dsa-with-sha2(3) 1");
        this.addIdentifier("id-dsa-with-sha256", "joint-iso-ccitt(2) country(16) us(840) organization(1) gov(101) csor(3) algorithms(4) id-dsa-with-sha2(3) 2");
        this.addIdentifier("ecdsa-with-SHA1", "iso(1) member-body(2) us(840) ansi-X9-62(10045) signatures(4) 1");
        this.addIdentifier("ecdsa-with-SHA2", "iso(1) member-body(2) us(840) ansi-X9-62(10045) signatures(4) ecdsa-with-SHA2(3)");
        this.addIdentifier("ecdsa-with-SHA224", "ecdsa-with-SHA2 1");
        this.addIdentifier("ecdsa-with-SHA256", "ecdsa-with-SHA2 2");
        this.addIdentifier("ecdsa-with-SHA384", "ecdsa-with-SHA2 3");
        this.addIdentifier("ecdsa-with-SHA512", "ecdsa-with-SHA2 4");
        this.addIdentifier("CryptographicMessageSyntax", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-9(9) smime(16) modules(0) cms(1)");
        this.addIdentifier("id-alg-ESDH", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-9(9) smime(16) alg(3) 5");
        this.addIdentifier("id-alg-CMS3DESwrap", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-9(9) smime(16) alg(3) 6");
        this.addIdentifier("id-alg-CMSRC2wrap", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-9(9) smime(16) alg(3) 7");
        this.addIdentifier("des-ede3-cbc", "iso(1) member-body(2) us(840) rsadsi(113549) encryptionAlgorithm(3) 7");
        this.addIdentifier("rc2-cbc", "iso(1) member-body(2) us(840) rsadsi(113549) encryptionAlgorithm(3) 2");
        this.addIdentifier("hMAC-SHA1", "iso(1) identified-organization(3) dod(6) internet(1) security(5) mechanisms(5) 8 1 2");
        this.addIdentifier("id-ct-contentInfo", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-9(9) smime(16) ct(1) 6");
        this.addIdentifier("id-data", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs7(7) 1");
        this.addIdentifier("id-signedData", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs7(7) 2");
        this.addIdentifier("id-envelopedData", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs7(7) 3");
        this.addIdentifier("id-digestedData", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs7(7) 5");
        this.addIdentifier("id-encryptedData", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs7(7) 6");
        this.addIdentifier("id-ct-authData", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-9(9) smime(16) ct(1) 2");
        this.addIdentifier("id-contentType", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs9(9) 3");
        this.addIdentifier("id-messageDigest", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs9(9) 4");
        this.addIdentifier("id-signingTime", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs9(9) 5");
        this.addIdentifier("id-countersignature", "iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs9(9) 6");
        this.addIdentifier("dhSinglePass_StdDH_SHA1KDF", "1.3.133.16.840.63.0.2");
        this.addIdentifier("id-aes", "2.16.840.1.101.3.4.1");
    }

    public void addICAOObjectIdentifiers() {
        this.addIdentifier("id-icao", "2.23.136");
        this.addIdentifier("id-icao-mrtd", "id-icao 1");
        this.addIdentifier("id-icao-mrtd-security", "id-icao-mrtd 1");
        this.addIdentifier("id-icao-ldsSecurityObject", "id-icao-mrtd-security 1");
        this.addIdentifier("id-icao-cscaMasterList", "id-icao-mrtd-security 2");
        this.addIdentifier("id-icao-cscaMasterListSigningKey", "id-icao-mrtd-security 3");
        this.addIdentifier("bsi-de", "itu-t(0) identified-organization(4) etsi(0) reserved(127) etsi-identified-organization(0) 7");
        this.addIdentifier("id-ecc", "bsi-de algorithms(1) 1");
        this.addIdentifier("ansi-X9-62", "iso(1) member-body(2) us(840) 10045");
        this.addIdentifier("id-publicKeyType", "ansi-X9-62 keyType(2)");
        this.addIdentifier("id-ecPublicKey", "id-publicKeyType 1");
        this.addIdentifier("id-fieldType", "ansi-X9-62 fieldType(1)");
        this.addIdentifier("prime-field", "id-fieldType 1");
        this.addIdentifier("id-ecSigType", "ansi-X9-62 signatures(4)");
        this.addIdentifier("id-ecTLVKeyFormat", "id-ecc keyType(2) 2");
        this.addIdentifier("id-ecTLVPublicKey", "id-ecTLVKeyFormat unrestricted(1)");
        this.addIdentifier("ecdsa-plain-signatures", "id-ecc signatures(4) 1");
        this.addIdentifier("ecdsa-plain-SHA1", "ecdsa-plain-signatures 1");
        this.addIdentifier("ecdsa-plain-SHA224", "ecdsa-plain-signatures 2");
        this.addIdentifier("ecdsa-plain-SHA256", "ecdsa-plain-signatures 3");
        this.addIdentifier("ecdsa-plain-SHA384", "ecdsa-plain-signatures 4");
        this.addIdentifier("ecdsa-plain-SHA512", "ecdsa-plain-signatures 5");
        this.addIdentifier("ecdsa-plain-RIPEMD160", "ecdsa-plain-signatures 6");
        this.addIdentifier("ecka-eg", "id-ecc key-establishment(5) 1");
        this.addIdentifier("ecka-eg-X963KDF", "ecka-eg 1");
        this.addIdentifier("ecka-eg-X963KDF-SHA1", "ecka-eg-X963KDF 1");
        this.addIdentifier("ecka-eg-X963KDF-SHA224", "ecka-eg-X963KDF 2");
        this.addIdentifier("ecka-eg-X963KDF-SHA256", "ecka-eg-X963KDF 3");
        this.addIdentifier("ecka-eg-X963KDF-SHA384", "ecka-eg-X963KDF 4");
        this.addIdentifier("ecka-eg-X963KDF-SHA512", "ecka-eg-X963KDF 5");
        this.addIdentifier("ecka-eg-X963KDF-RIPEMD160", "ecka-eg-X963KDF 6");
        this.addIdentifier("ecka-eg-SessionKDF", "ecka-eg 2");
        this.addIdentifier("ecka-eg-SessionKDF-3DES", "ecka-eg-SessionKDF 1");
        this.addIdentifier("ecka-eg-SessionKDF-AES128", "ecka-eg-SessionKDF 2");
        this.addIdentifier("ecka-eg-SessionKDF-AES192", "ecka-eg-SessionKDF 3");
        this.addIdentifier("ecka-eg-SessionKDF-AES256", "ecka-eg-SessionKDF 4");
        this.addIdentifier("ecka-dh", "id-ecc key-establishment(5) 2");
        this.addIdentifier("ecka-dh-X963KDF", "ecka-dh 1");
        this.addIdentifier("ecka-dh-X963KDF-SHA1", "ecka-dh-X963KDF 1");
        this.addIdentifier("ecka-dh-X963KDF-SHA224", "ecka-dh-X963KDF 2");
        this.addIdentifier("ecka-dh-X963KDF-SHA256", "ecka-dh-X963KDF 3");
        this.addIdentifier("ecka-dh-X963KDF-SHA384", "ecka-dh-X963KDF 4");
        this.addIdentifier("ecka-dh-X963KDF-SHA512", "ecka-dh-X963KDF 5");
        this.addIdentifier("ecka-dh-X963KDF-RIPEMD160", "ecka-dh-X963KDF 6");
        this.addIdentifier("ecka-dh-SessionKDF", "ecka-dh 2");
        this.addIdentifier("ecka-dh-SessionKDF-3DES", "ecka-dh-SessionKDF 1");
        this.addIdentifier("ecka-dh-SessionKDF-AES128", "ecka-dh-SessionKDF 2");
        this.addIdentifier("ecka-dh-SessionKDF-AES192", "ecka-dh-SessionKDF 3");
        this.addIdentifier("ecka-dh-SessionKDF-AES256", "ecka-dh-SessionKDF 4");
        this.addIdentifier("ecStdCurvesAndGeneration", "iso(1) identified-organization(3) teletrust(36) algorithm(3) signature-algorithm(3) ecSign(2) ecStdCurvesAndGeneration(8)");
        this.addIdentifier("ellipticCurve", "ecStdCurvesAndGeneration 1");
        this.addIdentifier("versionOne", "ellipticCurve 1");
        this.addIdentifier("brainpoolP160r1", "versionOne 1");
        this.addIdentifier("brainpoolP160t1", "versionOne 2");
        this.addIdentifier("brainpoolP192r1", "versionOne 3");
        this.addIdentifier("brainpoolP192t1", "versionOne 4");
        this.addIdentifier("brainpoolP224r1", "versionOne 5");
        this.addIdentifier("brainpoolP224t1", "versionOne 6");
        this.addIdentifier("brainpoolP256r1", "versionOne 7");
        this.addIdentifier("brainpoolP256t1", "versionOne 8");
        this.addIdentifier("brainpoolP320r1", "versionOne 9");
        this.addIdentifier("brainpoolP320t1", "versionOne 10");
        this.addIdentifier("brainpoolP384r1", "versionOne 11");
        this.addIdentifier("brainpoolP384t1", "versionOne 12");
        this.addIdentifier("brainpoolP512r1", "versionOne 13");
        this.addIdentifier("brainpoolP512t1", "versionOne 14");
        this.addIdentifier("id-PACE", "bsi-de protocols(2) smartcard(2) 4");
        this.addIdentifier("id-PACE-DH-GM", "id-PACE 1");
        this.addIdentifier("id-PACE-DH-GM-3DES-CBC-CBC", "id-PACE-DH-GM 1");
        this.addIdentifier("id-PACE-DH-GM-AES-CBC-CMAC-128", "id-PACE-DH-GM 2");
        this.addIdentifier("id-PACE-DH-GM-AES-CBC-CMAC-192", "id-PACE-DH-GM 3");
        this.addIdentifier("id-PACE-DH-GM-AES-CBC-CMAC-256", "id-PACE-DH-GM 4");
        this.addIdentifier("id-PACE-ECDH-GM", "id-PACE 2");
        this.addIdentifier("id-PACE-ECDH-GM-3DES-CBC-CBC", "id-PACE-ECDH-GM 1");
        this.addIdentifier("id-PACE-ECDH-GM-AES-CBC-CMAC-128", "id-PACE-ECDH-GM 2");
        this.addIdentifier("id-PACE-ECDH-GM-AES-CBC-CMAC-192", "id-PACE-ECDH-GM 3");
        this.addIdentifier("id-PACE-ECDH-GM-AES-CBC-CMAC-256", "id-PACE-ECDH-GM 4");
        this.addIdentifier("id-PACE-DH-IM", "id-PACE 3");
        this.addIdentifier("id-PACE-DH-IM-3DES-CBC-CBC", "id-PACE-DH-IM 1");
        this.addIdentifier("id-PACE-DH-IM-AES-CBC-CMAC-128", "id-PACE-DH-IM 2");
        this.addIdentifier("id-PACE-DH-IM-AES-CBC-CMAC-192", "id-PACE-DH-IM 3");
        this.addIdentifier("id-PACE-DH-IM-AES-CBC-CMAC-256", "id-PACE-DH-IM 4");
        this.addIdentifier("id-PACE-ECDH-IM", "id-PACE 4");
        this.addIdentifier("id-PACE-ECDH-IM-3DES-CBC-CBC", "id-PACE-ECDH-IM 1");
        this.addIdentifier("id-PACE-ECDH-IM-AES-CBC-CMAC-128", "id-PACE-ECDH-IM 2");
        this.addIdentifier("id-PACE-ECDH-IM-AES-CBC-CMAC-192", "id-PACE-ECDH-IM 3");
        this.addIdentifier("id-PACE-ECDH-IM-AES-CBC-CMAC-256", "id-PACE-ECDH-IM 4");
        this.addIdentifier("id-CA", "bsi-de protocols(2) smartcard(2) 3");
        this.addIdentifier("id-CA-DH", "id-CA 1");
        this.addIdentifier("id-CA-DH-3DES-CBC-CBC", "id-CA-DH 1");
        this.addIdentifier("id-CA-DH-AES-CBC-CMAC-128", "id-CA-DH 2");
        this.addIdentifier("id-CA-DH-AES-CBC-CMAC-192", "id-CA-DH 3");
        this.addIdentifier("id-CA-DH-AES-CBC-CMAC-256", "id-CA-DH 4");
        this.addIdentifier("id-CA-ECDH", "id-CA 2");
        this.addIdentifier("id-CA-ECDH-3DES-CBC-CBC", "id-CA-ECDH 1");
        this.addIdentifier("id-CA-ECDH-AES-CBC-CMAC-128", "id-CA-ECDH 2");
        this.addIdentifier("id-CA-ECDH-AES-CBC-CMAC-192", "id-CA-ECDH 3");
        this.addIdentifier("id-CA-ECDH-AES-CBC-CMAC-256", "id-CA-ECDH 4");
        this.addIdentifier("id-PK", "bsi-de protocols(2) smartcard(2) 1 ");
        this.addIdentifier("id-PK-DH", "id-PK 1");
        this.addIdentifier("id-PK-ECDH", "id-PK 2");
        this.addIdentifier("id-TA", "bsi-de protocols(2) smartcard(2) 2");
        this.addIdentifier("id-TA-RSA", "id-TA 1");
        this.addIdentifier("id-TA-RSA-v1-5-SHA-1", "id-TA-RSA 1");
        this.addIdentifier("id-TA-RSA-v1-5-SHA-256", "id-TA-RSA 2");
        this.addIdentifier("id-TA-RSA-PSS-SHA-1", "id-TA-RSA 3");
        this.addIdentifier("id-TA-RSA-PSS-SHA-256", "id-TA-RSA 4");
        this.addIdentifier("id-TA-RSA-v1-5-SHA-512", "id-TA-RSA 5");
        this.addIdentifier("id-TA-RSA-PSS-SHA-512", "id-TA-RSA 6");
        this.addIdentifier("id-TA-ECDSA", "id-TA 2");
        this.addIdentifier("id-TA-ECDSA-SHA-1", "id-TA-ECDSA 1");
        this.addIdentifier("id-TA-ECDSA-SHA-224", "id-TA-ECDSA 2");
        this.addIdentifier("id-TA-ECDSA-SHA-256", "id-TA-ECDSA 3");
        this.addIdentifier("id-TA-ECDSA-SHA-384", "id-TA-ECDSA 4");
        this.addIdentifier("id-TA-ECDSA-SHA-512", "id-TA-ECDSA 5");
        this.addIdentifier("id-RI", "bsi-de protocols(2) smartcard(2) 5");
        this.addIdentifier("id-RI-DH", "id-RI 1");
        this.addIdentifier("id-RI-DH-SHA-1", "id-RI-DH 1");
        this.addIdentifier("id-RI-DH-SHA-224", "id-RI-DH 2");
        this.addIdentifier("id-RI-DH-SHA-256", "id-RI-DH 3");
        this.addIdentifier("id-RI-ECDH", "id-RI 2");
        this.addIdentifier("id-RI-ECDH-SHA-1", "id-RI-ECDH 1");
        this.addIdentifier("id-RI-ECDH-SHA-224", "id-RI-ECDH 2");
        this.addIdentifier("id-RI-ECDH-SHA-256", "id-RI-ECDH 3");
        this.addIdentifier("id-CI", "bsi-de protocols(2) smartcard(2) 6");
        this.addIdentifier("id-auxiliaryData", "bsi-de applications(3) mrtd(1) 4");
        this.addIdentifier("id-DateOfBirth", "id-auxiliaryData 1");
        this.addIdentifier("id-DateOfExpiry", "id-auxiliaryData 2");
        this.addIdentifier("id-CommunityID", "id-auxiliaryData 3");
        this.addIdentifier("id-extensions", "bsi-de applications(3) mrtd(1) 3");
        this.addIdentifier("id-description", "id-extensions 1");
        this.addIdentifier("id-plainFormat", "id-description 1");
        this.addIdentifier("id-htmlFormat", "id-description 2");
        this.addIdentifier("id-pdfFormat", "id-description 3");
        this.addIdentifier("id-sector", "id-extensions 2");
        this.addIdentifier("id-eIDSecurity", "bsi-de protocols(2) smartcard(2) 7");
        this.addIdentifier("id-PT", "bsi-de protocols(2) smartcard(2) 8");
        this.addIdentifier("id-roles", "bsi-de applications(3) mrtd(1) 2");
        this.addIdentifier("id-DefectList", "bsi-de applications(3) mrtd(1) 5");
        this.addIdentifier("id-AuthDefect", "id-DefectList 1");
        this.addIdentifier("id-CertRevoked", "id-AuthDefect 1");
        this.addIdentifier("id-CertReplaced", "id-AuthDefect 2");
        this.addIdentifier("id-ChipAuthKeyRevoked", "id-AuthDefect 3");
        this.addIdentifier("id-ActiveAuthKeyRevoked", "id-AuthDefect 4");
        this.addIdentifier("id-ActiveAuthKeyRevoked", "id-AuthDefect 4");
        this.addIdentifier("id-ePassportDefect", "id-DefectList 2");
        this.addIdentifier("id-ePassportDGMalformed", "id-ePassportDefect 1");
        this.addIdentifier("id-SODInvalid", "id-ePassportDefect 2");
        this.addIdentifier("id-eIDDefect", "id-DefectList 3");
        this.addIdentifier("id-eIDDGMalformed", "id-eIDDefect 1");
        this.addIdentifier("id-eIDIntegrity", "id-eIDDefect 2");
        this.addIdentifier("id-DocumentDefect", "id-DefectList 4");
        this.addIdentifier("id-CardSecurityMalformed", "id-DocumentDefect 1");
        this.addIdentifier("id-ChipSecurityMalformed", "id-DocumentDefect 2");
        this.addIdentifier("id-PowerDownReq", "id-DocumentDefect 3");
        this.addIdentifier("id-ListContentDescription", "bsi-de applications(3) mrtd(1) 6");
        this.addIdentifier("id-IS", "id-roles 1");
        this.addIdentifier("id-AT", "id-roles 2");
        this.addIdentifier("id-ST", "id-roles 3");
        this.addIdentifier("id-eID", "bsi-de applications(3) 2");
        this.addIdentifier("id-SecurityObject", "id-eID 1");
        this.addIdentifier("id-BlackList", "id-eID 2");
        this.addIdentifier("standardizedDomainParameter", "bsi-de algorithms(1) 2");
        this.addIdentifier("id-csn-369791", "iso(1) member-body(2) cz(203) moi(7064) orpeg(1) cdbp(1) csn369791(369791)");
        this.addIdentifier("id-csn-369791-tls-client", "id-csn-369791 1");
        this.addIdentifier("id-csn-369791-tls-server", "id-csn-369791 2");
    }

    public void addCardContactObjectIdentifiers() {
        this.addIdentifier("CardContact", "1.3.6.1.4.1.24991");
        this.addIdentifier("OpenSCDP", "CardContact 1");
        this.addIdentifier("cc-iso7816", "CardContact 2");
        this.addIdentifier("cc-pki", "CardContact 3");
        this.addIdentifier("cc-format", "CardContact 4");
        this.addIdentifier("cc-gp-profiles", "CardContact 16");
        this.addIdentifier("scsh3", "OpenSCDP 1");
        this.addIdentifier("scsh3gui", "OpenSCDP 2");
        this.addIdentifier("SmartCard-HSM", "cc-iso7816 1");
        this.addIdentifier("cc-apdutest", "cc-iso7816 2");
        this.addIdentifier("cc-packages", "cc-iso7816 127");
        this.addIdentifier("cc-roles", "cc-pki 1");
        this.addIdentifier("cc-role-sc-hsm", "cc-roles 1");
        this.addIdentifier("cc-role-bw-se", "cc-roles 2");
        this.addIdentifier("cc-extensions", "cc-pki 2");
        this.addIdentifier("id-IMPU", "cc-extensions 1");
        this.addIdentifier("id-key-domain-uid", "cc-extensions 2");
        this.addIdentifier("id-security-classification", "cc-extensions 3");
        this.addIdentifier("cc-ff-deviceid", "cc-format 1");
        this.addIdentifier("cc-ff-kdm", "cc-format 2");
        this.addIdentifier("cc-ff-pka", "cc-format 3");
        this.addIdentifier("cc-ff-kda", "cc-format 4");
        this.addIdentifier("cc-ff-kdc", "cc-format 5");
        this.addIdentifier("cc-kdc-groupvpn-v1", "cc-ff-kdc 1 1");
        this.addIdentifier("cc-kdc-psk-v1", "cc-ff-kdc 2 1");
    }

    public void addCommonObjectIdentifiers() {
        this.addPKIXObjectIdentifier();
        this.addICAOObjectIdentifiers();
        this.addCardContactObjectIdentifiers();
    }

    private class ByteStringWrapper {
        private final byte[] bs;

        public ByteStringWrapper(byte[] bs) {
            this.bs = bs;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bs);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ByteStringWrapper)) {
                return false;
            }
            return Arrays.equals(this.bs, ((ByteStringWrapper)o).bs);
        }
    }
}

