/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import org.opensc.pkcs11.wrap.PKCS11DSAPrivateKey;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Key;
import org.opensc.pkcs11.wrap.PKCS11NeDSAPrivateKey;
import org.opensc.pkcs11.wrap.PKCS11NeRSAPrivateKey;
import org.opensc.pkcs11.wrap.PKCS11Object;
import org.opensc.pkcs11.wrap.PKCS11PublicKey;
import org.opensc.pkcs11.wrap.PKCS11RSAPrivateKey;
import org.opensc.pkcs11.wrap.PKCS11Session;
import org.opensc.util.PKCS11Id;

public class PKCS11PrivateKey
extends PKCS11Key
implements PrivateKey {
    private static final long serialVersionUID = 930054758668115904L;
    boolean extractable;
    boolean sensitive;

    protected PKCS11PrivateKey(PKCS11Session pKCS11Session, int n, boolean bl, long l) throws PKCS11Exception {
        super(pKCS11Session, n, l);
        this.extractable = bl;
        this.sensitive = super.getBooleanAttribute(259);
    }

    private static PKCS11PrivateKey makePrivateKey(PKCS11Session pKCS11Session, long l, int n, boolean bl) throws PKCS11Exception {
        switch (n) {
            case 0: {
                if (bl) {
                    return new PKCS11RSAPrivateKey(pKCS11Session, l);
                }
                return new PKCS11NeRSAPrivateKey(pKCS11Session, l);
            }
            case 1: {
                if (bl) {
                    return new PKCS11DSAPrivateKey(pKCS11Session, l);
                }
                return new PKCS11NeDSAPrivateKey(pKCS11Session, l);
            }
        }
        return new PKCS11PrivateKey(pKCS11Session, n, bl, l);
    }

    public static List<PKCS11PrivateKey> getPrivateKeys(PKCS11Session pKCS11Session) throws PKCS11Exception {
        long[] lArray = PKCS11PrivateKey.enumRawObjects(pKCS11Session, 3);
        ArrayList<PKCS11PrivateKey> arrayList = new ArrayList<PKCS11PrivateKey>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            int n = PKCS11Object.getULongAttribute(pKCS11Session, lArray[i], 256);
            boolean bl = PKCS11Object.getBooleanAttribute(pKCS11Session, lArray[i], 354);
            PKCS11PrivateKey pKCS11PrivateKey = PKCS11PrivateKey.makePrivateKey(pKCS11Session, lArray[i], n, bl);
            arrayList.add(pKCS11PrivateKey);
        }
        return arrayList;
    }

    public static PKCS11PrivateKey findPrivateKey(PKCS11Session pKCS11Session, PKCS11Id pKCS11Id) throws PKCS11Exception {
        long l = PKCS11PrivateKey.findRawObject(pKCS11Session, 3, pKCS11Id);
        int n = PKCS11Object.getULongAttribute(pKCS11Session, l, 256);
        boolean bl = PKCS11Object.getBooleanAttribute(pKCS11Session, l, 354);
        return PKCS11PrivateKey.makePrivateKey(pKCS11Session, l, n, bl);
    }

    public PKCS11PublicKey getPublicKey() throws PKCS11Exception {
        return PKCS11PublicKey.findPublicKey((PKCS11Session)this.getParent(), this.getId());
    }

    @Override
    public String getFormat() {
        return null;
    }

    public boolean isExtractable() {
        return this.extractable;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }
}

