/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.security.Key;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Object;
import org.opensc.pkcs11.wrap.PKCS11Session;

public class PKCS11Key
extends PKCS11Object
implements Key {
    private static final long serialVersionUID = -2438490448592590194L;
    private int keyType = super.getULongAttribute(256);
    private int keyBits = 0;
    public static final int CKK_RSA = 0;
    public static final int CKK_DSA = 1;
    public static final int CKK_DH = 2;
    public static final int CKK_ECDSA = 3;
    public static final int CKK_EC = 3;
    public static final int CKK_X9_42_DH = 4;
    public static final int CKK_KEA = 5;
    public static final int CKK_GENERIC_SECRET = 16;
    public static final int CKK_RC2 = 17;
    public static final int CKK_RC4 = 18;
    public static final int CKK_DES = 19;
    public static final int CKK_DES2 = 20;
    public static final int CKK_DES3 = 21;
    public static final int CKK_CAST = 22;
    public static final int CKK_CAST3 = 23;
    public static final int CKK_CAST5 = 24;
    public static final int CKK_CAST128 = 24;
    public static final int CKK_RC5 = 25;
    public static final int CKK_IDEA = 26;
    public static final int CKK_SKIPJACK = 27;
    public static final int CKK_BATON = 28;
    public static final int CKK_JUNIPER = 29;
    public static final int CKK_CDMF = 30;
    public static final int CKK_AES = 31;

    protected PKCS11Key(PKCS11Session pKCS11Session, int n, long l) throws PKCS11Exception {
        super(pKCS11Session, l);
        try {
            this.keyBits = super.getULongAttribute(289);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
    }

    public int getKeyType() {
        return this.keyType;
    }

    public int getKeyBits() {
        return this.keyBits;
    }

    @Override
    public String getAlgorithm() {
        switch (this.keyType) {
            case 0: {
                return "RSA";
            }
            case 1: {
                return "DSA";
            }
            case 2: {
                return "DiffieHellman";
            }
            case 19: {
                return "DES";
            }
            case 20: {
                return "DESede";
            }
            case 21: {
                return "DESede";
            }
            case 31: {
                return "AES";
            }
            case 17: {
                return "RC2";
            }
            case 18: {
                return "RC4";
            }
            case 25: {
                return "RC5";
            }
            case 3: {
                return "ECDSA";
            }
        }
        return null;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        throw new SecurityException("Cannot get encoded version of a cryptographic key resident on a hardware token.");
    }
}

