/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.ObjectIdentifierRegistry;
import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.util.StringTokenizer;

public class ObjectIdentifier
extends PrimitiveTLV {
    public ObjectIdentifier(int[] oid) {
        super(new Tag(6, 0, false), null);
        this.fromIntArray(oid);
    }

    public ObjectIdentifier(ParseBuffer pb) throws TLVEncodingException {
        super(pb);
    }

    public ObjectIdentifier(byte[] value) {
        super(new Tag(6, 0, false), value);
    }

    public ObjectIdentifier(String oid) {
        super(new Tag(6, 0, false), null);
        this.fromString(oid);
    }

    public ObjectIdentifier(int[] baseoid, int[] extoid) {
        super(new Tag(6, 0, false), null);
        int[] oid = new int[baseoid.length + extoid.length];
        System.arraycopy(baseoid, 0, oid, 0, baseoid.length);
        System.arraycopy(extoid, 0, oid, baseoid.length, extoid.length);
        this.fromIntArray(oid);
    }

    public ObjectIdentifier(TLV tlv) throws TLVEncodingException {
        super(tlv);
    }

    public static ObjectIdentifier getInstance(TLV tlv, Tag et) throws TLVEncodingException {
        if (!tlv.getTag().equals(et)) {
            throw new TLVEncodingException("Tag must be " + String.valueOf(et));
        }
        if (tlv instanceof ObjectIdentifier) {
            return (ObjectIdentifier)tlv;
        }
        return new ObjectIdentifier(tlv);
    }

    public static ObjectIdentifier getInstance(TLV tlv) throws TLVEncodingException {
        return ObjectIdentifier.getInstance(tlv, Tag.TAG_OBJECT_IDENTIFIER);
    }

    protected void fromIntArray(int[] oid) {
        int val;
        int i;
        if (oid.length < 2 || oid[0] < 0 || oid[0] > 2 || oid[1] < 0 || oid[1] > 39) {
            throw new IllegalArgumentException("Object identifier out of range");
        }
        int size = 1;
        for (i = 2; i < oid.length; ++i) {
            val = oid[i];
            do {
                ++size;
            } while ((val >>= 7) > 0);
        }
        this.value = new byte[size];
        this.value[0] = (byte)(40 * oid[0] + oid[1]);
        int j = 1;
        for (i = 2; i < oid.length; ++i) {
            val = oid[i];
            size = -7;
            do {
                size += 7;
            } while ((val >>= 7) > 0);
            val = oid[i];
            while (size >= 0) {
                this.value[j++] = (byte)(val >> size & 0x7F | 0x80);
                size -= 7;
            }
            int n = j - 1;
            this.value[n] = (byte)(this.value[n] & 0x7F);
        }
    }

    protected void fromString(String oid) {
        try {
            StringTokenizer sp = new StringTokenizer(oid, " .");
            int[] elements = new int[sp.countTokens()];
            int i = 0;
            while (sp.hasMoreTokens()) {
                String temp = sp.nextToken();
                elements[i++] = Integer.parseInt(temp);
            }
            this.fromIntArray(elements);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Object identifier string is invalid");
        }
    }

    public int[] getObjectIdentifier() {
        return ObjectIdentifier.convertBytesToOID(this.value);
    }

    public static int[] convertBytesToOID(byte[] value) {
        int i;
        if (value.length == 0) {
            return new int[0];
        }
        int size = 2;
        for (i = 1; i < value.length; ++i) {
            if ((value[i] & 0x80) == 128) continue;
            ++size;
        }
        int[] objectIdentifier = new int[size];
        objectIdentifier[0] = value[0] / 40;
        objectIdentifier[1] = value[0] % 40;
        int j = 2;
        for (i = 1; i < value.length; ++i) {
            objectIdentifier[j] = objectIdentifier[j] << 7 | value[i] & 0x7F;
            if ((value[i] & 0x80) == 128) continue;
            ++j;
        }
        return objectIdentifier;
    }

    public static String getObjectIdentifierAsString(int[] oid) {
        StringBuffer buffer = new StringBuffer(80);
        buffer.append(oid[0]);
        for (int i = 1; i < oid.length; ++i) {
            buffer.append("." + oid[i]);
        }
        return buffer.toString();
    }

    @Override
    public String dump(int indent) {
        return this.dumpSingleLine(indent);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(80);
        if (this.name != null) {
            buffer.append(this.name);
            buffer.append(' ');
        }
        buffer.append("OBJECT IDENTIFIER = {");
        ObjectIdentifierRegistry reg = ObjectIdentifierRegistry.getInstance();
        String name = reg.getNameFor(this.value);
        if (name != null) {
            buffer.append(" " + name);
        } else {
            int[] oid = this.getObjectIdentifier();
            for (int i = 0; i < oid.length; ++i) {
                buffer.append(" " + oid[i]);
            }
        }
        buffer.append(" }");
        return buffer.toString();
    }
}

