/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.RSAPublicKeyTLV;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PublicKeyTLV
extends ConstructedTLV {
    static final Tag TAG = new Tag(73, 64, true);
    static final String NAME = "Public Key";

    protected PublicKeyTLV(ObjectIdentifier oid) {
        super(TAG);
        this.setName(NAME);
        this.add(oid);
    }

    public PublicKeyTLV(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Public Key with wrong tag " + String.valueOf(tlv.getTag()));
        }
        this.setName(NAME);
        if (this.childs.size() < 2) {
            throw new TLVEncodingException("Public Key must contain at least 2 elements");
        }
        if (!(this.childs.get(0) instanceof ObjectIdentifier)) {
            throw new TLVEncodingException("Public Key must start with Object Identifier");
        }
    }

    public static PublicKeyTLV newPublicKey(TLV tlv) throws TLVEncodingException {
        if (tlv.getChildCount() == 3) {
            return new RSAPublicKeyTLV(tlv);
        }
        return new ECPublicKeyTLV(tlv);
    }

    public static void toUnsignedByteArray(byte[] b, byte[] ub, int off, int size) {
        int len = b.length > size ? size : b.length;
        System.arraycopy(b, b.length - len, ub, off + size - len, len);
    }

    public static void toUnsignedByteArray(BigInteger bi, byte[] ub, int off, int size) {
        PublicKeyTLV.toUnsignedByteArray(bi.toByteArray(), ub, off, size);
    }

    public static byte[] toUnsignedByteArray(BigInteger bi, int size) {
        byte[] ub = new byte[size];
        PublicKeyTLV.toUnsignedByteArray(bi, ub, 0, size);
        return ub;
    }

    public ObjectIdentifier getObjectIdentifier() {
        return (ObjectIdentifier)this.childs.get(0);
    }

    public PublicKey getPublicKey(AlgorithmParameterSpec params) {
        return null;
    }

    public abstract byte[] getEncodedForSPKI();
}

