/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.utils;

import de.cardcontact.scdp.js.GPTracer;
import de.cardcontact.tlv.HexString;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUFormatter;
import opencard.core.util.APDUTracer;

public class GPAPDUTracer
implements APDUTracer {
    private String source;
    private GPTracer tracer;
    private String format = "";

    public GPAPDUTracer(String source, GPTracer tracer) {
        this.source = source;
        this.tracer = tracer;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void traceCommandAPDUPlain(SlotChannel sc, CommandAPDU capdu) {
        String s = "SC: ";
        s = s.concat(HexString.hexifyByteArray((byte[])capdu.getBytes(), (char)' '));
        this.tracer.trace(this.source, GPTracer.LogLevel.INFO, s);
    }

    public void traceCommandAPDU(SlotChannel sc, CommandAPDU capdu) {
        if (this.tracer.isTraceEnabled(this.source, GPTracer.LogLevel.INFO)) {
            if (this.format.length() == 0) {
                int slotId = 0;
                if (sc != null) {
                    slotId = sc.getCardTerminal().getName().hashCode() + sc.getSlotNumber() & 0xFF;
                }
                String s = HexString.hexifyByte((int)slotId);
                s = s.concat(" ");
                s = s.concat(APDUFormatter.commandAPDUToString((CommandAPDU)capdu));
                this.tracer.trace(this.source, GPTracer.LogLevel.INFO, s);
            } else {
                this.traceCommandAPDUPlain(sc, capdu);
            }
        }
    }

    public void traceResponseAPDU(SlotChannel sc, ResponseAPDU rapdu) {
        if (this.tracer.isTraceEnabled(this.source, GPTracer.LogLevel.INFO) && this.format.length() == 0) {
            String s = APDUFormatter.responseAPDUToString((ResponseAPDU)rapdu);
            this.tracer.trace(this.source, GPTracer.LogLevel.INFO, s);
        }
    }

    public void traceAnswerToReset(SlotChannel sc, CardID cardID) {
        if (this.tracer.isTraceEnabled(this.source, GPTracer.LogLevel.INFO)) {
            int slotId = 0;
            if (sc != null) {
                slotId = sc.getCardTerminal().getName().hashCode() + sc.getSlotNumber() & 0xFF;
            }
            String s = HexString.hexifyByte((int)slotId);
            s = s.concat(" ATR: " + HexString.hexifyByteArray((byte[])cardID.getATR()));
            this.tracer.trace(this.source, GPTracer.LogLevel.INFO, s);
        }
    }
}

