/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class Preferences {
    static final String prefsFilename = ".scsh3config";
    public static final String SHOW_LAUNCHER_AGAIN = "SHOW_LAUNCHER_AGAIN";
    public static final String START_WEB_CLIENT = "START_WEB_CLIENT";
    public static final String AUTO_CONNECT = "AUTO_CONNECT";
    static Preferences settings = null;
    Properties properties = new Properties();

    private Preferences() {
        try {
            File file = Preferences.getFile();
            FileInputStream fi = new FileInputStream(file);
            this.properties.load(fi);
            fi.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static File getFile() {
        return new File(System.getProperty("user.home") + "/.scsh3config");
    }

    public static Preferences getPreferences() {
        if (settings == null) {
            settings = new Preferences();
        }
        return settings;
    }

    public void save() {
        try {
            File file = Preferences.getFile();
            file.delete();
            file.createNewFile();
            FileOutputStream fo = new FileOutputStream(file);
            this.properties.store(fo, "SCSH3 configuration file");
            fo.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean hasPreference(String key) {
        return this.properties.getProperty(key) != null;
    }

    public String getStringPreference(String key, String defval) {
        String val = this.properties.getProperty(key);
        return val == null ? defval : val;
    }

    public String getStringPreference(String key) {
        return this.getStringPreference(key, "");
    }

    public void setStringPreference(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public int getIntPreference(String key, int defval) {
        String val = this.properties.getProperty(key);
        if (val == null) {
            return defval;
        }
        return Integer.parseInt(val);
    }

    public int getIntPreference(String key) {
        return this.getIntPreference(key, -1);
    }

    public void setIntPreference(String key, int value) {
        this.properties.setProperty(key, "" + value);
    }

    public boolean getBooleanPreference(String key) {
        String val = this.properties.getProperty(key);
        return val != null && val.equals("true");
    }

    public void setBooleanPreference(String key, boolean value) {
        this.properties.setProperty(key, value ? "true" : "false");
    }
}

