/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.scdp.scsh3.AbstractTreeModel;
import de.cardcontact.scdp.scsh3.TreePopupMenuListener;
import de.cardcontact.scdp.utils.MutableTreeNode;
import de.cardcontact.tlv.TreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class OutlineTreeModel
extends AbstractTreeModel
implements MouseListener,
ActionListener,
TreeExpansionListener,
TreeSelectionListener {
    private TreeNode root = null;

    public OutlineTreeModel(TreeNode root) {
        this.root = root;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public Object getChild(Object node, int index) {
        return ((TreeNode)node).getChildAt(index);
    }

    @Override
    public int getIndexOfChild(Object node, Object child) {
        return ((TreeNode)node).getIndex((TreeNode)child);
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    public TreeNode[] getPathToRoot(TreeNode node) {
        int len = 1;
        TreeNode o = node;
        while (o.getParent() != null) {
            ++len;
            o = o.getParent();
        }
        TreeNode[] path = new TreeNode[len];
        o = node;
        --len;
        while (o != null) {
            path[len] = o;
            o = o.getParent();
            --len;
        }
        return path;
    }

    public void nodeWasInserted(TreeNode child, TreeNode parent, int index) {
        int[] childIndices = new int[]{index};
        Object[] childs = new Object[]{child};
        Object[] path = this.getPathToRoot(parent);
        TreePath treepath = new TreePath(path);
        TreeModelEvent ev = new TreeModelEvent((Object)this, treepath, childIndices, childs);
        this.fireTreeNodesInserted(ev);
    }

    public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int index) {
        parent.insert((TreeNode)child, index);
        child.setParent(parent);
        this.nodeWasInserted((TreeNode)child, (TreeNode)parent, index);
    }

    public void nodeWasRemoved(TreeNode child, TreeNode parent, int index) {
        int[] childIndices = new int[]{index};
        Object[] childs = new Object[]{child};
        Object[] path = this.getPathToRoot(parent);
        TreePath treepath = new TreePath(path);
        TreeModelEvent ev = new TreeModelEvent((Object)this, treepath, childIndices, childs);
        this.fireTreeNodesRemoved(ev);
    }

    public void removeNodeFrom(TreeNode child, MutableTreeNode parent) {
        int index = parent.getIndex(child);
        if (index >= 0) {
            parent.remove(index);
            this.nodeWasRemoved(child, (TreeNode)parent, index);
        }
    }

    public void nodeChanged(TreeNode node) {
        Object[] path = this.getPathToRoot(node);
        TreePath treepath = new TreePath(path);
        TreeModelEvent ev = new TreeModelEvent((Object)this, treepath);
        this.fireTreeNodesChanged(ev);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent ev) {
        TreePath path = ev.getPath();
        Object node = path.getLastPathComponent();
        if (node instanceof TreeExpansionListener) {
            TreeExpansionListener l = (TreeExpansionListener)node;
            l.treeCollapsed(ev);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent ev) {
        TreePath path = ev.getPath();
        Object node = path.getLastPathComponent();
        if (node instanceof TreeExpansionListener) {
            TreeExpansionListener l = (TreeExpansionListener)node;
            l.treeExpanded(ev);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent ev) {
        TreePath path = ev.getPath();
        Object node = path.getLastPathComponent();
        if (node instanceof TreeSelectionListener) {
            TreeSelectionListener l = (TreeSelectionListener)node;
            l.valueChanged(ev);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkPopupEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopupEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPopupEvent(e);
    }

    public void checkPopupEvent(MouseEvent e) {
        TreeNode node;
        JTree tree;
        TreePath path;
        if (e.isPopupTrigger() && (path = (tree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && (node = (TreeNode)path.getLastPathComponent()) instanceof TreePopupMenuListener) {
            TreePopupMenuListener l = (TreePopupMenuListener)node;
            l.treePopup(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

