/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.opencard.security.GPSCP02SecureChannel;
import de.cardcontact.opencard.security.GPSCPSecureChannelCredential;
import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.globalplatform.SecurityDomainCardService;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.Card;
import de.cardcontact.scdp.gp.GPCrypto;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPErrorException;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.gp.GPSecureChannel;
import de.cardcontact.scdp.gp.GPSecurityDomain;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import opencard.core.service.CardServiceException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.applet.AppletID;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.CredentialStore;
import opencard.opt.security.SecurityDomain;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPScp02
extends GPSecureChannel {
    private static final long serialVersionUID = 6299742073894014119L;
    private static final String clazzName = "GPScp02";
    private static final byte[] EIGHT_BYTES_PADDING_BLOCK = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0};
    private GPSecurityDomain securityDomain = null;
    private byte securityLevel = 0;
    private byte keySetVersion = 0;
    private byte[] hostChallenge;
    private byte[] keyDiversificationData;
    private byte[] keyInformation;
    private byte[] sequenceCounter;
    private byte[] cardChallenge;
    private byte[] cardCryptogram;
    private GPKey encKey = null;
    private GPKey macKey = null;
    private GPKey dekKey = null;

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"GPScp02() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        GPScp02 c = new GPScp02();
        ScriptableObject.putProperty((Scriptable)c, (String)"crypto", (Object)args[0]);
        return c;
    }

    public static ByteString jsFunction_initializeUpdate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        byte keyVersion = (byte)ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        byte keyIndex = (byte)ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        GPCrypto crypto = (GPCrypto)((Object)ScriptableObject.getProperty((Scriptable)thisObj, (String)"crypto"));
        GPScp02 scp02 = (GPScp02)thisObj;
        ResponseAPDU response = null;
        try {
            byte[] data;
            scp02.hostChallenge = crypto.getImpl().generateRandom(8);
            scp02.securityDomain.getSecurityDomainCardService();
            response = scp02.securityDomain.sdcs.initializeUpdate(keyVersion, keyIndex, scp02.hostChallenge);
            if (response.sw() != 36864) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 4, 0, "INITIALIZE UPDATE failed with SW = " + HexString.hexify((int)response.sw()));
            }
            if ((data = response.data()).length != 28) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 4, 0, "INITIALIZE UPDATE failed - wrong length of response data (" + data.length + ")");
            }
            scp02.keyDiversificationData = new byte[10];
            System.arraycopy(data, 0, scp02.keyDiversificationData, 0, scp02.keyDiversificationData.length);
            scp02.keyInformation = new byte[2];
            System.arraycopy(data, 10, scp02.keyInformation, 0, scp02.keyInformation.length);
            scp02.sequenceCounter = new byte[2];
            System.arraycopy(data, 12, scp02.sequenceCounter, 0, scp02.sequenceCounter.length);
            scp02.cardChallenge = new byte[6];
            System.arraycopy(data, 14, scp02.cardChallenge, 0, scp02.cardChallenge.length);
            scp02.cardCryptogram = new byte[8];
            System.arraycopy(data, 20, scp02.cardCryptogram, 0, scp02.cardCryptogram.length);
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "INITIALIZE UPDATE failed with: " + String.valueOf((Object)e));
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        catch (InvalidCardChannelException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "INITIALIZE UPDATE failed with: " + String.valueOf((Object)e));
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "INITIALIZE UPDATE failed with: " + String.valueOf((Object)e));
        }
        ScriptableObject.putConstProperty((Scriptable)scp02, (String)"hostChallenge", (Object)((Object)ByteString.newInstance((Scriptable)scp02, scp02.hostChallenge)));
        ScriptableObject.putConstProperty((Scriptable)scp02, (String)"keyVersion", (Object)keyVersion);
        ScriptableObject.putConstProperty((Scriptable)scp02, (String)"cardChallenge", (Object)((Object)ByteString.newInstance((Scriptable)scp02, scp02.cardChallenge)));
        ScriptableObject.putConstProperty((Scriptable)scp02, (String)"cardCryptogram", (Object)((Object)ByteString.newInstance((Scriptable)scp02, scp02.cardCryptogram)));
        ScriptableObject.putConstProperty((Scriptable)scp02, (String)"diversificationData", (Object)((Object)ByteString.newInstance((Scriptable)scp02, scp02.keyDiversificationData)));
        ScriptableObject.putConstProperty((Scriptable)scp02, (String)"sequenceCounter", (Object)((Object)ByteString.newInstance((Scriptable)scp02, scp02.sequenceCounter)));
        return ByteString.newInstance((Scriptable)scp02, response.data());
    }

    public static void jsFunction_externalAuthenticate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte level = (byte)ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        GPScp02 scp02 = (GPScp02)thisObj;
        GPCrypto crypto = (GPCrypto)((Object)ScriptableObject.getProperty((Scriptable)thisObj, (String)"crypto"));
        ResponseAPDU response = null;
        try {
            ByteArrayOutputStream cardCryptogramInput = new ByteArrayOutputStream();
            cardCryptogramInput.write(scp02.hostChallenge);
            cardCryptogramInput.write(scp02.sequenceCounter);
            cardCryptogramInput.write(scp02.cardChallenge);
            cardCryptogramInput.write(EIGHT_BYTES_PADDING_BLOCK);
            if (!crypto.getImpl().verify(scp02.encKey, 8, cardCryptogramInput.toByteArray(), scp02.cardCryptogram, null)) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Card cryptogram verification failed");
            }
            ByteArrayOutputStream hostCryptogramInput = new ByteArrayOutputStream();
            hostCryptogramInput.write(scp02.sequenceCounter);
            hostCryptogramInput.write(scp02.cardChallenge);
            hostCryptogramInput.write(scp02.hostChallenge);
            hostCryptogramInput.write(EIGHT_BYTES_PADDING_BLOCK);
            byte[] hostCryptogram = crypto.getImpl().sign(scp02.encKey, 8, hostCryptogramInput.toByteArray(), null);
            ByteArrayOutputStream extAutAPDUPadded = new ByteArrayOutputStream();
            extAutAPDUPadded.write(-124);
            extAutAPDUPadded.write(-126);
            extAutAPDUPadded.write(level);
            extAutAPDUPadded.write(0);
            extAutAPDUPadded.write(16);
            extAutAPDUPadded.write(hostCryptogram);
            extAutAPDUPadded.write(-128);
            extAutAPDUPadded.write(0);
            extAutAPDUPadded.write(0);
            byte[] mac = crypto.getImpl().sign(scp02.macKey, 9, extAutAPDUPadded.toByteArray(), null);
            ByteArrayOutputStream cdata = new ByteArrayOutputStream();
            cdata.write(hostCryptogram);
            cdata.write(mac);
            scp02.securityDomain.getSecurityDomainCardService();
            response = scp02.securityDomain.sdcs.externalAuthenticate(level, cdata.toByteArray());
            if (response.sw() != 36864) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 4, 0, "EXTERNAL AUTHENTICATE failed with SW = " + HexString.hexifyShort((int)response.sw()));
            }
            if (level > 0) {
                GPSCP02SecureChannel sc = new GPSCP02SecureChannel(scp02.encKey.getJCEKey("BC"), scp02.macKey.getJCEKey("BC"), null, mac, level, "BC");
                GPSCPSecureChannelCredential cred = new GPSCPSecureChannelCredential((int)level, (SecureChannel)sc);
                Object o = ScriptableObject.getProperty((Scriptable)scp02.securityDomain, (String)"aid");
                AppletID appletId = null;
                appletId = !(o instanceof ByteString) ? SecurityDomainCardService.ISD_AID : new AppletID(((ByteString)((Object)o)).getBytes());
                IsoCredentialStore store = new IsoCredentialStore();
                store.setSecureChannelCredential((SecurityDomain)appletId, (SecureChannelCredential)cred);
                CredentialBag bag = new CredentialBag();
                bag.addCredentialStore((CredentialStore)store);
                scp02.securityDomain.sdcs.provideCredentials((SecurityDomain)appletId, bag);
                Card card = scp02.securityDomain.getCard();
                card.setCredentialBag((SecurityDomain)appletId, bag);
            }
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "EXTERNAL AUTHENTICATE failed with: " + String.valueOf((Object)e));
        }
        catch (InvalidCardChannelException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "EXTERNAL AUTHENTICATE failed with: " + String.valueOf((Object)e));
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 3, 0, "EXTERNAL AUTHENTICATE failed with: " + String.valueOf((Object)e));
        }
        catch (GPErrorException gee) {
            GPError.throwAsGPErrorEx(thisObj, gee);
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 36, 0, "EXTERNAL AUTHENTICATE due to memory allocation problems: " + String.valueOf(e));
        }
        catch (NoSuchAlgorithmException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 36, 0, "EXTERNAL AUTHENTICATE failed with: " + String.valueOf(e));
        }
        catch (NoSuchProviderException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 36, 0, "EXTERNAL AUTHENTICATE failed with: " + String.valueOf(e));
        }
        catch (GeneralSecurityException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 36, 0, "EXTERNAL AUTHENTICATE failed with: " + String.valueOf(e));
        }
        scp02.setSecurityLevel(level);
    }

    public static void jsFunction_setEncKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Object o = args[0];
        if (!(o instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 8, 0, "Wrong argument type for setEncKey()");
        }
        ((GPScp02)thisObj).encKey = (GPKey)((Object)o);
    }

    public static void jsFunction_setMacKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Object o = args[0];
        if (!(o instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 8, 0, "Wrong argument type for setMacKey()");
        }
        ((GPScp02)thisObj).macKey = (GPKey)((Object)o);
    }

    public static void jsFunction_setDekKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        Object o = args[0];
        if (!(o instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 8, 0, "Wrong argument type for setMacKey()");
        }
        ((GPScp02)thisObj).dekKey = (GPKey)((Object)o);
    }

    public static GPKey jsFunction_getDekKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((GPScp02)thisObj).dekKey;
    }

    @Override
    public int jsGet_state() {
        return this.getState();
    }

    public int jsGet_securityLevel() {
        return this.securityLevel;
    }

    public void setSecurityDomain(GPSecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void setSecurityLevel(byte level) {
        this.securityLevel = level;
    }

    public void setKeySetVersion(byte version) {
        this.keySetVersion = version;
    }

    @Override
    public String getClassName() {
        return clazzName;
    }
}

