/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.scdp.js.GPTracer;
import java.util.Date;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class TaskTracer
implements GPTracer {
    private long startTime;
    private PlainDocument document;

    public TaskTracer() {
        this.mark();
    }

    public Document getDocument() {
        return this.document;
    }

    private void append(String str) {
        int ofs = this.document.getLength();
        try {
            this.document.insertString(ofs, str, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean isTraceEnabled(String source, GPTracer.LogLevel logLevel) {
        return true;
    }

    public void setTraceLevel(String clazzName, GPTracer.LogLevel logLevel) {
    }

    public boolean trace(String clazzName, GPTracer.LogLevel logLevel, Object obj) {
        Date now = new Date();
        long until = now.getTime() - this.startTime;
        String msg = until + " " + logLevel.name() + " " + obj.toString() + "\n";
        this.append(msg);
        return true;
    }

    public void mark() {
        this.document = new PlainDocument();
        Date now = new Date();
        this.startTime = now.getTime();
        this.append("Trace starts at " + String.valueOf(now) + "\n");
    }

    public String copy() {
        return this.document.toString();
    }
}

