/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.ExecuteRequest;
import de.cardcontact.scdp.engine.ScriptCompletionListener;
import de.cardcontact.scdp.engine.ScriptExecutor;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.GPTracer;
import de.cardcontact.scdp.js.JsTask;
import de.cardcontact.scdp.scsh3.GUIShell;
import de.cardcontact.scdp.scsh3.TaskTracer;
import de.cardcontact.scdp.utils.ArgChecker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Task
extends JsTask
implements ActionListener,
ScriptCompletionListener {
    private ScriptExecutor eventex;
    private TaskTracer tracer;

    public Task() {
    }

    public Task(Scriptable scope, Scriptable userObject) {
        super(scope, userObject);
        this.tracer = new TaskTracer();
        this.eventex = new ScriptExecutor();
        this.eventex.start();
        this.defineProperty("icon", "deselected", 0);
        GUIShell.instance.addTask(this);
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (!inNewExpr) {
            Context.reportError((String)"Task() can not be called as function");
        }
        if (args.length < 1) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, (String)"Task", (int)2, (int)args.length, (String)"Too few arguments");
        }
        if (!(args[0] instanceof Scriptable)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, (String)"Task", (int)16, (int)args.length, (String)"Argument must be object");
        }
        return new Task((Scriptable)ctorObj, (Scriptable)args[0]);
    }

    public static void jsFunction_dispose(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)"Task", (Object[])args, (int)0, (int)0);
        Task task = (Task)thisObj;
        task.dispose();
    }

    public String jsGet_status() {
        return this.status;
    }

    public void dispose() {
        super.dispose();
        this.eventex.shutdown();
        GUIShell.instance.removeTask(this);
    }

    public static void jsFunction_start(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsTask.jsFunction_start((Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
    }

    public void start() {
        ExecuteRequest ex = this.newExecuteRequest();
        ex.setTracer((GPTracer)this.tracer);
        this.setIcon("running");
        this.status = "running";
        this.taskex.addRequest(ex);
    }

    public void scriptCompleted(Object result) {
        if (result instanceof RhinoException) {
            Engine.printRhinoExceptionMessage((RhinoException)((RhinoException)((Object)result)), (PrintStream)System.err);
            this.setIcon("failed");
            this.status = "failed";
        } else {
            this.setIcon("passed");
            this.status = "passed";
        }
        if (this.get("disposeAtExit") != null) {
            this.dispose();
        }
    }

    public static void jsFunction_stop(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsTask.jsFunction_stop((Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
    }

    public void stop() {
        super.stop();
        this.eventex.abort();
        this.setIcon("deselected");
    }

    public static void jsFunction_setMessage(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsTask.jsFunction_setMessage((Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
        final Task task = (Task)thisObj;
        final DefaultListModel model = (DefaultListModel)GUIShell.instance.getTasks().getModel();
        final int index = model.indexOf(task);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                model.set(index, task);
            }
        });
    }

    public static void jsFunction_setIcon(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)"Task", (Object[])args, (int)0, (int)1);
        Task task = (Task)thisObj;
        String iconName = ArgChecker.getString((Scriptable)thisObj, (String)"Task", (Object[])args, (int)0, null);
        task.setIcon(iconName);
    }

    public void setIcon(String iconName) {
        this.defineProperty("icon", iconName, 0);
        final DefaultListModel model = (DefaultListModel)GUIShell.instance.getTasks().getModel();
        final int index = model.indexOf(this);
        if (index >= 0) {
            final Task task = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    model.set(index, task);
                }
            });
        }
    }

    public String getIcon() {
        Object o = this.get("icon", (Scriptable)this);
        if (o instanceof CharSequence) {
            return ((CharSequence)o).toString();
        }
        return null;
    }

    public static void jsFunction_setContextMenu(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)"Task", (Object[])args, (int)1, (int)1);
        Task task = (Task)thisObj;
        if (args[0] instanceof NativeArray) {
            task.defineProperty("contextMenu", args[0], 0);
        } else {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (int)16, (int)0, (String)"Argument must be of type string array");
        }
    }

    public void popup(MouseEvent e) {
        Object o = this.get("contextMenu", (Scriptable)this);
        if (o instanceof NativeArray) {
            NativeArray menuList = (NativeArray)o;
            if (menuList.getLength() == 0L) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            int i = 0;
            while ((long)i < menuList.getLength()) {
                String str;
                o = menuList.get(i, (Scriptable)menuList);
                if (!(o instanceof CharSequence)) {
                    GPError.throwAsGPErrorEx((Scriptable)this, (int)16, (int)i, (String)"Entry in context menu must be String");
                }
                if ((str = ((CharSequence)o).toString()).equals("---")) {
                    popup.addSeparator();
                } else {
                    JMenuItem mi = new JMenuItem(str);
                    mi.addActionListener(this);
                    popup.add(mi);
                }
                ++i;
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = ScriptableObject.getProperty((Scriptable)this, (String)"userObject");
        Object funObj = Task.getProperty((Scriptable)((Scriptable)obj), (String)"actionListener");
        if (!(funObj instanceof Function)) {
            GPError.throwAsGPErrorEx((Scriptable)this, (int)16, (int)0, (String)"User object must contain a method actionListener in order to receive events from the context menu");
        }
        Object[] args = new Object[]{this, e.getActionCommand()};
        ExecuteRequest ex = new ExecuteRequest(this.scope, (Function)funObj, (Scriptable)obj, args, null);
        ex.setTracer((GPTracer)this.tracer);
        this.eventex.addRequest(ex);
    }

    public static void jsFunction_setToolTip(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)"Task", (Object[])args, (int)0, (int)1);
        Task task = (Task)thisObj;
        String toolTipText = ArgChecker.getString((Scriptable)thisObj, (String)"Task", (Object[])args, (int)0, null);
        task.defineProperty("tooltip", toolTipText, 0);
    }

    public static void jsFunction_post(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsTask.jsFunction_post((Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
    }

    public static Object jsFunction_poll(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return JsTask.jsFunction_poll((Context)cx, (Scriptable)thisObj, (Object[])args, (Function)funObj);
    }

    public Document getTraceDocument() {
        return this.tracer.getDocument();
    }

    public static Scriptable jsStaticFunction_getTaskList(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)"Task", (Object[])args, (int)0, (int)0);
        JList<Task> tasklist = GUIShell.instance.getTasks();
        DefaultListModel model = (DefaultListModel)tasklist.getModel();
        Object[] tasks = new Object[model.size()];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = model.elementAt(i);
        }
        return cx.newArray(thisObj, tasks);
    }

    public static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)"Task", (Object[])args, (int)0, (int)0);
        return ((Task)thisObj).toString();
    }
}

