/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.opencard.daemon.CardUpdaterDaemon;
import de.cardcontact.opencard.daemon.CardUpdaterLog;
import de.cardcontact.opencard.daemon.ReaderConfigurationView;
import de.cardcontact.opencard.daemon.URLVerifier;
import de.cardcontact.opencard.terminal.ReaderConfigurationModel;
import de.cardcontact.scdp.engine.CommandProcessor;
import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.FileResourceLocator;
import de.cardcontact.scdp.engine.FileResourceLocatorFS;
import de.cardcontact.scdp.engine.LogbackInitializer;
import de.cardcontact.scdp.engine.ScriptExecutor;
import de.cardcontact.scdp.engine.Shell;
import de.cardcontact.scdp.engine.VersionInfo;
import de.cardcontact.scdp.gp.Card;
import de.cardcontact.scdp.scsh3.JSFilter;
import de.cardcontact.scdp.scsh3.Launcher;
import de.cardcontact.scdp.scsh3.Preferences;
import de.cardcontact.scdp.scsh3.PreferencesDialog;
import de.cardcontact.scdp.scsh3.SCSHReaderConfigurationModel;
import de.cardcontact.scdp.scsh3.Task;
import de.cardcontact.scdp.scsh3.TaskCellRenderer;
import de.cardcontact.scdp.scsh3.TextPaneAppendListener;
import de.cardcontact.scdp.scsh3.TextPaneOutputStream;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import opencard.core.service.CardIDFilter;
import opencard.core.service.SmartCard;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;

public class GUIShell
extends JFrame
implements KeyListener,
ActionListener,
MouseListener,
ChangeListener,
TextPaneAppendListener {
    private static final String PRODUCT = "Smart Card Shell";
    private static final String GUIXPOS = "GUIXPOS";
    private static final String GUIYPOS = "GUIYPOS";
    private static final String GUIXSIZE = "GUIXSIZE";
    private static final String GUIYSIZE = "GUIYSIZE";
    private static final String GUISPLIT = "GUISPLIT";
    private JPanel jContentPane = null;
    private JSplitPane jSplitPane = null;
    private JScrollPane jOutlineScrollPane = null;
    private JComponent jOutlineComponent = null;
    private JScrollPane jShellScrollPane = null;
    private JScrollPane jTaskScrollPane = null;
    private JSplitPane jTaskSplitPane = null;
    private JTextArea jTaskTraceView = null;
    private JTabbedPane jTabbedPane = null;
    private JMenuBar jJMenuBar = null;
    private JTextArea jShellTextPane = null;
    private JTextArea jTraceTextPane = null;
    private JMenu fileMenu = null;
    private JMenu editMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem clearConsoleMenuItem = null;
    private JMenuItem cutMenuItem = null;
    private JMenuItem copyMenuItem = null;
    private JMenuItem pasteMenuItem = null;
    private JMenuItem runMenuItem = null;
    private JMenuItem runKeyManagerMenuItem = null;
    private JMenu Options = null;
    private JMenuItem readerConfiguration = null;
    private JMenuItem preferences = null;
    private JPopupMenu popupMenu = new JPopupMenu();
    private JList<Task> tasks = new JList(new DefaultListModel());
    private JFileChooser fileChoose = new JFileChooser();
    private PrintStream out = null;
    private PrintStream err = null;
    private PrintStream trace = null;
    private int cmdStart = 0;
    private boolean editMode;
    private boolean gotUp = true;
    private Vector<String> history = new Vector();
    private int histLine = 0;
    private InputStream in;
    private OutputStream os;
    private String startupScript = null;
    private File userDir = null;
    private Engine engine;
    private CommandProcessor commandProcessor;
    private ScriptExecutor scriptExecutor;
    private CardUpdaterDaemon webClient;
    private ReaderConfigurationView readerConfigurationView;
    private SCSHReaderConfigurationModel readerConfigurationModel;
    public static GUIShell instance = null;
    private BouncyCastleProvider bcprovider;

    public GUIShell(String[] args) {
        this.initialize(args);
    }

    private void initialize(String[] args) {
        int y;
        WindowAdapter exitListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GUIShell.this.shutdownShell();
                System.exit(0);
            }
        };
        this.addWindowListener(exitListener);
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getJJMenuBar());
        Preferences p = Preferences.getPreferences();
        int x = p.getIntPreference(GUIXPOS);
        if (x < 0) {
            x = 300;
        }
        if ((y = p.getIntPreference(GUIYPOS)) < 0) {
            y = 300;
        }
        this.setLocation(x, y);
        x = p.getIntPreference(GUIXSIZE);
        if (x < 0) {
            x = 800;
        }
        if ((y = p.getIntPreference(GUIYSIZE)) < 0) {
            y = 700;
        }
        this.setSize(x, y);
        this.setContentPane(this.getJContentPane(args));
        this.setTitle(PRODUCT);
        try {
            ImageIcon icon = GUIShell.loadImageIcon(this.getClass(), "cardcontact_24bit.gif");
            this.setIconImage(icon.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readerConfigurationModel = new SCSHReaderConfigurationModel(this);
        this.readerConfigurationView = new ReaderConfigurationView((ReaderConfigurationModel)this.readerConfigurationModel);
        Card.setDefaultCardIDFilter((CardIDFilter)this.readerConfigurationModel);
    }

    private JTextArea getShellTextPane(String[] args) {
        if (this.jShellTextPane == null) {
            this.jShellTextPane = new JTextArea(new PlainDocument());
            this.jShellTextPane.setEditable(true);
            this.jShellTextPane.addKeyListener(this);
            Font font = new Font("Monospaced", 0, 12);
            this.jShellTextPane.setFont(font);
            TextPaneOutputStream tpas = new TextPaneOutputStream(this.jShellTextPane, Color.BLACK);
            tpas.setTextPaneAppendListener(this);
            try {
                this.out = new PrintStream((OutputStream)tpas, true, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                this.out = new PrintStream(tpas, true);
            }
            this.err = this.out;
            this.jShellTextPane.setCaretPosition(this.jShellTextPane.getDocument().getLength());
            this.jShellTextPane.repaint();
            this.jShellTextPane.addMouseListener(this);
        }
        return this.jShellTextPane;
    }

    private JTextArea getJTraceTextPane(String[] args) {
        if (this.jTraceTextPane == null) {
            this.jTraceTextPane = new JTextArea(new PlainDocument());
            this.jTraceTextPane.setEditable(false);
            Font font = new Font("Monospaced", 0, 12);
            this.jTraceTextPane.setFont(font);
            this.trace = new PrintStream(new TextPaneOutputStream(this.jTraceTextPane, Color.BLACK), true);
        }
        return this.jTraceTextPane;
    }

    private JTextArea getTaskTraceView(String[] args) {
        if (this.jTaskTraceView == null) {
            this.jTaskTraceView = new JTextArea();
            this.jTaskTraceView.setEditable(false);
            Font font = new Font("Monospaced", 0, 12);
            this.jTaskTraceView.setFont(font);
        }
        return this.jTaskTraceView;
    }

    private JSplitPane getTaskSplitPane(String[] args) {
        if (this.jTaskSplitPane == null) {
            this.jTaskSplitPane = new JSplitPane(0);
            this.jTaskSplitPane.setOneTouchExpandable(true);
            this.jTaskSplitPane.setTopComponent(this.getTaskScrollPane(args));
            this.jTaskSplitPane.setBottomComponent(new JScrollPane(this.getTaskTraceView(args)));
        }
        return this.jTaskSplitPane;
    }

    private JScrollPane getTaskScrollPane(String[] args) {
        if (this.jTaskScrollPane == null) {
            this.jTaskScrollPane = new JScrollPane();
            this.tasks.setCellRenderer(new TaskCellRenderer());
            this.jTaskScrollPane.getViewport().setView(this.tasks);
            this.tasks.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Task t;
                    GUIShell.this.tasks.setSelectedIndex(GUIShell.this.tasks.locationToIndex(e.getPoint()));
                    if (SwingUtilities.isRightMouseButton(e) && (t = GUIShell.this.tasks.getSelectedValue()) != null) {
                        t.popup(e);
                    }
                    if (SwingUtilities.isLeftMouseButton(e) && (t = GUIShell.this.tasks.getSelectedValue()) != null) {
                        Document doc = t.getTraceDocument();
                        GUIShell.this.jTaskTraceView.setDocument(doc);
                        GUIShell.this.jTaskTraceView.setCaretPosition(doc.getLength());
                    }
                }
            });
        }
        return this.jTaskScrollPane;
    }

    private JMenu getOptions() {
        if (this.Options == null) {
            this.Options = new JMenu();
            this.Options.setText("Options");
            this.Options.add(this.getReaderConfiguration());
            this.Options.add(this.getPreferences());
        }
        return this.Options;
    }

    private JMenuItem getPreferences() {
        if (this.preferences == null) {
            this.preferences = new JMenuItem("Preferences...");
            this.preferences.setToolTipText("Click here to set preferences");
            this.preferences.addActionListener(this);
        }
        return this.preferences;
    }

    private JMenuItem getReaderConfiguration() {
        if (this.readerConfiguration == null) {
            this.readerConfiguration = new JMenuItem("Reader Configuration");
            this.readerConfiguration.setToolTipText("Click here to select a reader");
            this.readerConfiguration.addActionListener(this);
        }
        return this.readerConfiguration;
    }

    private JPanel getJContentPane(String[] args) {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add(this.getJSplitPane(args));
        }
        return this.jContentPane;
    }

    private JSplitPane getJSplitPane(String[] args) {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setLeftComponent(this.getOutlineScrollPane(args));
            this.jSplitPane.setRightComponent(this.getJTabbedPane(args));
        }
        return this.jSplitPane;
    }

    private JTabbedPane getJTabbedPane(String[] args) {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane(3);
            this.jShellScrollPane = new JScrollPane(this.getShellTextPane(args));
            this.jTabbedPane.addTab("Shell", this.jShellScrollPane);
            this.jTabbedPane.addTab("Trace", new JScrollPane(this.getJTraceTextPane(args)));
            this.jTabbedPane.addTab("Tasks", this.getTaskSplitPane(args));
            this.jTabbedPane.addChangeListener(this);
        }
        return this.jTabbedPane;
    }

    private JScrollPane getOutlineScrollPane(String[] args) {
        if (this.jOutlineScrollPane == null) {
            this.jOutlineScrollPane = new JScrollPane();
            Preferences p = Preferences.getPreferences();
            Dimension d = new Dimension(p.getIntPreference(GUISPLIT, 170), 0);
            this.jOutlineScrollPane.setPreferredSize(d);
            this.jOutlineScrollPane.getViewport().setBackground(Color.WHITE);
            this.jOutlineScrollPane.add(new JLabel("Outline"));
        }
        return this.jOutlineScrollPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getEditMenu());
            this.jJMenuBar.add(this.getOptions());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getRunMenuItem());
            this.fileMenu.add(this.getRunKeyManagerMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText("Edit");
            this.editMenu.add(this.getClearConsoleMenuItem());
            this.editMenu.add(this.getCutMenuItem());
            this.editMenu.add(this.getCopyMenuItem());
            this.editMenu.add(this.getPasteMenuItem());
        }
        return this.editMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIShell.this.shutdownShell();
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(this);
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getClearConsoleMenuItem() {
        if (this.clearConsoleMenuItem == null) {
            this.clearConsoleMenuItem = new JMenuItem();
            this.clearConsoleMenuItem.setText("Clear Console");
            this.clearConsoleMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, 2, true));
            this.clearConsoleMenuItem.setToolTipText("Click here to clear the console");
            this.clearConsoleMenuItem.addActionListener(this);
        }
        return this.clearConsoleMenuItem;
    }

    private JMenuItem getCutMenuItem() {
        if (this.cutMenuItem == null) {
            AbstractAction cutAction = new AbstractAction("Cut"){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    String text = GUIShell.this.jShellTextPane.getSelectedText();
                    if (text != null) {
                        GUIShell.this.jShellTextPane.cut();
                        GUIShell.this.cmdStart = GUIShell.this.jShellTextPane.getDocument().getLength() - text.length();
                    }
                }
            };
            this.cutMenuItem = new JMenuItem(cutAction);
            JMenuItem cutPopupMenu = new JMenuItem(cutAction);
            this.popupMenu.add(cutPopupMenu);
        }
        return this.cutMenuItem;
    }

    private JMenuItem getCopyMenuItem() {
        if (this.copyMenuItem == null) {
            AbstractAction copyAction = new AbstractAction("Copy"){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    GUIShell.this.jShellTextPane.copy();
                }
            };
            this.copyMenuItem = new JMenuItem(copyAction);
            JMenuItem copyPopupMenu = new JMenuItem(copyAction);
            this.popupMenu.add(copyPopupMenu);
        }
        return this.copyMenuItem;
    }

    private JMenuItem getPasteMenuItem() {
        if (this.pasteMenuItem == null) {
            AbstractAction pasteAction = new AbstractAction("Paste"){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    if (!GUIShell.this.editMode) {
                        GUIShell.this.editMode = true;
                        GUIShell.this.cmdStart = GUIShell.this.jShellTextPane.getDocument().getLength();
                    }
                    GUIShell.this.forceCaretMoveToEnd();
                    GUIShell.this.jShellTextPane.paste();
                }
            };
            this.pasteMenuItem = new JMenuItem(pasteAction);
            JMenuItem pastePopupMenu = new JMenuItem(pasteAction);
            this.popupMenu.add(pastePopupMenu);
        }
        return this.pasteMenuItem;
    }

    private JMenuItem getRunMenuItem() {
        if (this.runMenuItem == null) {
            this.runMenuItem = new JMenuItem();
            this.runMenuItem.setText("Run Script");
            this.runMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2, true));
            this.runMenuItem.setToolTipText("Click here to select and run a script");
            this.runMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GUIShell.this.runScript();
                }
            });
        }
        return this.runMenuItem;
    }

    private JMenuItem getRunKeyManagerMenuItem() {
        if (this.runKeyManagerMenuItem == null) {
            this.runKeyManagerMenuItem = new JMenuItem();
            this.runKeyManagerMenuItem.setText("Key Manager");
            this.runKeyManagerMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2, true));
            this.runKeyManagerMenuItem.setToolTipText("Click here to start the KeyManager");
            this.runKeyManagerMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GUIShell.this.runKeyManager();
                }
            });
        }
        return this.runKeyManagerMenuItem;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.type(e);
        this.gotUp = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.type(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.gotUp = true;
        this.type(e);
    }

    @Override
    public void textAppended() {
        this.editMode = false;
    }

    private synchronized void type(KeyEvent e) {
        if (e.getID() == 401 && !this.editMode) {
            this.cmdStart = this.jShellTextPane.getDocument().getLength();
            this.editMode = true;
        }
        switch (e.getKeyCode()) {
            case 10: {
                if (e.getID() == 401 && this.gotUp) {
                    this.commandEntered();
                }
                e.consume();
                this.editMode = false;
                break;
            }
            case 38: {
                if (e.getID() == 401) {
                    this.historyUp();
                }
                e.consume();
                break;
            }
            case 40: {
                if (e.getID() == 401) {
                    this.historyDown();
                }
                e.consume();
                break;
            }
            case 8: 
            case 37: 
            case 127: {
                if (this.jShellTextPane.getCaretPosition() > this.cmdStart) break;
                this.jShellTextPane.setCaretPosition(this.cmdStart);
                e.consume();
                break;
            }
            case 39: {
                break;
            }
            case 36: {
                this.jShellTextPane.setCaretPosition(this.cmdStart);
                e.consume();
                break;
            }
            case 85: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 145: 
            case 154: 
            case 155: 
            case 157: {
                break;
            }
            default: {
                if (e.paramString().indexOf("Backspace") == -1 && e.paramString().indexOf("R\ufffdcktaste") == -1 || this.jShellTextPane.getCaretPosition() > this.cmdStart) break;
                e.consume();
            }
        }
    }

    private void commandEntered() {
        this.editMode = false;
        Object s = this.getCommand();
        this.out.println();
        if (((String)s).length() == 0) {
            s = ";\n";
        } else {
            if (this.history.contains(s)) {
                this.history.remove(s);
            }
            this.history.addElement((String)s);
            s = (String)s + "\n";
        }
        this.histLine = 0;
        try {
            this.os.write(((String)s).getBytes());
            this.os.flush();
            this.editMode = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getCommand() {
        String s = "";
        try {
            this.forceCaretMoveToEnd();
            int length = this.jShellTextPane.getDocument().getLength();
            s = this.jShellTextPane.getText(this.cmdStart, length - this.cmdStart);
        }
        catch (BadLocationException e) {
            System.out.println("Internal SCSH Console Error: " + String.valueOf(e));
        }
        return s;
    }

    private void historyUp() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.histLine < this.history.size()) {
            ++this.histLine;
            this.showHistoryLine();
        }
    }

    private void historyDown() {
        if (this.histLine == 0) {
            return;
        }
        --this.histLine;
        this.showHistoryLine();
    }

    private void showHistoryLine() {
        String showline = this.histLine == 0 ? "" : this.history.elementAt(this.history.size() - this.histLine);
        this.replaceRange(showline, this.cmdStart, this.jShellTextPane.getDocument().getLength());
        this.jShellTextPane.setCaretPosition(this.jShellTextPane.getDocument().getLength());
        this.jShellTextPane.repaint();
    }

    private void replaceRange(String s, int start, int end) {
        this.jShellTextPane.select(start, end);
        this.jShellTextPane.replaceSelection(s);
        this.jShellTextPane.repaint();
    }

    private void runScript(String scriptname) {
        String cmd = "load(\"" + scriptname + "\");";
        if (!this.history.contains(cmd)) {
            this.history.add(cmd);
        }
        cmd = cmd + "\n";
        try {
            this.out.print(cmd);
            this.os.write(cmd.getBytes());
            this.os.flush();
            this.editMode = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void runScript() {
        this.fileChoose.setFileSelectionMode(0);
        this.fileChoose.setFileFilter(new JSFilter());
        this.fileChoose.setCurrentDirectory(this.userDir);
        int returnVal = this.fileChoose.showOpenDialog(this);
        if (returnVal == 0) {
            String path = this.fileChoose.getSelectedFile().getAbsolutePath();
            path = path.replace('\\', '/');
            this.runScript(path);
            this.validate();
            this.repaint();
        }
    }

    private void runKeyManager() {
        this.runScript("keymanager/keymanager.js");
        this.validate();
        this.repaint();
    }

    public static String getVersion() {
        Package p = GUIShell.class.getPackage();
        if (p.getSpecificationVersion() == null || p.getImplementationVersion() == null) {
            return "(snapshot)";
        }
        return p.getSpecificationVersion() + "." + p.getImplementationVersion();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.readerConfiguration)) {
            this.readerConfigurationView.showView();
        } else if (e.getSource().equals(this.preferences)) {
            PreferencesDialog p = new PreferencesDialog(this, true);
            p.setVisible(true);
            p.dispose();
        } else if (e.getSource().equals(this.clearConsoleMenuItem)) {
            this.jShellTextPane.setText(">");
            this.cmdStart = this.jShellTextPane.getCaretPosition();
            this.jTraceTextPane.setText("");
        } else if (e.getSource().equals(this.aboutMenuItem)) {
            ImageIcon icon;
            try {
                icon = GUIShell.loadImageIcon(this.getClass(), "CardContact_Logo.jpg");
            }
            catch (Exception ex) {
                icon = null;
            }
            String msg = "Smart Card Shell " + GUIShell.getVersion() + "\n(c) 2005-2021 CardContact Systems GmbH, Minden, Germany (www.cardcontact.de)\nScripting Engine " + VersionInfo.getVersion() + "\n" + SmartCard.getVersion() + "\n" + this.bcprovider.getInfo() + "\nObtain the latest update from www.openscdp.org/scsh3/index.html";
            Object opbg = UIManager.get("OptionPane.background");
            Object pbg = UIManager.get("Panel.background");
            UIManager.put("OptionPane.background", Color.WHITE);
            UIManager.put("Panel.background", Color.WHITE);
            JOptionPane.showMessageDialog(this, msg, "About Smart Card Shell", 1, icon);
            UIManager.put("OptionPane.background", opbg);
            UIManager.put("Panel.background", pbg);
        }
    }

    public static ImageIcon loadImageIcon(Class clazz, String name) throws IOException {
        ImageIcon icon = null;
        Object path = System.getProperty("user.dir");
        FileInputStream istream = new FileInputStream((String)(path = (String)path + "/icons/" + name));
        if (istream != null) {
            int len;
            byte[] buffer = new byte[len];
            int offset = 0;
            int rlen = 0;
            for (len = ((InputStream)istream).available(); len > 0; len -= rlen) {
                rlen = ((InputStream)istream).read(buffer, offset, len);
                offset += rlen;
            }
            ((InputStream)istream).close();
            icon = new ImageIcon(buffer);
        }
        return icon;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.forceCaretMoveToEnd();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popupMenu.show((Component)event.getSource(), event.getX(), event.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popupMenu.show((Component)event.getSource(), event.getX(), event.getY());
        }
        this.jShellTextPane.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    public String getStartupScript() {
        return this.startupScript;
    }

    public void setStartupScript(String startupScript) {
        this.startupScript = startupScript;
    }

    private void forceCaretMoveToEnd() {
        int position = this.jShellTextPane.getCaretPosition();
        if (position < this.cmdStart || !this.editMode) {
            this.jShellTextPane.setCaretPosition(this.jShellTextPane.getDocument().getLength());
        }
        this.jShellTextPane.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.jTabbedPane == ce.getSource() && this.jTabbedPane.getSelectedComponent() == this.jShellScrollPane) {
            this.jShellTextPane.requestFocusInWindow();
        }
    }

    public void setOutline(JComponent tree, String name) {
        this.jOutlineComponent = tree;
        this.jOutlineScrollPane.setViewportView(this.jOutlineComponent);
    }

    public JComponent getOutline(String name) {
        return this.jOutlineComponent;
    }

    public void resetOutline() {
        this.jOutlineComponent = null;
        this.jOutlineScrollPane.setViewportView(new JLabel(""));
    }

    public JList<Task> getTasks() {
        return this.tasks;
    }

    public void addTask(final Task task) {
        final DefaultListModel model = (DefaultListModel)this.tasks.getModel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                model.addElement(task);
            }
        });
    }

    public void removeTask(final Task task) {
        final DefaultListModel model = (DefaultListModel)this.tasks.getModel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                model.removeElement(task);
            }
        });
    }

    public void resetTasks() {
        DefaultListModel model = (DefaultListModel)this.tasks.getModel();
        int i = model.getSize();
        while (i > 0) {
            Task t = (Task)model.elementAt(--i);
            t.dispose();
        }
    }

    private void showLauncher() {
        Launcher launcher = new Launcher(this, true);
        if (launcher.isShowLauncher()) {
            launcher.setVisible(true);
        }
    }

    public void terminalChanged(String selection) {
        String cmd = "_scsh3.setProperty(\"reader\",\"" + selection + "\");";
        if (!this.history.contains(cmd)) {
            this.history.add(cmd);
        }
        cmd = cmd + "\n";
        try {
            this.out.print(cmd);
            this.os.write(cmd.getBytes());
            this.os.flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private int process() {
        this.jShellTextPane.requestFocusInWindow();
        this.commandProcessor.run();
        return this.commandProcessor.getLifeCycle();
    }

    private void setupShell(String[] args) throws IOException {
        this.bcprovider = new BouncyCastleProvider();
        if (Arrays.asList(args).contains("--priobc")) {
            Security.insertProviderAt((Provider)this.bcprovider, 1);
        } else {
            Security.addProvider((Provider)this.bcprovider);
        }
        this.userDir = new File(System.getProperty("user.dir"));
        String exeDir = System.getProperty("scsh3.exepath");
        File sysDir = exeDir != null ? new File(exeDir) : this.userDir;
        String configScript = "config.js";
        if (this.startupScript != null) {
            File f = new File(this.startupScript);
            if (f.isFile()) {
                this.userDir = f.getParentFile();
                configScript = f.getName();
            } else if (f.isDirectory()) {
                this.userDir = f;
            }
        } else {
            this.userDir = sysDir;
        }
        FileResourceLocatorFS frl = new FileResourceLocatorFS(sysDir, this.userDir);
        LogbackInitializer.init((FileResourceLocator)frl);
        this.engine = new Engine();
        this.engine.setRuntimeEnvironmentType(2);
        this.engine.setFileResourceLocator((FileResourceLocator)frl);
        this.engine.setTracePrintStream(this.trace);
        try {
            this.out.println("Running setup script " + configScript + " ...\n");
            this.engine.executeSetupScript(configScript);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(this.err);
        }
        catch (RhinoException re) {
            Engine.printRhinoExceptionMessage((RhinoException)re, (PrintStream)this.err);
        }
        this.scriptExecutor = new ScriptExecutor();
        this.scriptExecutor.start();
        this.os = new PipedOutputStream();
        this.in = new PipedInputStream((PipedOutputStream)this.os);
        this.commandProcessor = new CommandProcessor();
        this.commandProcessor.setInputStream(this.in);
        this.commandProcessor.setOutputStream(this.out);
        this.commandProcessor.setScriptExecutor(this.scriptExecutor);
        System.setErr(this.err);
        System.setOut(this.out);
    }

    private void createShell() {
        try {
            Shell shell = (Shell)this.engine.newDynamicScope("Shell");
            shell.setOutputStream(System.out);
            this.engine.initializeModule((ScriptableObject)shell);
            this.commandProcessor.setShellObject(shell);
        }
        catch (RhinoException re) {
            Engine.printRhinoExceptionMessage((RhinoException)re, (PrintStream)this.err);
        }
    }

    private void shutdownShell() {
        Preferences p = Preferences.getPreferences();
        Point pnt = this.getLocation();
        p.setIntPreference(GUIXPOS, pnt.x);
        p.setIntPreference(GUIYPOS, pnt.y);
        Dimension d = this.getSize();
        p.setIntPreference(GUIXSIZE, d.width);
        p.setIntPreference(GUIYSIZE, d.height);
        d = this.jOutlineScrollPane.getSize();
        p.setIntPreference(GUISPLIT, d.width);
        p.save();
        this.scriptExecutor.shutdown();
    }

    private void launchWebClient() {
        Preferences p;
        if (this.webClient != null) {
            this.webClient.stop();
        }
        if (!(p = Preferences.getPreferences()).getBooleanPreference("START_WEB_CLIENT")) {
            return;
        }
        boolean autoconnect = p.getBooleanPreference("AUTO_CONNECT");
        CardUpdaterLog cul = new CardUpdaterLog(){

            public void log(int level, String msg) {
                GUIShell.this.trace.println(msg);
            }

            public int getVerbosityLevel() {
                return 2;
            }
        };
        try {
            this.webClient = new CardUpdaterDaemon(cul, (ReaderConfigurationModel)this.readerConfigurationModel, new URLVerifier());
            this.webClient.setAutoConnect(autoconnect);
            Thread webClientThread = new Thread((Runnable)this.webClient, "WebClient");
            webClientThread.setDaemon(true);
            webClientThread.start();
        }
        catch (Exception e) {
            e.printStackTrace(this.trace);
        }
    }

    public static void main(String[] args) {
        PrintStream savedErrStream = System.err;
        try {
            GUIShell application;
            String luf = UIManager.getSystemLookAndFeelClassName();
            if (luf.endsWith("WindowsLookAndFeel")) {
                UIManager.setLookAndFeel(luf);
            }
            instance = application = new GUIShell(args);
            application.setVisible(true);
            application.jTaskSplitPane.setDividerLocation(1.0);
            application.showLauncher();
            application.setupShell(args);
            do {
                application.launchWebClient();
                application.resetOutline();
                application.resetTasks();
                application.createShell();
            } while (application.process() == 2);
            application.dispose();
            application.shutdownShell();
        }
        catch (Exception e) {
            e.printStackTrace(savedErrStream);
        }
        System.exit(0);
    }
}

