/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.GPTLV_Generic;
import de.cardcontact.tlv.TLVDataSizeException;
import de.cardcontact.tlv.TagSizeException;

public class GPTLV_EMV
extends GPTLV_Generic {
    public GPTLV_EMV(int tag, byte[] data) throws TagSizeException, TLVDataSizeException {
        super(tag, data);
        if (this.getLengthFieldSizeHelper() == -1) {
            throw new TLVDataSizeException("Illegal data size! EMV supports only up to 4 byte length fields !");
        }
    }

    @Override
    public int getLengthFieldSizeHelper() {
        int size = 1;
        if (this.data.length >= 128) {
            ++size;
        }
        if (this.data.length >= 256) {
            ++size;
        }
        if (this.data.length >= 65536) {
            ++size;
        }
        if (this.data.length >= 0x1000000) {
            return -1;
        }
        return size;
    }

    @Override
    public byte[] encodeLength() {
        int length = this.data.length;
        int size = this.getLengthFieldSizeHelper();
        int i = 0;
        byte[] encodedLength = new byte[size];
        int offset = 0;
        if (size > 1) {
            encodedLength[offset++] = (byte)(0x80 | size - 1);
            i = (size - 2) * 8;
        }
        while (i >= 0) {
            encodedLength[offset++] = (byte)(length >> i);
            i -= 8;
        }
        return encodedLength;
    }

    @Override
    public byte[] encodeTag() {
        byte[] t = new byte[this.getTagFieldSizeHelper()];
        int akku = this.tag;
        for (int i = t.length - 1; i >= 0; --i) {
            t[i] = (byte)(akku & 0xFF);
            akku >>= 8;
        }
        return t;
    }

    @Override
    public int getTagFieldSizeHelper() {
        if (this.tag >= 0x1000000) {
            return 4;
        }
        if (this.tag >= 65536) {
            return 3;
        }
        if (this.tag >= 256) {
            return 2;
        }
        return 1;
    }
}

