/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.isocard.FileSystemSendAPDU;
import de.cardcontact.opencard.service.isocard.IsoCardSelector;
import de.cardcontact.opencard.service.isocard.IsoFileSystemCardService;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInabilityException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.FileAccessCardService;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.SecureService;
import opencard.opt.security.SecurityDomain;
import opencard.opt.service.CardServiceObjectNotAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsoCardService
extends CardService
implements FileAccessCardService,
IsoFileSystemCardService,
CHVCardServiceWithControl,
FileSystemSendAPDU,
SecureService {
    private static final CardFilePath root_path = new CardFilePath(":3F00");
    private static final Logger logger = LoggerFactory.getLogger(IsoCardService.class);
    protected int maxRDataSM = 223;
    CardFilePath credentialDomain = null;
    CredentialBag credentialBag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        logger.debug("[initialize] called");
        try {
            this.allocateCardChannel();
            IsoCardSelector cardSelector = (IsoCardSelector)this.getCardChannel().getState();
            if (cardSelector == null) {
                cardSelector = new IsoCardSelector(this.getRoot());
                this.getCardChannel().setState(cardSelector);
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public boolean exists(CardFilePath file) throws CardServiceException, CardTerminalException {
        try {
            this.getFileInfo(file);
        }
        catch (CardServiceObjectNotAvailableException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CardFileInfo getFileInfo(CardFilePath file) throws CardServiceException, CardTerminalException {
        CardFileInfo fci;
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector cardSelector = (IsoCardSelector)channel.getState();
            cardSelector.selectFile(channel, this.getSecureChannelCredential(file, 1), file, true);
            fci = cardSelector.getFCI();
        }
        finally {
            this.releaseCardChannel();
        }
        return fci;
    }

    @Override
    public CardFilePath getRoot() {
        return root_path;
    }

    protected SecureChannelCredential getSecureChannelCredential(CardFilePath file, int accessMode) {
        IsoCredentialStore ics;
        SecureChannelCredential secureChannelCredential = null;
        if (this.credentialDomain != null && (ics = (IsoCredentialStore)this.credentialBag.getCredentialStore(null, IsoCredentialStore.class)) != null) {
            secureChannelCredential = ics.getSecureChannelCredential(file, accessMode);
        }
        return secureChannelCredential;
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel channel, SecureChannelCredential secureChannelCredential, int uq, CommandAPDU com) throws InvalidCardChannelException, CardTerminalException {
        ResponseAPDU res;
        if (secureChannelCredential != null) {
            SlotChannel slc = channel.getSlotChannel();
            APDUTracer tracer = slc.getAPDUTracer();
            if (tracer != null && com.getLength() > 5) {
                tracer.traceCommandAPDU(slc, com);
            }
            SecureChannel sc = secureChannelCredential.getSecureChannel();
            com = sc.wrap(com, uq);
            res = channel.sendCommandAPDU(com);
            res = sc.unwrap(res, uq);
            if (tracer != null && res.getLength() > 2) {
                tracer.traceResponseAPDU(slc, res);
            }
        } else {
            res = channel.sendCommandAPDU(com);
        }
        return res;
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel channel, SecureChannelCredential secureChannelCredential, CommandAPDU com) throws InvalidCardChannelException, CardTerminalException {
        int uq = 0;
        if (secureChannelCredential != null) {
            uq = secureChannelCredential.getUsageQualifier();
        }
        return this.sendCommandAPDU(channel, secureChannelCredential, uq, com);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(CardFilePath file, int offset, int length) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(7);
        byte[] response = null;
        if (offset < 0 || offset > Short.MAX_VALUE || length != -1 && length < 0) {
            throw new CardServiceInvalidParameterException("read: offset = " + offset + ", length = " + length);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(file, 2);
        try {
            int len;
            int maxapdulen;
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(file, 1), file);
            if (sfi > 0 && offset > 255) {
                throw new CardServiceInvalidParameterException("read: offset = " + offset + " out of range when reading with short file identifier");
            }
            int n = maxapdulen = secureChannelCredential == null ? 256 : this.maxRDataSM;
            for (int remaining = length == -1 ? 32768 : length; remaining > 0; remaining -= len) {
                int expected;
                com.setLength(0);
                com.append((byte)0);
                com.append((byte)-80);
                if (sfi > 0) {
                    com.append((byte)(0x80 | sfi));
                } else {
                    com.append((byte)(offset >> 8));
                }
                com.append((byte)offset);
                if (length == -1) {
                    expected = maxapdulen;
                } else {
                    int n2 = expected = remaining > maxapdulen ? maxapdulen : remaining;
                }
                if (expected > 256) {
                    com.append((byte)0);
                    com.append((byte)(expected >> 8));
                    com.append((byte)(expected & 0xFF));
                } else {
                    com.append((byte)expected);
                }
                ResponseAPDU res = this.sendCommandAPDU(channel, secureChannelCredential, com);
                if (res.sw() == 26368 && expected == 256) {
                    expected = 255;
                    maxapdulen = 255;
                    com.setLength(4);
                    com.append((byte)expected);
                    res = channel.sendCommandAPDU(com);
                }
                if (res.sw1() == 108) {
                    expected = res.sw2() & 0xFF;
                    com.setLength(4);
                    com.append(res.sw2());
                    res = channel.sendCommandAPDU(com);
                }
                if ((res.sw() == 27392 || res.sw() == 27270) && length == -1) {
                    break;
                }
                if (res.sw() == 36864 || res.sw() == 25218) {
                    if (sfi > 0) {
                        ics.setImplicitlySelectedBySFI(file);
                        sfi = 0;
                    }
                    len = res.getLength() - 2;
                    if (response == null) {
                        response = new byte[len];
                        System.arraycopy(res.getBuffer(), 0, response, 0, len);
                    } else {
                        byte[] buff = new byte[response.length + len];
                        System.arraycopy(response, 0, buff, 0, response.length);
                        System.arraycopy(res.getBuffer(), 0, buff, response.length, len);
                        response = buff;
                    }
                    offset += len;
                    if (res.sw() == 25218) break;
                    if (len >= expected) continue;
                    break;
                }
                throw new CardServiceUnexpectedStatusWordException("READ_BINARY", res.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
        if (response == null) {
            response = new byte[]{};
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readRecord(CardFilePath file, int recordNumber) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(5);
        ResponseAPDU res = new ResponseAPDU(258);
        byte[] response = null;
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(file, 2);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(file, 1), file);
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)-78);
            com.append((byte)recordNumber);
            if (sfi > 0) {
                com.append((byte)((sfi << 3) + 4));
            } else {
                com.append((byte)4);
            }
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, secureChannelCredential, com);
            if (res.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("READ_RECORD", res.sw());
            }
            if (sfi > 0) {
                ics.setImplicitlySelectedBySFI(file);
                sfi = 0;
            }
            response = new byte[res.data().length];
            System.arraycopy(res.data(), 0, response, 0, res.data().length);
        }
        finally {
            this.releaseCardChannel();
        }
        return response;
    }

    @Override
    public byte[][] readRecords(CardFilePath file, int number) throws CardServiceException, CardTerminalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(CardFilePath file, int foffset, byte[] source, int soffset, int length) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(261);
        ResponseAPDU res = new ResponseAPDU(2);
        if (foffset < 0 || foffset > Short.MAX_VALUE || length < 0) {
            throw new CardServiceInvalidParameterException("write: offset = " + foffset + ", length = " + length);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(file, 4);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(file, 1), file);
            if (sfi > 0 && foffset > 255) {
                throw new CardServiceInvalidParameterException("write: offset = " + foffset + " out of range when writing with short file identifier");
            }
            while (length > 0) {
                int lc = length > 220 ? 220 : length;
                com.setLength(0);
                com.append((byte)0);
                com.append((byte)-42);
                if (sfi > 0) {
                    com.append((byte)(0x80 | sfi));
                } else {
                    com.append((byte)(foffset >> 8));
                }
                com.append((byte)foffset);
                com.append((byte)lc);
                System.arraycopy(source, soffset, com.getBuffer(), 5, lc);
                com.setLength(5 + lc);
                res = this.sendCommandAPDU(channel, secureChannelCredential, com);
                if (res.sw() != 36864) {
                    throw new CardServiceUnexpectedStatusWordException("UPDATE_BINARY", res.sw());
                }
                if (sfi > 0) {
                    ics.setImplicitlySelectedBySFI(file);
                    sfi = 0;
                }
                foffset += lc;
                soffset += lc;
                length -= lc;
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public void write(CardFilePath file, int offset, byte[] data) throws CardServiceException, CardTerminalException {
        this.write(file, offset, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecord(CardFilePath file, int recordNumber, byte[] data) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(261);
        ResponseAPDU res = new ResponseAPDU(2);
        if (recordNumber < 0 || recordNumber > 254) {
            throw new CardServiceInvalidParameterException("writeRecord: recordNumber = " + recordNumber);
        }
        if (data.length > 255) {
            throw new CardServiceInvalidParameterException("writeRecord: length of data = " + data.length);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(file, 4);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(file, 1), file);
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)-36);
            com.append((byte)(recordNumber + 1));
            if (sfi > 0) {
                com.append((byte)((sfi << 3) + 4));
            } else {
                com.append((byte)4);
            }
            com.append((byte)data.length);
            System.arraycopy(data, 0, com.getBuffer(), 5, data.length);
            com.setLength(5 + data.length);
            res = this.sendCommandAPDU(channel, secureChannelCredential, com);
            if (res.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("UPDATE_RECORD", res.sw());
            }
            if (sfi > 0) {
                ics.setImplicitlySelectedBySFI(file);
                sfi = 0;
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendRecord(CardFilePath file, byte[] data) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(261);
        ResponseAPDU res = new ResponseAPDU(2);
        if (data.length > 255) {
            throw new CardServiceInvalidParameterException("appendRecord: length of data = " + data.length);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(file, 8);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(file, 1), file);
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)-30);
            com.append((byte)0);
            if (sfi > 0) {
                com.append((byte)(sfi << 3));
            } else {
                com.append((byte)0);
            }
            com.append((byte)data.length);
            System.arraycopy(data, 0, com.getBuffer(), 5, data.length);
            com.setLength(5 + data.length);
            res = this.sendCommandAPDU(channel, secureChannelCredential, com);
            if (res.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("APPEND_RECORD", res.sw());
            }
            if (sfi > 0) {
                ics.setImplicitlySelectedBySFI(file);
                sfi = 0;
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU sendCommandAPDU(CardFilePath path, CommandAPDU com, int usageQualifier) throws CardServiceException, CardTerminalException {
        ResponseAPDU res = null;
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(path, 1);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, secureChannelCredential, path);
            if (sfi > 0) {
                throw new CardServiceInvalidParameterException("Can't send APDU to file referenced by short file identifier");
            }
            if (com != null) {
                res = this.sendCommandAPDU(channel, secureChannelCredential, usageQualifier, com);
            }
        }
        finally {
            this.releaseCardChannel();
        }
        return res;
    }

    @Override
    public void provideCredentials(SecurityDomain domain, CredentialBag creds) throws CardServiceException {
        if (!(domain instanceof CardFilePath)) {
            throw new CardServiceInvalidParameterException("domain must be of class CardFilePath");
        }
        this.credentialDomain = (CardFilePath)domain;
        this.credentialBag = creds;
    }

    @Override
    public int getPasswordLength(SecurityDomain domain, int number) throws CardServiceException, CardTerminalException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyPassword(SecurityDomain domain, int number, CHVControl cc, byte[] password) throws CardServiceException, CardTerminalException {
        boolean result;
        block9: {
            result = false;
            CommandAPDU com = new CommandAPDU(40);
            ResponseAPDU res = new ResponseAPDU(2);
            try {
                this.allocateCardChannel();
                CardChannel channel = this.getCardChannel();
                com.setLength(0);
                com.append((byte)0);
                com.append((byte)32);
                com.append((byte)0);
                com.append(domain == null ? (byte)number : (byte)(number + 128));
                if (password != null) {
                    com.append((byte)password.length);
                    System.arraycopy(password, 0, com.getBuffer(), 5, password.length);
                    com.setLength(5 + password.length);
                    res = channel.sendCommandAPDU(com);
                } else if (cc.passwordEncoding().equals("Format 2 Block")) {
                    com.append((byte)8);
                    com.append(new byte[]{32, -1, -1, -1, -1, -1, -1, -1});
                    res = channel.sendVerifiedAPDU(com, cc, this.getCHVDialog());
                } else {
                    res = channel.sendVerifiedAPDU(com, cc, this.getCHVDialog());
                }
                if (res.sw() == 36864) {
                    result = true;
                    break block9;
                }
                if ((res.sw() & 0xFFF0) == 25536) {
                    result = false;
                    break block9;
                }
                throw new CardServiceUnexpectedStatusWordException("VERIFY", res.sw());
            }
            finally {
                this.releaseCardChannel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHVCardServiceWithControl.PasswordStatus getPasswordStatus(SecurityDomain domain, int number) throws CardServiceException, CardTerminalException {
        CHVCardServiceWithControl.PasswordStatus status;
        block9: {
            CommandAPDU com = new CommandAPDU(4);
            ResponseAPDU res = new ResponseAPDU(2);
            try {
                this.allocateCardChannel();
                CardChannel channel = this.getCardChannel();
                com.append((byte)0);
                com.append((byte)32);
                com.append((byte)0);
                com.append(domain == null ? (byte)number : (byte)(number + 128));
                res = channel.sendCommandAPDU(com);
                if (res.sw() == 36864) {
                    status = CHVCardServiceWithControl.PasswordStatus.VERIFIED;
                    break block9;
                }
                if (res.sw() == 25537) {
                    status = CHVCardServiceWithControl.PasswordStatus.LASTTRY;
                    break block9;
                }
                if (res.sw() == 25538) {
                    status = CHVCardServiceWithControl.PasswordStatus.RETRYCOUNTERLOW;
                    break block9;
                }
                if ((res.sw() & 0xFFF0) == 25536) {
                    status = CHVCardServiceWithControl.PasswordStatus.NOTVERIFIED;
                    break block9;
                }
                if (res.sw() == 27011) {
                    status = CHVCardServiceWithControl.PasswordStatus.BLOCKED;
                    break block9;
                }
                if (res.sw() == 27012) {
                    status = CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED;
                    break block9;
                }
                throw new CardServiceUnexpectedStatusWordException("VERIFY", res.sw());
            }
            finally {
                this.releaseCardChannel();
            }
        }
        return status;
    }

    @Override
    public boolean verifyPassword(SecurityDomain domain, int number, byte[] password) throws CardServiceException, CardTerminalException {
        CardTerminalIOControl ioctl = new CardTerminalIOControl(8, 30, "0123456789", "");
        CHVControl cc = new CHVControl("Enter your password", number, "Format 2 Block", 0, ioctl);
        return this.verifyPassword(domain, number, cc, password);
    }

    @Override
    public void closeApplication(SecurityDomain domain) throws CardServiceException, CardTerminalException {
    }

    @Override
    public void create(CardFilePath parent, byte[] data) throws CardServiceException, CardTerminalException {
        this.create(parent, (byte)0, (byte)0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(CardFilePath parent, byte fileDescriptorByte, byte shortFileIdentifier, byte[] data) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(261);
        ResponseAPDU res = new ResponseAPDU(2);
        if (data.length > 255) {
            throw new CardServiceInvalidParameterException("create: length of data = " + data.length);
        }
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(parent, 16);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(parent, 1), parent);
            if (sfi > 0) {
                throw new CardServiceInvalidParameterException("Can't create file in parent referenced by short file identifier");
            }
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)-32);
            com.append(fileDescriptorByte);
            com.append(shortFileIdentifier);
            com.append((byte)data.length);
            System.arraycopy(data, 0, com.getBuffer(), 5, data.length);
            com.setLength(5 + data.length);
            res = this.sendCommandAPDU(channel, secureChannelCredential, com);
            if (res.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("CREATE_FILE", res.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    @Override
    public void delete(CardFilePath file) throws CardServiceException, CardTerminalException {
        this.delete(file, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(CardFilePath file, CardFilePathComponent child, boolean childIsDF) throws CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(261);
        ResponseAPDU res = new ResponseAPDU(2);
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(file, 32);
        byte[] data = null;
        if (child != null) {
            if (child instanceof CardFileAppID) {
                data = ((CardFileAppID)child).toByteArray();
            } else if (child instanceof CardFileFileID) {
                data = ((CardFileFileID)child).toByteArray();
            } else {
                throw new CardServiceInvalidParameterException("Child argument must be of type CardFileAppID or CardFileFileID");
            }
        }
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(file, 1), file);
            if (sfi > 0) {
                throw new CardServiceInvalidParameterException("Can't delete file referenced by short file identifier");
            }
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)-28);
            if (child != null) {
                com.append(childIsDF ? (byte)1 : 2);
            } else {
                com.append((byte)0);
            }
            com.append((byte)0);
            if (child != null) {
                com.append((byte)data.length);
                com.append(data);
            }
            if ((res = this.sendCommandAPDU(channel, secureChannelCredential, com)).sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("DELETE_FILE", res.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(CardFilePath file) throws CardServiceInabilityException, CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(261);
        ResponseAPDU res = new ResponseAPDU(2);
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(file, 128);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(file, 1), file, true);
            if (sfi > 0) {
                throw new CardServiceInvalidParameterException("Can't deactivate file referenced by short file identifier");
            }
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)4);
            com.append((byte)0);
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, secureChannelCredential, com);
            if (res.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("DEACTIVATE_FILE", res.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rehabilitate(CardFilePath file) throws CardServiceInabilityException, CardServiceException, CardTerminalException {
        CommandAPDU com = new CommandAPDU(261);
        ResponseAPDU res = new ResponseAPDU(2);
        SecureChannelCredential secureChannelCredential = this.getSecureChannelCredential(file, 64);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            IsoCardSelector ics = (IsoCardSelector)channel.getState();
            int sfi = ics.selectFile(channel, this.getSecureChannelCredential(file, 1), file, true);
            if (sfi > 0) {
                throw new CardServiceInvalidParameterException("Can't activate file referenced by short file identifier");
            }
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)68);
            com.append((byte)0);
            com.append((byte)0);
            res = this.sendCommandAPDU(channel, secureChannelCredential, com);
            if (res.sw() != 36864) {
                throw new CardServiceUnexpectedStatusWordException("ACTIVATE_FILE", res.sw());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }
}

