/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.chv;

import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.isocard.CHVDialogWithStatus;
import de.cardcontact.opencard.service.isocard.apdu.SelectApplication;
import de.cardcontact.opencard.service.isocard.apdu.VerifyCommandAPDU;
import de.cardcontact.opencard.service.smartcardhsm.CHVManager;
import opencard.core.service.CHVDialog;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.applet.AppletID;
import opencard.opt.security.SecurityDomain;

public class AppletCHVCardService
extends CardService
implements CHVCardServiceWithControl {
    @Override
    public int getPasswordLength(SecurityDomain domain, int number) throws CardServiceException, CardTerminalException {
        return 0;
    }

    public CHVDialog createCHVDialog() {
        CHVDialog dialog = null;
        try {
            Class<?> clazz = Class.forName("de.cardcontact.opencard.ui.smartcardhsm.SmartCardHSMCHVDialog");
            dialog = (CHVDialog)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.setCHVDialog(dialog);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyPassword(SecurityDomain domain, int number, byte[] password) throws CardServiceException, CardTerminalException {
        if (password == null) {
            String pin;
            CHVDialog dialog = this.getCHVDialog();
            if (dialog == null) {
                dialog = this.createCHVDialog();
            }
            if (dialog == null) {
                throw new CardServiceException("Password can not be null if no AuthenticationManager is available");
            }
            if (dialog instanceof CHVManager) {
                return ((CHVManager)dialog).verifyPassword();
            }
            if (dialog instanceof CHVDialogWithStatus) {
                ((CHVDialogWithStatus)dialog).setPasswordStatus(this.getPasswordStatus(domain, number));
            }
            if ((pin = dialog.getCHV(-1)) == null) {
                return false;
            }
            password = pin.getBytes();
        }
        boolean result = false;
        CommandAPDU com = new CommandAPDU(40);
        ResponseAPDU res = new ResponseAPDU(2);
        com.setLength(0);
        com.append((byte)0);
        com.append((byte)32);
        com.append((byte)0);
        com.append((byte)-127);
        com.append((byte)password.length);
        System.arraycopy(password, 0, com.getBuffer(), 5, password.length);
        com.setLength(5 + password.length);
        try {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            res = channel.sendCommandAPDU(com);
        }
        finally {
            this.releaseCardChannel();
            com.clear();
        }
        if (res.sw() == 36864) {
            result = true;
        } else if ((res.sw() & 0xFFF0) == 25536 || res.sw() == 27011) {
            result = false;
        } else {
            throw new CardServiceUnexpectedStatusWordException("VERIFY", res.sw());
        }
        return result;
    }

    @Override
    public void closeApplication(SecurityDomain domain) throws CardServiceException, CardTerminalException {
    }

    @Override
    public boolean verifyPassword(SecurityDomain domain, int number, CHVControl cc, byte[] password) throws CardServiceException, CardTerminalException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHVCardServiceWithControl.PasswordStatus getPasswordStatus(SecurityDomain domain, int number) throws CardServiceException, CardTerminalException {
        CHVCardServiceWithControl.PasswordStatus status;
        block13: {
            status = null;
            number |= 0x80;
            try {
                SelectApplication apdu;
                ResponseAPDU res;
                this.allocateCardChannel();
                CardChannel channel = this.getCardChannel();
                boolean aidselected = false;
                do {
                    VerifyCommandAPDU com;
                    if ((res = channel.sendCommandAPDU(com = new VerifyCommandAPDU((byte)number, null))).sw() == 36864) {
                        status = CHVCardServiceWithControl.PasswordStatus.VERIFIED;
                        break block13;
                    }
                    if (res.sw() == 25537) {
                        status = CHVCardServiceWithControl.PasswordStatus.LASTTRY;
                        break block13;
                    }
                    if (res.sw() == 25538) {
                        status = CHVCardServiceWithControl.PasswordStatus.RETRYCOUNTERLOW;
                        break block13;
                    }
                    if ((res.sw() & 0xFFF0) == 25536) {
                        status = CHVCardServiceWithControl.PasswordStatus.NOTVERIFIED;
                        break block13;
                    }
                    if (res.sw() == 25344) {
                        status = CHVCardServiceWithControl.PasswordStatus.NOTVERIFIED;
                        break block13;
                    }
                    if (res.sw() == 27011) {
                        status = CHVCardServiceWithControl.PasswordStatus.BLOCKED;
                        break block13;
                    }
                    if (res.sw() == 27012) {
                        status = CHVCardServiceWithControl.PasswordStatus.TRANSPORTMODE;
                        break block13;
                    }
                    if (res.sw() == 27272 || res.sw() == 27270) {
                        status = CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED;
                        break block13;
                    }
                    if (aidselected) {
                        throw new CardServiceUnexpectedStatusWordException("VERIFY", res.sw());
                    }
                    aidselected = true;
                } while ((res = channel.sendCommandAPDU(apdu = new SelectApplication((AppletID)domain))).sw() == 36864);
                throw new CardServiceUnexpectedStatusWordException("SELECT(AID) failed", res.sw());
            }
            finally {
                this.releaseCardChannel();
            }
        }
        return status;
    }
}

