/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.DestroyFailedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensc.pkcs11.PKCS11Provider;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Mechanism;
import org.opensc.util.DestroyableHolder;
import org.opensc.util.Util;

public class PKCS11Slot
extends DestroyableHolder {
    private static final Log log = LogFactory.getLog(PKCS11Slot.class);
    private long id;
    private long pvh;
    private long handle;

    private native long initSlotNative(long var1, long var3) throws PKCS11Exception;

    private native void destroySlotNative(long var1, long var3) throws DestroyFailedException;

    public PKCS11Slot(PKCS11Provider pKCS11Provider, long l) throws PKCS11Exception {
        super(pKCS11Provider);
        this.id = l;
        this.pvh = pKCS11Provider.getPkcs11ModuleHandle();
        this.handle = this.initSlotNative(this.pvh, l);
    }

    private native void initTokenNative(long var1, long var3, byte[] var5, byte[] var6) throws PKCS11Exception;

    public void initToken(char[] cArray, String string) throws PKCS11Exception {
        this.initTokenNative(this.pvh, this.handle, Util.translatePin(cArray), Util.translatePin(string.toCharArray()));
    }

    private static native long[] enumerateSlotsNative(long var0) throws PKCS11Exception;

    public static List<PKCS11Slot> enumerateSlots(PKCS11Provider pKCS11Provider) throws PKCS11Exception {
        long[] lArray = PKCS11Slot.enumerateSlotsNative(pKCS11Provider.getPkcs11ModuleHandle());
        ArrayList<PKCS11Slot> arrayList = new ArrayList<PKCS11Slot>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            arrayList.add(new PKCS11Slot(pKCS11Provider, lArray[i]));
        }
        return arrayList;
    }

    private static native long waitForSlotNative(long var0) throws PKCS11Exception;

    public static PKCS11Slot waitForSlot(PKCS11Provider pKCS11Provider) throws PKCS11Exception {
        long l = -1L;
        try {
            l = PKCS11Slot.waitForSlotNative(pKCS11Provider.getPkcs11ModuleHandle());
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 84) {
                try {
                    PKCS11Slot pKCS11Slot = null;
                    do {
                        Thread.sleep(1000L);
                        List<PKCS11Slot> list = PKCS11Slot.enumerateSlots(pKCS11Provider);
                        for (PKCS11Slot pKCS11Slot2 : list) {
                            if (pKCS11Slot == null && pKCS11Slot2.isTokenPresent()) {
                                pKCS11Slot = pKCS11Slot2;
                                continue;
                            }
                            try {
                                pKCS11Slot2.destroy();
                            }
                            catch (DestroyFailedException destroyFailedException) {
                                log.warn((Object)"destroy error while waiting for slot:", (Throwable)destroyFailedException);
                            }
                        }
                    } while (pKCS11Slot == null);
                    return pKCS11Slot;
                }
                catch (InterruptedException interruptedException) {
                    throw new PKCS11Exception(80, "The operation has been interrupted.");
                }
            }
            throw pKCS11Exception;
        }
        return new PKCS11Slot(pKCS11Provider, l);
    }

    private native boolean isTokenPresentNative(long var1, long var3) throws PKCS11Exception;

    public boolean isTokenPresent() throws PKCS11Exception {
        return this.isTokenPresentNative(this.pvh, this.handle);
    }

    private native boolean isRemovableDeviceNative(long var1, long var3) throws PKCS11Exception;

    public boolean isRemovableDevice() throws PKCS11Exception {
        return this.isRemovableDeviceNative(this.pvh, this.handle);
    }

    private native boolean isHardwareDeviceNative(long var1, long var3) throws PKCS11Exception;

    public boolean isHardwareDevice() throws PKCS11Exception {
        return this.isHardwareDeviceNative(this.pvh, this.handle);
    }

    private native byte[] getManufacturerNative(long var1, long var3) throws PKCS11Exception;

    public String getManufacturer() throws PKCS11Exception {
        try {
            return new String(this.getManufacturerNative(this.pvh, this.handle), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private native byte[] getDescriptionNative(long var1, long var3) throws PKCS11Exception;

    public String getDescription() throws PKCS11Exception {
        try {
            return new String(this.getDescriptionNative(this.pvh, this.handle), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private native double getHardwareVersionNative(long var1, long var3) throws PKCS11Exception;

    public double getHardwareVersion() throws PKCS11Exception {
        return this.getHardwareVersionNative(this.pvh, this.handle);
    }

    private native double getFirmwareVersionNative(long var1, long var3) throws PKCS11Exception;

    public double getFirmwareVersion() throws PKCS11Exception {
        return this.getFirmwareVersionNative(this.pvh, this.handle);
    }

    private native PKCS11Mechanism[] getMechanismsNative(long var1, long var3) throws PKCS11Exception;

    public PKCS11Mechanism[] getMechanisms() throws PKCS11Exception {
        return this.getMechanismsNative(this.pvh, this.handle);
    }

    private native byte[] getTokenLabelNative(long var1, long var3) throws PKCS11Exception;

    public String getTokenLabel() throws PKCS11Exception {
        try {
            return new String(this.getTokenLabelNative(this.pvh, this.handle), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private native byte[] getTokenManufacturerNative(long var1, long var3) throws PKCS11Exception;

    public String getTokenManufacturer() throws PKCS11Exception {
        try {
            return new String(this.getTokenManufacturerNative(this.pvh, this.handle), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private native byte[] getTokenModelNative(long var1, long var3) throws PKCS11Exception;

    public String getTokenModel() throws PKCS11Exception {
        try {
            return new String(this.getTokenModelNative(this.pvh, this.handle), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private native byte[] getTokenSerialNumberNative(long var1, long var3) throws PKCS11Exception;

    public String getTokenSerialNumber() throws PKCS11Exception {
        try {
            return new String(this.getTokenSerialNumberNative(this.pvh, this.handle), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private native int getTokenMinPinLenNative(long var1, long var3) throws PKCS11Exception;

    public int getTokenMinPinLen() throws PKCS11Exception {
        return this.getTokenMinPinLenNative(this.pvh, this.handle);
    }

    private native int getTokenMaxPinLenNative(long var1, long var3) throws PKCS11Exception;

    public int getTokenMaxPinLen() throws PKCS11Exception {
        return this.getTokenMaxPinLenNative(this.pvh, this.handle);
    }

    private native boolean hasTokenProtectedAuthPathNative(long var1, long var3) throws PKCS11Exception;

    public boolean hasTokenProtectedAuthPath() throws PKCS11Exception {
        return this.hasTokenProtectedAuthPathNative(this.pvh, this.handle);
    }

    public long getId() {
        return this.id;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        super.destroy();
        if (this.handle != 0L) {
            this.destroySlotNative(this.pvh, this.handle);
            this.handle = 0L;
        }
    }

    protected long getPvh() {
        return this.pvh;
    }

    protected long getHandle() {
        return this.handle;
    }
}

