/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.opensc.pkcs11.spec.PKCS11RSAKeyPairGenParameterSpec;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11KeyPairGenerator;
import org.opensc.pkcs11.wrap.PKCS11NeRSAPrivateKey;
import org.opensc.pkcs11.wrap.PKCS11RSAPrivateKey;
import org.opensc.pkcs11.wrap.PKCS11RSAPublicKey;
import org.opensc.pkcs11.wrap.PKCS11Session;

public class PKCS11RSAKeyPairGenerator
extends PKCS11KeyPairGenerator {
    private static final int N_EXTRA_PRIVATE_ATTRIBUTES = 0;
    private static final int N_EXTRA_PUBLIC_ATTRIBUTES = 2;
    private PKCS11RSAKeyPairGenParameterSpec params;

    public PKCS11RSAKeyPairGenerator(PKCS11RSAKeyPairGenParameterSpec pKCS11RSAKeyPairGenParameterSpec) {
        super(0);
        super.initStaticPublicAttrs(pKCS11RSAKeyPairGenParameterSpec, 2);
        this.pubKeyAttributes[4] = new PKCS11Attribute(289, pKCS11RSAKeyPairGenParameterSpec.getKeysize());
        this.pubKeyAttributes[5] = new PKCS11Attribute(290, pKCS11RSAKeyPairGenParameterSpec.getPublicExponent().toByteArray());
        super.initStaticPrivateAttrs(pKCS11RSAKeyPairGenParameterSpec, 0);
        this.params = pKCS11RSAKeyPairGenParameterSpec;
    }

    @Override
    protected PrivateKey makePrivateKey(PKCS11Session pKCS11Session, long l) throws PKCS11Exception {
        if (this.params.isExtractable() && !this.params.isSensitive()) {
            return new PKCS11RSAPrivateKey(pKCS11Session, l);
        }
        return new PKCS11NeRSAPrivateKey(pKCS11Session, l);
    }

    @Override
    protected PublicKey makePublicKey(PKCS11Session pKCS11Session, long l) throws PKCS11Exception {
        return new PKCS11RSAPublicKey(pKCS11Session, l);
    }
}

