/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.opensc.pkcs11.wrap.PKCS11DSAPublicKey;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Key;
import org.opensc.pkcs11.wrap.PKCS11Object;
import org.opensc.pkcs11.wrap.PKCS11PrivateKey;
import org.opensc.pkcs11.wrap.PKCS11RSAPublicKey;
import org.opensc.pkcs11.wrap.PKCS11Session;
import org.opensc.util.PKCS11Id;

public class PKCS11PublicKey
extends PKCS11Key
implements PublicKey {
    private static final long serialVersionUID = 7370269944653220123L;
    byte[] encoded = this.getRawAttribute(17);

    protected PKCS11PublicKey(PKCS11Session pKCS11Session, int n, long l) throws PKCS11Exception {
        super(pKCS11Session, n, l);
    }

    private static PKCS11PublicKey makePublicKey(PKCS11Session pKCS11Session, long l, int n) throws PKCS11Exception {
        switch (n) {
            case 0: {
                return new PKCS11RSAPublicKey(pKCS11Session, l);
            }
            case 1: {
                return new PKCS11DSAPublicKey(pKCS11Session, l);
            }
        }
        return new PKCS11PublicKey(pKCS11Session, n, l);
    }

    public static List<PKCS11PublicKey> getPublicKeys(PKCS11Session pKCS11Session) throws PKCS11Exception {
        long[] lArray = PKCS11PublicKey.enumRawObjects(pKCS11Session, 2);
        ArrayList<PKCS11PublicKey> arrayList = new ArrayList<PKCS11PublicKey>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            int n = PKCS11Object.getULongAttribute(pKCS11Session, lArray[i], 256);
            PKCS11PublicKey pKCS11PublicKey = PKCS11PublicKey.makePublicKey(pKCS11Session, lArray[i], n);
            arrayList.add(pKCS11PublicKey);
        }
        return arrayList;
    }

    public static PKCS11PublicKey findPublicKey(PKCS11Session pKCS11Session, PKCS11Id pKCS11Id) throws PKCS11Exception {
        long l = PKCS11PublicKey.findRawObject(pKCS11Session, 2, pKCS11Id);
        int n = PKCS11Object.getULongAttribute(pKCS11Session, l, 256);
        return PKCS11PublicKey.makePublicKey(pKCS11Session, l, n);
    }

    public PKCS11PrivateKey getPrivateKey() throws PKCS11Exception {
        return PKCS11PrivateKey.findPrivateKey((PKCS11Session)this.getParent(), this.getId());
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }
}

