/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import java.io.UnsupportedEncodingException;
import javax.security.auth.DestroyFailedException;
import org.opensc.pkcs11.PKCS11Provider;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Mechanism;
import org.opensc.pkcs11.wrap.PKCS11Session;
import org.opensc.pkcs11.wrap.PKCS11SessionChild;
import org.opensc.util.DestroyableChild;
import org.opensc.util.DestroyableParent;
import org.opensc.util.PKCS11Id;

public class PKCS11Object
extends DestroyableChild
implements PKCS11SessionChild {
    protected long pvh;
    protected long shandle;
    protected long hsession;
    protected long handle;
    private PKCS11Id id;
    private String label;
    public static final int CKO_CERTIFICATE = 1;
    public static final int CKO_PUBLIC_KEY = 2;
    public static final int CKO_PRIVATE_KEY = 3;
    public static final int CKO_SECRET_KEY = 4;

    private static native long[] enumObjectsNative(long var0, long var2, long var4, PKCS11Attribute[] var6) throws PKCS11Exception;

    private static native byte[] getAttributeNative(long var0, long var2, long var4, long var6, int var8) throws PKCS11Exception;

    private static native int getULongAttributeNative(long var0, long var2, long var4, long var6, int var8) throws PKCS11Exception;

    private static native boolean getBooleanAttributeNative(long var0, long var2, long var4, long var6, int var8) throws PKCS11Exception;

    private static native PKCS11Mechanism[] getAllowedMechanismsNative(long var0, long var2, long var4, long var6) throws PKCS11Exception;

    private static native long createObjectNative(long var0, long var2, long var4, PKCS11Attribute[] var6) throws PKCS11Exception;

    private static native void deleteObjectNative(long var0, long var2, long var4, long var6) throws PKCS11Exception;

    protected byte[] getRawAttribute(int n) throws PKCS11Exception {
        return PKCS11Object.getAttributeNative(this.pvh, this.shandle, this.hsession, this.handle, n);
    }

    protected int getULongAttribute(int n) throws PKCS11Exception {
        return PKCS11Object.getULongAttributeNative(this.pvh, this.shandle, this.hsession, this.handle, n);
    }

    protected static int getULongAttribute(PKCS11Session pKCS11Session, long l, int n) throws PKCS11Exception {
        return PKCS11Object.getULongAttributeNative(pKCS11Session.getPvh(), pKCS11Session.getSlotHandle(), pKCS11Session.getHandle(), l, n);
    }

    protected boolean getBooleanAttribute(int n) throws PKCS11Exception {
        return PKCS11Object.getBooleanAttributeNative(this.pvh, this.shandle, this.hsession, this.handle, n);
    }

    protected static boolean getBooleanAttribute(PKCS11Session pKCS11Session, long l, int n) throws PKCS11Exception {
        return PKCS11Object.getBooleanAttributeNative(pKCS11Session.getPvh(), pKCS11Session.getSlotHandle(), pKCS11Session.getHandle(), l, n);
    }

    protected static long[] enumRawObjects(PKCS11Session pKCS11Session, int n) throws PKCS11Exception {
        PKCS11Attribute[] pKCS11AttributeArray = new PKCS11Attribute[]{new PKCS11Attribute(0, n)};
        return PKCS11Object.enumObjectsNative(pKCS11Session.getPvh(), pKCS11Session.getSlotHandle(), pKCS11Session.getHandle(), pKCS11AttributeArray);
    }

    protected static long[] enumRawObjects(PKCS11Session pKCS11Session) throws PKCS11Exception {
        PKCS11Attribute[] pKCS11AttributeArray = new PKCS11Attribute[]{};
        return PKCS11Object.enumObjectsNative(pKCS11Session.getPvh(), pKCS11Session.getSlotHandle(), pKCS11Session.getHandle(), pKCS11AttributeArray);
    }

    protected static long[] enumRawObjects(PKCS11Session pKCS11Session, PKCS11Attribute[] pKCS11AttributeArray) throws PKCS11Exception {
        return PKCS11Object.enumObjectsNative(pKCS11Session.getPvh(), pKCS11Session.getSlotHandle(), pKCS11Session.getHandle(), pKCS11AttributeArray);
    }

    protected static long findRawObject(PKCS11Session pKCS11Session, int n, PKCS11Id pKCS11Id) throws PKCS11Exception {
        PKCS11Attribute[] pKCS11AttributeArray = new PKCS11Attribute[]{new PKCS11Attribute(0, n), new PKCS11Attribute(258, pKCS11Id)};
        long[] lArray = PKCS11Object.enumObjectsNative(pKCS11Session.getPvh(), pKCS11Session.getSlotHandle(), pKCS11Session.getHandle(), pKCS11AttributeArray);
        if (lArray == null || lArray.length < 1) {
            throw new PKCS11Exception("The requested object with id " + pKCS11Id + " of class " + n + " was not found.");
        }
        if (lArray.length > 1) {
            throw new PKCS11Exception("There are more than one objects with id " + pKCS11Id + " of class " + n + ".");
        }
        return lArray[0];
    }

    protected static long createObject(PKCS11Session pKCS11Session, PKCS11Attribute[] pKCS11AttributeArray) throws PKCS11Exception {
        return PKCS11Object.createObjectNative(pKCS11Session.getPvh(), pKCS11Session.getSlotHandle(), pKCS11Session.getHandle(), pKCS11AttributeArray);
    }

    protected PKCS11Object(PKCS11Session pKCS11Session, long l) throws PKCS11Exception {
        super(pKCS11Session);
        this.pvh = pKCS11Session.getPvh();
        this.shandle = pKCS11Session.getSlotHandle();
        this.hsession = pKCS11Session.getHandle();
        this.handle = l;
        try {
            this.id = new PKCS11Id(this.getRawAttribute(258));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 18) {
                this.id = null;
            }
            throw pKCS11Exception;
        }
        try {
            byte[] byArray = this.getRawAttribute(3);
            this.label = new String(byArray, "UTF-8");
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 18) {
                this.label = null;
            }
            throw pKCS11Exception;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PKCS11Exception("Invalid encoding:", unsupportedEncodingException);
        }
    }

    public void deleteObject() throws PKCS11Exception {
        PKCS11Object.deleteObjectNative(this.pvh, this.shandle, this.hsession, this.handle);
    }

    public PKCS11Mechanism[] getAllowedMechanisms() throws PKCS11Exception {
        return PKCS11Object.getAllowedMechanismsNative(this.pvh, this.shandle, this.hsession, this.handle);
    }

    public PKCS11Id getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public PKCS11Provider getProvider() {
        DestroyableChild destroyableChild = (DestroyableChild)((Object)this.getParent());
        DestroyableChild destroyableChild2 = (DestroyableChild)((Object)destroyableChild.getParent());
        return (PKCS11Provider)destroyableChild2.getParent();
    }

    @Override
    public long getPvh() {
        return this.pvh;
    }

    @Override
    public long getSlotHandle() {
        return this.shandle;
    }

    @Override
    public long getSessionHandle() {
        return this.hsession;
    }

    @Override
    public PKCS11Session getSession() {
        DestroyableParent destroyableParent = this.getParent();
        if (destroyableParent instanceof PKCS11Session) {
            return (PKCS11Session)destroyableParent;
        }
        return null;
    }

    @Override
    public long getHandle() {
        return this.handle;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.pvh = 0L;
        this.shandle = 0L;
        this.hsession = 0L;
        this.handle = 0L;
        super.destroy();
    }
}

