/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.wrap;

import org.opensc.util.PKCS11Id;

public class PKCS11Attribute {
    public static final int CKA_CLASS = 0;
    public static final int CKA_TOKEN = 1;
    public static final int CKA_PRIVATE = 2;
    public static final int CKA_LABEL = 3;
    public static final int CKA_APPLICATION = 16;
    public static final int CKA_VALUE = 17;
    public static final int CKA_OBJECT_ID = 18;
    public static final int CKA_CERTIFICATE_TYPE = 128;
    public static final int CKA_ISSUER = 129;
    public static final int CKA_SERIAL_NUMBER = 130;
    public static final int CKA_AC_ISSUER = 131;
    public static final int CKA_OWNER = 132;
    public static final int CKA_ATTR_TYPES = 133;
    public static final int CKA_TRUSTED = 134;
    public static final int CKA_CERTIFICATE_CATEGORY = 135;
    public static final int CKA_JAVA_MIDP_SECURITY_DOMAIN = 136;
    public static final int CKA_URL = 137;
    public static final int CKA_HASH_OF_SUBJECT_PUBLIC_KEY = 138;
    public static final int CKA_HASH_OF_ISSUER_PUBLIC_KEY = 139;
    public static final int CKA_CHECK_VALUE = 144;
    public static final int CKA_KEY_TYPE = 256;
    public static final int CKA_SUBJECT = 257;
    public static final int CKA_ID = 258;
    public static final int CKA_SENSITIVE = 259;
    public static final int CKA_ENCRYPT = 260;
    public static final int CKA_DECRYPT = 261;
    public static final int CKA_WRAP = 262;
    public static final int CKA_UNWRAP = 263;
    public static final int CKA_SIGN = 264;
    public static final int CKA_SIGN_RECOVER = 265;
    public static final int CKA_VERIFY = 266;
    public static final int CKA_VERIFY_RECOVER = 267;
    public static final int CKA_DERIVE = 268;
    public static final int CKA_START_DATE = 272;
    public static final int CKA_END_DATE = 273;
    public static final int CKA_MODULUS = 288;
    public static final int CKA_MODULUS_BITS = 289;
    public static final int CKA_PUBLIC_EXPONENT = 290;
    public static final int CKA_PRIVATE_EXPONENT = 291;
    public static final int CKA_PRIME_1 = 292;
    public static final int CKA_PRIME_2 = 293;
    public static final int CKA_EXPONENT_1 = 294;
    public static final int CKA_EXPONENT_2 = 295;
    public static final int CKA_COEFFICIENT = 296;
    public static final int CKA_PRIME = 304;
    public static final int CKA_SUBPRIME = 305;
    public static final int CKA_BASE = 306;
    public static final int CKA_PRIME_BITS = 307;
    public static final int CKA_SUB_PRIME_BITS = 308;
    public static final int CKA_VALUE_BITS = 352;
    public static final int CKA_VALUE_LEN = 353;
    public static final int CKA_EXTRACTABLE = 354;
    public static final int CKA_LOCAL = 355;
    public static final int CKA_NEVER_EXTRACTABLE = 356;
    public static final int CKA_ALWAYS_SENSITIVE = 357;
    public static final int CKA_KEY_GEN_MECHANISM = 358;
    public static final int CKA_MODIFIABLE = 368;
    public static final int CKA_ECDSA_PARAMS = 384;
    public static final int CKA_EC_PARAMS = 384;
    public static final int CKA_EC_POINT = 385;
    public static final int CKA_SECONDARY_AUTH = 512;
    public static final int CKA_AUTH_PIN_FLAGS = 513;
    public static final int CKA_ALWAYS_AUTHENTICATE = 514;
    public static final int CKA_WRAP_WITH_TRUSTED = 528;
    private static final int LITTLE_ENDIAN = 0;
    private static final int BIG_ENDIAN = 1;
    private static int endianness;
    private static int wordsize;
    private int kind;
    private byte[] data;

    public PKCS11Attribute(int n, byte[] byArray) {
        this.kind = n;
        this.data = byArray;
    }

    public PKCS11Attribute(int n, PKCS11Id pKCS11Id) {
        this.kind = n;
        this.data = pKCS11Id.getData();
    }

    public PKCS11Attribute(int n, int n2) {
        this.kind = n;
        this.data = new byte[wordsize >> 3];
        if (endianness == 0) {
            this.data[0] = (byte)n2;
            this.data[1] = (byte)(n2 >> 8);
            this.data[2] = (byte)(n2 >> 16);
            this.data[3] = (byte)(n2 >> 24);
        } else {
            int n3 = this.data.length - 4;
            this.data[n3++] = (byte)(n2 >> 24);
            this.data[n3++] = (byte)(n2 >> 16);
            this.data[n3++] = (byte)(n2 >> 8);
            this.data[n3++] = (byte)n2;
        }
    }

    public PKCS11Attribute(int n, boolean bl) {
        this.kind = n;
        this.data = new byte[1];
        this.data[0] = bl ? (byte)1 : 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getKind() {
        return this.kind;
    }

    static {
        int n = endianness = "little".equalsIgnoreCase(System.getProperty("sun.cpu.endian")) ? 0 : 1;
        wordsize = System.getProperty("os.name").contains("Windows") ? 32 : (System.getProperty("os.arch").endsWith("64") ? 64 : 32);
    }
}

