/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.spi;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import org.opensc.pkcs11.PKCS11Provider;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Session;
import org.opensc.pkcs11.wrap.PKCS11SessionChild;

public class PKCS11SignatureSpi
extends SignatureSpi {
    PKCS11Provider provider;
    String algorithm;
    PKCS11SessionChild worker;
    PrivateKey privateKey;
    PublicKey publicKey;
    byte[] inputcollector;

    private native void initSignNative(long var1, long var3, long var5, long var7, int var9) throws PKCS11Exception;

    private native void updateSignNative(long var1, long var3, long var5, byte[] var7, int var8, int var9) throws PKCS11Exception;

    private native void updateSignNative1(long var1, long var3, long var5, byte var7) throws PKCS11Exception;

    private native byte[] signNative(long var1, long var3, long var5) throws PKCS11Exception;

    private native void initVerifyNative(long var1, long var3, long var5, long var7, int var9) throws PKCS11Exception;

    private native void updateVerifyNative(long var1, long var3, long var5, byte[] var7, int var8, int var9) throws PKCS11Exception;

    private native void updateVerifyNative1(long var1, long var3, long var5, byte var7) throws PKCS11Exception;

    private native boolean verifyNative(long var1, long var3, long var5, byte[] var7) throws PKCS11Exception;

    public PKCS11SignatureSpi(PKCS11Provider pKCS11Provider, String string) {
        this.provider = pKCS11Provider;
        this.algorithm = string;
        this.inputcollector = null;
    }

    private int getPKCS11MechanismType() throws InvalidKeyException {
        int n;
        if (this.algorithm.equals("NONEwithRSA")) {
            n = 1;
        } else if (this.algorithm.equals("MD5withRSA")) {
            n = 5;
        } else if (this.algorithm.equals("SHA1withRSA")) {
            n = 6;
        } else if (this.algorithm.equals("SHA256withRSA")) {
            n = 64;
        } else if (this.algorithm.equals("SHA384withRSA")) {
            n = 65;
        } else if (this.algorithm.equals("SHA512withRSA")) {
            n = 66;
        } else if (this.algorithm.equals("SHA1withDSA")) {
            n = 18;
        } else if (this.algorithm.equals("NONEwithDSA")) {
            n = 17;
        } else {
            throw new InvalidKeyException("Signature algorithm [" + this.algorithm + "] is unsupported.");
        }
        return n;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof PKCS11SessionChild)) {
            throw new InvalidKeyException("PKCS11 signature engine expects a valid PKCS11 object.");
        }
        if (!this.algorithm.endsWith(publicKey.getAlgorithm())) {
            throw new InvalidKeyException("PKCS11 key algorithm [" + publicKey.getAlgorithm() + "] is incompatible with signature algorithm [" + this.algorithm + "].");
        }
        int n = this.getPKCS11MechanismType();
        if (n == 1) {
            this.inputcollector = new byte[0];
        }
        this.worker = (PKCS11SessionChild)((Object)publicKey);
        this.publicKey = publicKey;
        this.privateKey = null;
        try {
            PKCS11Session pKCS11Session = this.worker.getSession();
            pKCS11Session.verifyInit(this.worker.getHandle(), n, null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("PKCS11 exception", pKCS11Exception);
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof PKCS11SessionChild)) {
            throw new InvalidKeyException("PKCS11 signature engine expects a valid PKCS11 object.");
        }
        if (!this.algorithm.endsWith(privateKey.getAlgorithm())) {
            throw new InvalidKeyException("PKCS11 key algorithm [" + privateKey.getAlgorithm() + "] is incompatible with signature algorithm [" + this.algorithm + "].");
        }
        int n = this.getPKCS11MechanismType();
        if (n == 1) {
            this.inputcollector = new byte[0];
        }
        this.worker = (PKCS11SessionChild)((Object)privateKey);
        this.publicKey = null;
        this.privateKey = privateKey;
        try {
            PKCS11Session pKCS11Session = this.worker.getSession();
            pKCS11Session.signInit(this.worker.getHandle(), n, null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("PKCS11 exception", pKCS11Exception);
        }
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        if (this.worker == null) {
            throw new SignatureException("Signature not initialized through initSign() or initVerify().");
        }
        if (this.inputcollector != null) {
            int n = this.inputcollector.length;
            byte[] byArray = new byte[n + 1];
            System.arraycopy(this.inputcollector, 0, byArray, 0, n);
            byArray[n - 1] = by;
            this.inputcollector = byArray;
            return;
        }
        try {
            PKCS11Session pKCS11Session = this.worker.getSession();
            if (this.privateKey != null) {
                pKCS11Session.signUpdate(by);
            } else {
                pKCS11Session.verifyUpdate(by);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SignatureException("PKCS11 exception", pKCS11Exception);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.worker == null) {
            throw new SignatureException("Signature not initialized through initSign() or initVerify().");
        }
        if (this.inputcollector != null) {
            int n3 = this.inputcollector.length;
            byte[] byArray2 = new byte[n3 + n2];
            System.arraycopy(this.inputcollector, 0, byArray2, 0, n3);
            System.arraycopy(byArray, 0, byArray2, n3, n2);
            this.inputcollector = byArray2;
            return;
        }
        try {
            PKCS11Session pKCS11Session = this.worker.getSession();
            if (this.privateKey != null) {
                pKCS11Session.signUpdate(byArray, n, n2);
            } else {
                pKCS11Session.verifyUpdate(byArray, n, n2);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SignatureException("PKCS11 exception", pKCS11Exception);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.worker == null) {
            throw new SignatureException("Signature not initialized through initSign() or initVerify().");
        }
        if (this.privateKey == null) {
            throw new SignatureException("Signature not initialized through initSign().");
        }
        try {
            PKCS11Session pKCS11Session = this.worker.getSession();
            if (this.inputcollector != null) {
                return pKCS11Session.sign(this.inputcollector);
            }
            return pKCS11Session.signFinal();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SignatureException("PKCS11 exception", pKCS11Exception);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.worker == null) {
            throw new SignatureException("Signature not initialized through initSign() or initVerify().");
        }
        if (this.publicKey == null) {
            throw new SignatureException("Signature not initialized through initVerify().");
        }
        try {
            PKCS11Session pKCS11Session = this.worker.getSession();
            if (this.inputcollector != null) {
                return pKCS11Session.verify(this.inputcollector, byArray);
            }
            return pKCS11Session.verifyFinal(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SignatureException("PKCS11 exception", pKCS11Exception);
        }
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter [" + string + "] is not recognized by the PKCS11 signature engine.");
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter [" + string + "] is not recognized by the PKCS11 signature engine.");
    }
}

