/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.util;

import java.util.HashSet;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.opensc.util.DestroyableChild;
import org.opensc.util.DestroyableParent;

public class DestroyableHolder
extends DestroyableChild
implements DestroyableParent {
    private Set<Destroyable> children = null;

    public DestroyableHolder() {
    }

    @Override
    public void register(Destroyable destroyable) {
        if (this.children == null) {
            this.children = new HashSet<Destroyable>();
        }
        this.children.add(destroyable);
    }

    @Override
    public void deregister(Destroyable destroyable) {
        if (this.children == null) {
            return;
        }
        this.children.remove(destroyable);
    }

    public DestroyableHolder(DestroyableParent destroyableParent) {
        super(destroyableParent);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (this.children != null) {
            for (Destroyable destroyable : this.children) {
                if (destroyable.isDestroyed()) continue;
                if (destroyable instanceof DestroyableChild) {
                    ((DestroyableChild)destroyable).unlink();
                }
                destroyable.destroy();
            }
            this.children = null;
        }
        super.destroy();
    }
}

