/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11.spi;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensc.pkcs11.PKCS11Provider;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11PrivateKey;
import org.opensc.pkcs11.wrap.PKCS11PublicKey;
import org.opensc.pkcs11.wrap.PKCS11SessionChild;

public class PKCS11CipherSpi
extends CipherSpi {
    static Log log = LogFactory.getLog(PKCS11CipherSpi.class);
    PKCS11Provider provider;
    String algorithm;
    PKCS11SessionChild worker;
    PrivateKey privateKey;
    PublicKey publicKey;
    int mode;
    long count;

    public PKCS11CipherSpi(PKCS11Provider pKCS11Provider, String string) {
        this.provider = pKCS11Provider;
        this.algorithm = string;
        this.mode = 0;
        this.count = 0L;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equals("ECB")) {
            throw new NoSuchAlgorithmException("Only ECB mode is supported.");
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equals("PKCS1Padding")) {
            throw new NoSuchPaddingException("Only PKCS1Padding is supported.");
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PKCS11PrivateKey) {
            return ((PKCS11PrivateKey)key).getKeyBits();
        }
        if (key instanceof PKCS11PublicKey) {
            return ((PKCS11PublicKey)key).getKeyBits();
        }
        throw new InvalidKeyException("Invalid key class " + key.getClass());
    }

    @Override
    protected int engineGetBlockSize() {
        if (this.privateKey != null) {
            return ((PKCS11PrivateKey)this.privateKey).getKeyBits() / 8;
        }
        if (this.publicKey != null && this.publicKey instanceof PKCS11PublicKey) {
            return ((PKCS11PublicKey)this.publicKey).getKeyBits() / 8;
        }
        return 1;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        int n2 = this.engineGetBlockSize();
        return (n + n2 - 1) / n2;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private int getPKCS11MechanismType() throws InvalidKeyException {
        if (!this.algorithm.equals("RSA/ECB/PKCS1Padding")) {
            throw new InvalidKeyException("Signature algorithm [" + this.algorithm + "] is unsupported.");
        }
        int n = 1;
        return n;
    }

    private native void initEncryptNative(long var1, long var3, long var5, long var7, int var9) throws PKCS11Exception;

    private native void initDecryptNative(long var1, long var3, long var5, long var7, int var9) throws PKCS11Exception;

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n == 1) {
            if (!(key instanceof PKCS11SessionChild)) {
                throw new InvalidKeyException("PKCS11 signature engine expects a valid PKCS11 object.");
            }
            if (!this.algorithm.startsWith(key.getAlgorithm())) {
                throw new InvalidKeyException("PKCS11 key algorithm [" + key.getAlgorithm() + "] is incompatible with signature algorithm [" + this.algorithm + "].");
            }
            int n2 = this.getPKCS11MechanismType();
            this.worker = (PKCS11SessionChild)((Object)key);
            if (key instanceof PublicKey) {
                this.publicKey = (PublicKey)key;
                this.privateKey = null;
            } else if (key instanceof PrivateKey) {
                this.publicKey = null;
                this.privateKey = (PrivateKey)key;
            } else {
                throw new InvalidKeyException("PKCS11 signature engine expects a public or private key for encryption mode.");
            }
            this.mode = n;
            try {
                this.initEncryptNative(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), n2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new InvalidKeyException("PKCS11 exception initializing encryption:", pKCS11Exception);
            }
        } else if (n == 2) {
            if (!(key instanceof PKCS11SessionChild)) {
                throw new InvalidKeyException("PKCS11 signature engine expects a valid PKCS11 object.");
            }
            if (!this.algorithm.startsWith(key.getAlgorithm())) {
                throw new InvalidKeyException("PKCS11 key algorithm [" + key.getAlgorithm() + "] is incompatible with signature algorithm [" + this.algorithm + "].");
            }
            int n3 = this.getPKCS11MechanismType();
            this.worker = (PKCS11SessionChild)((Object)key);
            if (key instanceof PublicKey) {
                this.publicKey = (PublicKey)key;
                this.privateKey = null;
            } else if (key instanceof PrivateKey) {
                this.publicKey = null;
                this.privateKey = (PrivateKey)key;
            } else {
                throw new InvalidKeyException("PKCS11 signature engine expects a public or private key for decryption mode.");
            }
            this.mode = n;
            try {
                this.initDecryptNative(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), n3);
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new InvalidKeyException("PKCS11 exception initializing decryption:", pKCS11Exception);
            }
        } else {
            throw new InvalidKeyException("Invalid operation mode [" + n + "] in PKCS11CipherSpi.engineInit().");
        }
        this.count = 0L;
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    private native byte[] updateDecryptNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11) throws PKCS11Exception;

    private native byte[] updateEncryptNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11) throws PKCS11Exception;

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        try {
            this.count += (long)n2;
            if (this.mode == 2) {
                return this.updateDecryptNative(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2);
            }
            return this.updateEncryptNative(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            log.error((Object)"PKCS11Exception caught:", (Throwable)pKCS11Exception);
            return null;
        }
    }

    private native int updateDecryptNativeOff(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11, byte[] var12, int var13) throws PKCS11Exception;

    private native int updateEncryptNativeOff(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11, byte[] var12, int var13) throws PKCS11Exception;

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        try {
            this.count += (long)n2;
            if (this.mode == 2) {
                return this.updateDecryptNativeOff(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2, byArray2, n3);
            }
            return this.updateEncryptNativeOff(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2, byArray2, n3);
        }
        catch (PKCS11Exception pKCS11Exception) {
            log.error((Object)"PKCS11Exception caught:", (Throwable)pKCS11Exception);
            throw new ShortBufferException("PKCS11 exception:" + pKCS11Exception);
        }
    }

    private native byte[] doFinalDecryptNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11) throws PKCS11Exception;

    private native byte[] doFinalEncryptNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11) throws PKCS11Exception;

    private native byte[] doDecryptNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11) throws PKCS11Exception;

    private native byte[] doEncryptNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11) throws PKCS11Exception;

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2;
        try {
            byArray2 = this.mode == 2 ? (this.count == 0L ? this.doDecryptNative(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2) : this.doFinalDecryptNative(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2)) : (this.count == 0L ? this.doEncryptNative(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2) : this.doFinalEncryptNative(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2));
        }
        catch (PKCS11Exception pKCS11Exception) {
            log.error((Object)"PKCS11Exception caught:", (Throwable)pKCS11Exception);
            throw new IllegalBlockSizeException("PKCS11Exception caught:" + pKCS11Exception);
        }
        this.count = 0L;
        return byArray2;
    }

    private native int doFinalDecryptNativeOff(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11, byte[] var12, int var13) throws PKCS11Exception;

    private native int doFinalEncryptNativeOff(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11, byte[] var12, int var13) throws PKCS11Exception;

    private native int doDecryptNativeOff(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11, byte[] var12, int var13) throws PKCS11Exception;

    private native int doEncryptNativeOff(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11, byte[] var12, int var13) throws PKCS11Exception;

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4;
        try {
            n4 = this.mode == 2 ? (this.count == 0L ? this.doDecryptNativeOff(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2, byArray2, n3) : this.doFinalDecryptNativeOff(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2, byArray2, n3)) : (this.count == 0L ? this.doEncryptNativeOff(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2, byArray2, n3) : this.doFinalEncryptNativeOff(this.worker.getPvh(), this.worker.getSlotHandle(), this.worker.getSessionHandle(), this.worker.getHandle(), byArray, n, n2, byArray2, n3));
        }
        catch (PKCS11Exception pKCS11Exception) {
            log.error((Object)"PKCS11Exception caught:", (Throwable)pKCS11Exception);
            throw new ShortBufferException("PKCS11 exception:" + pKCS11Exception);
        }
        this.count = 0L;
        return n4;
    }
}

