/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11;

import java.io.IOException;
import java.security.KeyStore;
import java.util.List;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensc.pkcs11.PKCS11EventCallback;
import org.opensc.pkcs11.PKCS11LoadStoreParameter;
import org.opensc.pkcs11.PKCS11Provider;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Session;
import org.opensc.pkcs11.wrap.PKCS11Slot;

public class PKCS11SessionStore
implements KeyStore.LoadStoreParameter {
    private static Log log = LogFactory.getLog(PKCS11SessionStore.class);
    PKCS11Slot slot = null;
    PKCS11Session session = null;
    PKCS11EventCallback cb = null;
    CallbackHandler eventHandler;
    KeyStore.ProtectionParameter protectionParameter = null;

    private void changeEvent(int n) throws IOException {
        this.cb.setEvent(n);
        if (this.eventHandler == null) {
            return;
        }
        try {
            this.eventHandler.handle(new Callback[]{this.cb});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            log.warn((Object)("PKCSEventCallback not supported by CallbackHandler [" + this.eventHandler.getClass() + "]"), (Throwable)unsupportedCallbackException);
        }
    }

    private void eventFailed(Exception exception) throws IOException {
        int n;
        switch (this.cb.getEvent()) {
            default: {
                n = 1;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 4: 
            case 12: {
                PKCS11Exception pKCS11Exception;
                if (exception instanceof IOException && !(exception instanceof PKCS11Exception)) {
                    n = this.cb.getEvent() == 12 ? 14 : 6;
                    break;
                }
                if (exception instanceof PKCS11Exception && ((pKCS11Exception = (PKCS11Exception)exception).getErrorCode() == 80 || pKCS11Exception.getErrorCode() == 1)) {
                    n = this.cb.getEvent() == 12 ? 14 : 6;
                    break;
                }
                n = this.cb.getEvent() == 12 ? 13 : 5;
                break;
            }
            case 7: 
            case 16: {
                PKCS11Exception pKCS11Exception;
                if (exception instanceof PKCS11Exception && ((pKCS11Exception = (PKCS11Exception)exception).getErrorCode() == 80 || pKCS11Exception.getErrorCode() == 1)) {
                    n = this.cb.getEvent() == 16 ? 18 : 10;
                    break;
                }
                n = this.cb.getEvent() == 16 ? 17 : 9;
                break;
            }
            case 8: {
                n = 9;
                break;
            }
            case 15: {
                n = 17;
            }
        }
        this.changeEvent(n);
        this.close();
    }

    public void open(PKCS11Provider pKCS11Provider, KeyStore.LoadStoreParameter loadStoreParameter) throws IOException {
        if (this.slot != null) {
            this.close();
        }
        this.cb = new PKCS11EventCallback(0);
        this.eventHandler = null;
        if (loadStoreParameter instanceof PKCS11LoadStoreParameter) {
            this.eventHandler = ((PKCS11LoadStoreParameter)loadStoreParameter).getEventHandler();
        }
        try {
            PKCS11LoadStoreParameter pKCS11LoadStoreParameter = null;
            if (loadStoreParameter instanceof PKCS11LoadStoreParameter) {
                pKCS11LoadStoreParameter = (PKCS11LoadStoreParameter)loadStoreParameter;
            }
            PKCS11Slot pKCS11Slot = null;
            if (pKCS11LoadStoreParameter != null && pKCS11LoadStoreParameter.getSlotId() != null) {
                pKCS11Slot = new PKCS11Slot(pKCS11Provider, pKCS11LoadStoreParameter.getSlotId());
                if (!pKCS11Slot.isTokenPresent() && pKCS11LoadStoreParameter.isWaitForSlot()) {
                    pKCS11Slot.destroy();
                    this.changeEvent(2);
                    pKCS11Slot = PKCS11Slot.waitForSlot(pKCS11Provider);
                    if (pKCS11Slot.getId() != pKCS11LoadStoreParameter.getSlotId().longValue()) {
                        pKCS11Slot.destroy();
                        throw new PKCS11Exception("A token has been inserted in slot number " + pKCS11Slot.getId() + " instead of slot number " + pKCS11LoadStoreParameter.getSlotId());
                    }
                }
            } else {
                List<PKCS11Slot> list = PKCS11Slot.enumerateSlots(pKCS11Provider);
                for (PKCS11Slot pKCS11Slot2 : list) {
                    if (pKCS11Slot == null && pKCS11Slot2.isTokenPresent()) {
                        pKCS11Slot = pKCS11Slot2;
                        continue;
                    }
                    pKCS11Slot2.destroy();
                }
                if (pKCS11Slot == null && pKCS11LoadStoreParameter != null && pKCS11LoadStoreParameter.isWaitForSlot()) {
                    this.changeEvent(2);
                    pKCS11Slot = PKCS11Slot.waitForSlot(pKCS11Provider);
                }
            }
            if (pKCS11Slot == null) {
                throw new PKCS11Exception("Could not find a valid slot with a present token.");
            }
            if (!pKCS11Slot.isTokenPresent()) {
                long l = pKCS11Slot.getId();
                pKCS11Slot.destroy();
                throw new PKCS11Exception("No token is present in the given slot number " + l);
            }
            this.slot = pKCS11Slot;
            int n = 0;
            if (pKCS11LoadStoreParameter != null && pKCS11LoadStoreParameter.isWriteEnabled()) {
                n = 1;
            }
            this.session = PKCS11Session.open(this.slot, n);
            if (pKCS11LoadStoreParameter != null) {
                this.authenticateSO(pKCS11LoadStoreParameter.getSOProtectionParameter());
            }
            this.authenticate(loadStoreParameter.getProtectionParameter());
        }
        catch (IOException iOException) {
            this.eventFailed(iOException);
            throw iOException;
        }
        catch (DestroyFailedException destroyFailedException) {
            this.eventFailed(destroyFailedException);
            throw new PKCS11Exception("destroy exception caught: ", destroyFailedException);
        }
    }

    public void close() {
        if (this.slot != null) {
            try {
                this.slot.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                log.warn((Object)"Cannot destroy slot:", (Throwable)destroyFailedException);
            }
        }
        this.slot = null;
        this.session = null;
        this.protectionParameter = null;
        this.cb = null;
        this.eventHandler = null;
    }

    public void authenticate(KeyStore.ProtectionParameter protectionParameter) throws IOException {
        this.protectionParameter = protectionParameter;
        try {
            if (this.protectionParameter instanceof KeyStore.PasswordProtection) {
                this.changeEvent(8);
                KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)this.protectionParameter;
                this.session.loginUser(passwordProtection.getPassword());
                this.changeEvent(11);
            } else if (this.protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
                KeyStore.CallbackHandlerProtection callbackHandlerProtection = (KeyStore.CallbackHandlerProtection)this.protectionParameter;
                char[] cArray = null;
                if (this.slot.hasTokenProtectedAuthPath()) {
                    this.changeEvent(7);
                } else {
                    this.changeEvent(4);
                    CallbackHandler callbackHandler = callbackHandlerProtection.getCallbackHandler();
                    PasswordCallback passwordCallback = new PasswordCallback("Please enter the user pin:", false);
                    callbackHandler.handle(new Callback[]{passwordCallback});
                    cArray = passwordCallback.getPassword();
                    this.changeEvent(8);
                }
                this.session.loginUser(cArray);
                this.changeEvent(11);
            }
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new PKCS11Exception("PasswordCallback is not supported", unsupportedCallbackException);
        }
    }

    public void authenticateSO(KeyStore.ProtectionParameter protectionParameter) throws IOException {
        try {
            if (protectionParameter instanceof KeyStore.PasswordProtection) {
                KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)protectionParameter;
                this.changeEvent(15);
                this.session.loginSO(passwordProtection.getPassword());
                this.changeEvent(19);
            } else if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
                KeyStore.CallbackHandlerProtection callbackHandlerProtection = (KeyStore.CallbackHandlerProtection)protectionParameter;
                char[] cArray = null;
                if (this.slot.hasTokenProtectedAuthPath()) {
                    this.changeEvent(16);
                } else {
                    this.changeEvent(12);
                    CallbackHandler callbackHandler = callbackHandlerProtection.getCallbackHandler();
                    PasswordCallback passwordCallback = new PasswordCallback("Please enter the SO pin:", false);
                    callbackHandler.handle(new Callback[]{passwordCallback});
                    cArray = passwordCallback.getPassword();
                    this.changeEvent(15);
                }
                this.session.loginSO(cArray);
                this.changeEvent(19);
            }
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new PKCS11Exception("PasswordCallback is not supported", unsupportedCallbackException);
        }
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public PKCS11Slot getSlot() {
        return this.slot;
    }

    @Override
    public KeyStore.ProtectionParameter getProtectionParameter() {
        return this.getProtectionParameter();
    }
}

